/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.crafting.FluidEntry;
import com.mrcrayfish.vehicle.inventory.container.FluidExtractorContainer;
import com.mrcrayfish.vehicle.tileentity.FluidExtractorTileEntity;
import com.mrcrayfish.vehicle.util.FluidUtils;
import com.mrcrayfish.vehicle.util.RenderUtil;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class FluidExtractorScreen
extends ContainerScreen<FluidExtractorContainer> {
    private static final ResourceLocation GUI = new ResourceLocation("vehicle:textures/gui/fluid_extractor.png");
    private PlayerInventory playerInventory;
    private FluidExtractorTileEntity fluidExtractorTileEntity;

    public FluidExtractorScreen(FluidExtractorContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.playerInventory = playerInventory;
        this.fluidExtractorTileEntity = container.getFluidExtractor();
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        if (this.fluidExtractorTileEntity.getFluidStackTank() != null) {
            FluidStack stack = this.fluidExtractorTileEntity.getFluidStackTank();
            if (this.isMouseWithinRegion(startX + 127, startY + 14, 16, 59, mouseX, mouseY)) {
                if (stack.getAmount() > 0) {
                    this.func_238654_b_(matrixStack, Lists.transform(Arrays.asList(new StringTextComponent(stack.getDisplayName().getString()), new StringTextComponent(TextFormatting.GRAY.toString() + this.fluidExtractorTileEntity.getFluidLevel() + "/" + this.fluidExtractorTileEntity.getCapacity() + " mB")), ITextComponent::func_241878_f), mouseX, mouseY);
                } else {
                    this.func_238654_b_(matrixStack, Lists.transform(Collections.singletonList(new StringTextComponent("No Fluid")), ITextComponent::func_241878_f), mouseX, mouseY);
                }
            }
        }
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.field_230706_i_.field_71466_p.func_238421_b_(matrixStack, this.fluidExtractorTileEntity.func_145748_c_().getString(), 8.0f, 6.0f, 0x404040);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrixStack, this.playerInventory.func_145748_c_().getString(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.field_230706_i_.func_110434_K().func_110577_a(GUI);
        this.func_238474_b_(matrixStack, startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.fluidExtractorTileEntity.getRemainingFuel() >= 0) {
            int remainingFuel = (int)(14.0 * ((double)this.fluidExtractorTileEntity.getRemainingFuel() / (double)this.fluidExtractorTileEntity.getFuelMaxProgress()));
            this.func_238474_b_(matrixStack, startX + 64, startY + 53 + 14 - remainingFuel, 176, 14 - remainingFuel, 14, remainingFuel + 1);
        }
        if (this.fluidExtractorTileEntity.canExtract()) {
            int left = startX + 93 + 1;
            int top = startY + 34;
            int right = left + 23 - 1;
            int bottom = top + 16;
            FluidEntry fluidExtract = this.fluidExtractorTileEntity.getCurrentRecipe().getResult();
            int fluidColor = -1;
            if (fluidExtract != null) {
                fluidColor = 0xFF000000 | FluidUtils.getAverageFluidColor(fluidExtract.getFluid());
            }
            RenderUtil.drawGradientRectHorizontal(left, top, right, bottom, -1, fluidColor);
            this.func_238474_b_(matrixStack, startX + 93, startY + 34, 176, 14, 23, 16);
            double extractionPercentage = (double)this.fluidExtractorTileEntity.getExtractionProgress() / (double)((Integer)Config.SERVER.extractorExtractTime.get()).intValue();
            int extractionProgress = (int)(22.0 * extractionPercentage + 1.0);
            this.func_238474_b_(matrixStack, startX + 93 + extractionProgress, startY + 34, 93 + extractionProgress, 34, 23 - extractionProgress, 17);
        }
        this.drawFluidTank(this.fluidExtractorTileEntity.getFluidStackTank(), matrixStack, startX + 127, startY + 14, (double)this.fluidExtractorTileEntity.getFluidLevel() / (double)this.fluidExtractorTileEntity.getCapacity(), 59);
    }

    private void drawFluidTank(FluidStack fluid, MatrixStack matrixStack, int x, int y, double level, int height) {
        FluidUtils.drawFluidTankInGUI(fluid, x, y, level, height);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GUI);
        this.func_238474_b_(matrixStack, x, y, 176, 44, 16, 59);
    }

    private boolean isMouseWithinRegion(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }
}

