/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.crafting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mrcrayfish.vehicle.crafting.VehicleRecipe;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class VehicleRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<VehicleRecipe> {
    public VehicleRecipe read(ResourceLocation recipeId, JsonObject json) {
        ImmutableList.Builder builder = ImmutableList.builder();
        JsonArray input = JSONUtils.func_151214_t((JsonObject)json, (String)"materials");
        for (int i = 0; i < input.size(); ++i) {
            JsonObject itemObject = input.get(i).getAsJsonObject();
            String itemName = JSONUtils.func_151200_h((JsonObject)itemObject, (String)"item");
            ResourceLocation id = new ResourceLocation(itemName);
            if (id.func_110624_b().equals("cfm") && !ModList.get().isLoaded("cfm")) continue;
            ItemStack stack = CraftingHelper.getItemStack((JsonObject)itemObject, (boolean)false);
            builder.add((Object)stack);
        }
        if (!json.has("vehicle")) {
            throw new JsonSyntaxException("Missing vehicle entry");
        }
        ResourceLocation vehicle = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"vehicle"));
        Optional optional = EntityType.func_220327_a((String)JSONUtils.func_151200_h((JsonObject)json, (String)"vehicle"));
        if (!optional.isPresent()) {
            throw new JsonSyntaxException("Invalid vehicle entity: " + vehicle.toString());
        }
        return new VehicleRecipe(recipeId, (EntityType)optional.get(), (ImmutableList<ItemStack>)builder.build());
    }

    @Nullable
    public VehicleRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(buffer.func_192575_l());
        ImmutableList.Builder builder = ImmutableList.builder();
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            builder.add((Object)VehicleRecipeSerializer.readItemStack(buffer));
        }
        return new VehicleRecipe(recipeId, entityType, (ImmutableList<ItemStack>)builder.build());
    }

    public void write(PacketBuffer buffer, VehicleRecipe recipe) {
        buffer.func_192572_a(recipe.getVehicle().getRegistryName());
        buffer.func_150787_b(recipe.getMaterials().size());
        for (ItemStack stack : recipe.getMaterials()) {
            VehicleRecipeSerializer.writeItemStack(buffer, stack);
        }
    }

    private static void writeItemStack(PacketBuffer buffer, ItemStack stack) {
        if (stack.func_190926_b()) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            Item item = stack.func_77973_b();
            buffer.func_150787_b(Item.func_150891_b((Item)item));
            buffer.func_150787_b(stack.func_190916_E());
            buffer.func_150786_a(stack.func_77978_p());
        }
    }

    private static ItemStack readItemStack(PacketBuffer buffer) {
        if (buffer.readBoolean()) {
            int id = buffer.func_150792_a();
            int count = buffer.func_150792_a();
            ItemStack itemstack = new ItemStack((IItemProvider)Item.func_150899_d((int)id), count);
            itemstack.readShareTag(buffer.func_150793_b());
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }
}

