/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.item;

import com.mrcrayfish.vehicle.item.IDyeable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class SprayCanItem
extends Item
implements IDyeable {
    public static final int MAX_SPRAYS = 5;

    public SprayCanItem(Item.Properties properties) {
        super(properties);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            tooltip.addAll(Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)new TranslationTextComponent("item.vehicle.spray_can.info"), 150).stream().map(text -> new StringTextComponent(text.toString())).collect(Collectors.toList()));
        } else {
            if (this.hasColor(stack)) {
                tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.color", (Object[])new Object[]{TextFormatting.DARK_GRAY.toString() + String.format("#%06X", this.getColor(stack))})));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"item.vehicle.spray_can.empty", (Object[])new Object[0])));
            }
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.info_help", (Object[])new Object[0])));
        }
    }

    public static CompoundNBT getStackTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
        if (stack.func_77973_b() instanceof SprayCanItem) {
            SprayCanItem sprayCan = (SprayCanItem)stack.func_77973_b();
            CompoundNBT compound = stack.func_77978_p();
            if (compound != null && !compound.func_150297_b("RemainingSprays", 3)) {
                compound.func_74768_a("RemainingSprays", sprayCan.getCapacity(stack));
            }
        }
        return stack.func_77978_p();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound != null && compound.func_150297_b("RemainingSprays", 3)) {
            int remainingSprays = compound.func_74762_e("RemainingSprays");
            return this.hasColor(stack) && remainingSprays < this.getCapacity(stack);
        }
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound != null && compound.func_150297_b("RemainingSprays", 3)) {
            return 1.0 - (double)compound.func_74762_e("RemainingSprays") / (double)this.getCapacity(stack);
        }
        return 0.0;
    }

    public float getRemainingSprays(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound != null && compound.func_150297_b("RemainingSprays", 3)) {
            return (float)compound.func_74762_e("RemainingSprays") / (float)this.getCapacity(stack);
        }
        return 0.0f;
    }

    public int getCapacity(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound != null && compound.func_150297_b("Capacity", 3)) {
            return compound.func_74762_e("Capacity");
        }
        return 5;
    }

    public void refill(ItemStack stack) {
        CompoundNBT compound = SprayCanItem.getStackTag(stack);
        compound.func_74768_a("RemainingSprays", this.getCapacity(stack));
    }
}

