/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.world.storage.loot.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mrcrayfish.vehicle.init.ModLootFunctions;
import com.mrcrayfish.vehicle.tileentity.IFluidTankWriter;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class CopyFluidTanks
extends LootFunction {
    private CopyFluidTanks(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        TileEntity tileEntity;
        BlockState state = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
        if (state != null && stack.func_77973_b() == state.func_177230_c().func_199767_j() && (tileEntity = (TileEntity)context.func_216031_c(LootParameters.field_216288_h)) != null) {
            IFluidTankWriter writer;
            CompoundNBT tileEntityTag = new CompoundNBT();
            if (tileEntity instanceof TileFluidHandler) {
                LazyOptional handler = tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                handler.ifPresent(h -> {
                    FluidTank tank = (FluidTank)h;
                    if (!tank.isEmpty()) {
                        tank.writeToNBT(tileEntityTag);
                    }
                });
            } else if (tileEntity instanceof IFluidTankWriter && !(writer = (IFluidTankWriter)tileEntity).areTanksEmpty()) {
                writer.writeTanks(tileEntityTag);
            }
            if (!tileEntityTag.isEmpty()) {
                CompoundNBT compound = stack.func_77978_p();
                if (compound == null) {
                    compound = new CompoundNBT();
                }
                compound.func_218657_a("BlockEntityTag", (INBT)tileEntityTag);
                stack.func_77982_d(compound);
            }
        }
        return stack;
    }

    public LootFunctionType func_230425_b_() {
        return ModLootFunctions.COPY_FLUID_TANKS;
    }

    public static class Serializer
    extends LootFunction.Serializer<CopyFluidTanks> {
        public CopyFluidTanks deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            return new CopyFluidTanks(conditionsIn);
        }
    }
}

