/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityStradpole;
import com.github.alexthe666.alexsmobs.entity.ai.StraddlerAIShoot;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.StriderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class EntityStraddler
extends MonsterEntity
implements IAnimatedEntity {
    public static final Animation ANIMATION_LAUNCH = Animation.create((int)30);
    private static final DataParameter<Integer> STRADPOLE_COUNT = EntityDataManager.func_187226_a(EntityStraddler.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int animationTick;
    private Animation currentAnimation;

    protected EntityStraddler(EntityType type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.LAVA, 0.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.STRADDLER_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.STRADDLER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.STRADDLER_HURT;
    }

    public static boolean canStraddlerSpawn(EntityType animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        boolean spawnBlock = BlockTags.field_242173_aI.func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
        return spawnBlock;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 28.0).func_233815_a_(Attributes.field_233820_c_, 0.8).func_233815_a_(Attributes.field_233826_i_, 5.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STRADPOLE_COUNT, (Object)0);
    }

    public int getStradpoleCount() {
        return (Integer)this.field_70180_af.func_187225_a(STRADPOLE_COUNT);
    }

    public void setStradpoleCount(int index) {
        this.field_70180_af.func_187227_b(STRADPOLE_COUNT, (Object)index);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.straddlerSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new StraddlerAIShoot(this, 0.5, 30, 16.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0, 60));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, StriderEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
    }

    protected void func_184231_a(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
        this.func_145775_I();
        if (this.func_180799_ab()) {
            this.field_70143_R = 0.0f;
        } else {
            super.func_184231_a(p_184231_1_, p_184231_3_, p_184231_4_, p_184231_5_);
        }
    }

    public void func_213352_e(Vector3d travelVector) {
        this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_) * (this.getAnimation() == ANIMATION_LAUNCH ? 0.5f : 1.0f) * (this.func_180799_ab() ? 0.2f : 1.0f));
        if (this.func_70613_aW() && (this.func_70090_H() || this.func_180799_ab())) {
            this.func_213309_a(this.func_70689_ay(), travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    private void func_234318_eL_() {
        if (this.func_180799_ab()) {
            ISelectionContext lvt_1_1_ = ISelectionContext.func_216374_a((Entity)this);
            if (lvt_1_1_.func_216378_a(FlowingFluidBlock.field_235510_c_, this.func_233580_cy_().func_177977_b(), true) && !this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177984_a()).func_206884_a((ITag)FluidTags.field_206960_b)) {
                this.field_70122_E = true;
            } else {
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.5).func_72441_c(0.0, (double)this.field_70146_Z.nextFloat() * 0.5, 0.0));
            }
        }
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    protected float func_203009_ad() {
        return this.field_82151_R + 0.6f;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        if (worldIn.func_180495_p(pos).func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b)) {
            return 10.0f;
        }
        return this.func_180799_ab() ? Float.NEGATIVE_INFINITY : 0.0f;
    }

    public Vector3d func_230268_c_(LivingEntity livingEntity) {
        Vector3d[] avector3d = new Vector3d[]{EntityStraddler.func_233559_a_((double)this.func_213311_cf(), (double)livingEntity.func_213311_cf(), (float)livingEntity.field_70177_z), EntityStraddler.func_233559_a_((double)this.func_213311_cf(), (double)livingEntity.func_213311_cf(), (float)(livingEntity.field_70177_z - 22.5f)), EntityStraddler.func_233559_a_((double)this.func_213311_cf(), (double)livingEntity.func_213311_cf(), (float)(livingEntity.field_70177_z + 22.5f)), EntityStraddler.func_233559_a_((double)this.func_213311_cf(), (double)livingEntity.func_213311_cf(), (float)(livingEntity.field_70177_z - 45.0f)), EntityStraddler.func_233559_a_((double)this.func_213311_cf(), (double)livingEntity.func_213311_cf(), (float)(livingEntity.field_70177_z + 45.0f))};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.func_174813_aQ().field_72337_e;
        double d1 = this.func_174813_aQ().field_72338_b - 0.5;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Vector3d vector3d : avector3d) {
            blockpos$mutable.func_189532_c(this.func_226277_ct_() + vector3d.field_72450_a, d0, this.func_226281_cx_() + vector3d.field_72449_c);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockpos$mutable.func_185334_h());
                blockpos$mutable.func_189536_c(Direction.DOWN);
            }
        }
        for (BlockPos blockpos : set) {
            double d3;
            if (this.field_70170_p.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206960_b) || !TransportationHelper.func_234630_a_((double)(d3 = this.field_70170_p.func_242403_h(blockpos)))) continue;
            Vector3d vector3d1 = Vector3d.func_237490_a_((Vector3i)blockpos, (double)d3);
            for (Pose pose : livingEntity.func_230297_ef_()) {
                AxisAlignedBB axisalignedbb = livingEntity.func_233648_f_(pose);
                if (!TransportationHelper.func_234631_a_((ICollisionReader)this.field_70170_p, (LivingEntity)livingEntity, (AxisAlignedBB)axisalignedbb.func_191194_a(vector3d1))) continue;
                livingEntity.func_213301_b(pose);
                return vector3d1;
            }
        }
        return new Vector3d(this.func_226277_ct_(), this.func_174813_aQ().field_72337_e, this.func_226281_cx_());
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_230285_a_(Fluid p_230285_1_) {
        return p_230285_1_.func_207185_a((ITag)FluidTags.field_206960_b);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("StradpoleCount", this.getStradpoleCount());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setStradpoleCount(compound.func_74762_e("StradpoleCount"));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_234318_eL_();
        this.func_145775_I();
        if (this.getAnimation() == ANIMATION_LAUNCH && this.func_70089_S() && this.getAnimationTick() == 2) {
            this.func_184185_a(SoundEvents.field_219611_bC, 2.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
        if (this.getAnimation() == ANIMATION_LAUNCH && this.func_70089_S() && this.getAnimationTick() == 20 && this.func_70638_az() != null) {
            EntityStradpole pole = (EntityStradpole)AMEntityRegistry.STRADPOLE.func_200721_a(this.field_70170_p);
            pole.setParentId(this.func_110124_au());
            pole.func_70107_b(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
            double d0 = this.func_70638_az().func_226280_cw_() - (double)1.1f;
            double d1 = this.func_70638_az().func_226277_ct_() - this.func_226277_ct_();
            double d2 = d0 - pole.func_226278_cu_();
            double d3 = this.func_70638_az().func_226281_cx_() - this.func_226281_cx_();
            float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.4f;
            float f3 = MathHelper.func_76133_a((double)(d1 * d1 + d2 * d2 + d3 * d3)) * 0.2f;
            this.func_184185_a(SoundEvents.field_219610_bB, 2.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            pole.shoot(d1, d2 + (double)f3, d3, 2.0f, 0.0f);
            pole.field_70177_z = this.field_70177_z % 360.0f;
            pole.field_70125_A = MathHelper.func_76131_a((float)this.field_70177_z, (float)-90.0f, (float)90.0f) % 360.0f;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c((Entity)pole);
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_LAUNCH};
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new LavaPathNavigator(this, worldIn);
    }

    public boolean shouldShoot() {
        return true;
    }

    static class LavaPathNavigator
    extends GroundPathNavigator {
        LavaPathNavigator(EntityStraddler p_i231565_1_, World p_i231565_2_) {
            super((MobEntity)p_i231565_1_, p_i231565_2_);
        }

        protected PathFinder func_179679_a(int p_179679_1_) {
            this.field_179695_a = new WalkNodeProcessor();
            return new PathFinder(this.field_179695_a, p_179679_1_);
        }

        protected boolean func_230287_a_(PathNodeType p_230287_1_) {
            return p_230287_1_ == PathNodeType.LAVA || p_230287_1_ == PathNodeType.DAMAGE_FIRE || p_230287_1_ == PathNodeType.DANGER_FIRE || super.func_230287_a_(p_230287_1_);
        }

        public boolean func_188555_b(BlockPos pos) {
            return this.field_75513_b.func_180495_p(pos).func_203425_a(Blocks.field_150353_l) || super.func_188555_b(pos);
        }
    }
}

