/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.event;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.block.AMBlockRegistry;
import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.effect.AMEffectRegistry;
import com.github.alexthe666.alexsmobs.effect.EffectClinging;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityElephant;
import com.github.alexthe666.alexsmobs.entity.EntityEmu;
import com.github.alexthe666.alexsmobs.entity.EntityEndergrade;
import com.github.alexthe666.alexsmobs.entity.EntityFly;
import com.github.alexthe666.alexsmobs.entity.EntityMimicOctopus;
import com.github.alexthe666.alexsmobs.entity.EntityMoose;
import com.github.alexthe666.alexsmobs.entity.EntitySeal;
import com.github.alexthe666.alexsmobs.entity.EntitySnowLeopard;
import com.github.alexthe666.alexsmobs.entity.EntityTiger;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWorm;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.item.ItemFalconryGlove;
import com.github.alexthe666.alexsmobs.message.MessageSwingArm;
import com.github.alexthe666.alexsmobs.misc.AMAdvancementTriggerRegistry;
import com.github.alexthe666.alexsmobs.misc.EmeraldsForItemsTrade;
import com.github.alexthe666.alexsmobs.misc.ItemsForEmeraldsTrade;
import com.github.alexthe666.alexsmobs.world.BeachedCachalotWhaleSpawner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import org.antlr.v4.runtime.misc.Triple;

@Mod.EventBusSubscriber(modid="alexsmobs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEvents {
    private static final UUID SAND_SPEED_MODIFIER = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF28E");
    private static final UUID SNEAK_SPEED_MODIFIER = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF28F");
    private static final AttributeModifier SAND_SPEED_BONUS = new AttributeModifier(SAND_SPEED_MODIFIER, "roadrunner speed bonus", (double)0.1f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier SNEAK_SPEED_BONUS = new AttributeModifier(SNEAK_SPEED_MODIFIER, "frontier cap speed bonus", (double)0.1f, AttributeModifier.Operation.ADDITION);
    private static final Map<ServerWorld, BeachedCachalotWhaleSpawner> BEACHED_CACHALOT_WHALE_SPAWNER_MAP = new HashMap<ServerWorld, BeachedCachalotWhaleSpawner>();
    public static List<Triple<ServerPlayerEntity, ServerWorld, BlockPos>> teleportPlayers = new ArrayList<Triple<ServerPlayerEntity, ServerWorld, BlockPos>>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.WorldTickEvent tick) {
        BeachedCachalotWhaleSpawner spawner;
        ServerWorld serverWorld;
        if (!tick.world.field_72995_K && tick.world instanceof ServerWorld) {
            serverWorld = (ServerWorld)tick.world;
            if (BEACHED_CACHALOT_WHALE_SPAWNER_MAP.get(serverWorld) == null) {
                BEACHED_CACHALOT_WHALE_SPAWNER_MAP.put(serverWorld, new BeachedCachalotWhaleSpawner(serverWorld));
            }
            spawner = BEACHED_CACHALOT_WHALE_SPAWNER_MAP.get(serverWorld);
            spawner.tick();
        }
        if (!tick.world.field_72995_K && tick.world instanceof ServerWorld) {
            serverWorld = (ServerWorld)tick.world;
            if (BEACHED_CACHALOT_WHALE_SPAWNER_MAP.get(serverWorld) == null) {
                BEACHED_CACHALOT_WHALE_SPAWNER_MAP.put(serverWorld, new BeachedCachalotWhaleSpawner(serverWorld));
            }
            spawner = BEACHED_CACHALOT_WHALE_SPAWNER_MAP.get(serverWorld);
            spawner.tick();
        }
        if (!tick.world.field_72995_K && tick.world instanceof ServerWorld) {
            for (Triple<ServerPlayerEntity, ServerWorld, BlockPos> trip : teleportPlayers) {
                ServerPlayerEntity player = (ServerPlayerEntity)trip.a;
                ServerWorld endpointWorld = (ServerWorld)trip.b;
                BlockPos endpoint = (BlockPos)trip.c;
                player.func_200619_a(endpointWorld, (double)endpoint.func_177958_n() + 0.5, (double)endpoint.func_177956_o() + 0.5, (double)endpoint.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
            }
            teleportPlayers.clear();
        }
    }

    protected static BlockRayTraceResult rayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vector3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d vector3d1 = vector3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }

    @SubscribeEvent
    public static void onItemUseLast(LivingEntityUseItemEvent.Finish event) {
        if (event.getItem().func_77973_b() == Items.field_185161_cS && new Random().nextInt(3) == 0 && event.getEntityLiving().func_70644_a(AMEffectRegistry.ENDER_FLU)) {
            event.getEntityLiving().func_195063_d(AMEffectRegistry.ENDER_FLU);
        }
    }

    @SubscribeEvent
    public static void onEntityResize(EntityEvent.Size event) {
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity entity = (PlayerEntity)event.getEntity();
            try {
                Map potions = entity.func_193076_bZ();
                if (event.getEntity().field_70170_p != null && potions != null && !potions.isEmpty() && potions.containsKey(AMEffectRegistry.CLINGING) && EffectClinging.isUpsideDown((LivingEntity)entity)) {
                    float minus = event.getOldSize().field_220316_b - event.getOldEyeHeight();
                    event.setNewEyeHeight(minus);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        CompoundNBT playerData;
        CompoundNBT data;
        if (AMConfig.giveBookOnStartup && (data = (playerData = event.getPlayer().getPersistentData()).func_74775_l("PlayerPersisted")) != null && !data.func_74767_n("alexsmobs_has_book")) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)event.getPlayer(), (ItemStack)new ItemStack((IItemProvider)AMItemRegistry.ANIMAL_DICTIONARY));
            data.func_74757_a("alexsmobs_has_book", true);
            playerData.func_218657_a("PlayerPersisted", (INBT)data);
        }
    }

    @SubscribeEvent
    public void onProjectileHit(ProjectileImpactEvent event) {
        if (event.getRayTraceResult() instanceof EntityRayTraceResult && ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a() instanceof EntityEmu && !event.getEntity().field_70170_p.field_72995_K) {
            EntityEmu emu = (EntityEmu)((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a();
            if (event.getEntity() instanceof AbstractArrowEntity) {
                ((AbstractArrowEntity)event.getEntity()).func_213872_b((byte)0);
            }
            if ((emu.getAnimation() == EntityEmu.ANIMATION_DODGE_RIGHT || emu.getAnimation() == EntityEmu.ANIMATION_DODGE_LEFT) && emu.getAnimationTick() < 7) {
                event.setCanceled(true);
            }
            if (emu.getAnimation() != EntityEmu.ANIMATION_DODGE_RIGHT && emu.getAnimation() != EntityEmu.ANIMATION_DODGE_LEFT) {
                boolean left = true;
                Vector3d arrowPos = event.getEntity().func_213303_ch();
                Vector3d rightVector = emu.func_70040_Z().func_178785_b(1.5707964f).func_178787_e(emu.func_213303_ch());
                Vector3d leftVector = emu.func_70040_Z().func_178785_b(-1.5707964f).func_178787_e(emu.func_213303_ch());
                left = arrowPos.func_72438_d(rightVector) < arrowPos.func_72438_d(leftVector) ? false : (arrowPos.func_72438_d(rightVector) > arrowPos.func_72438_d(leftVector) ? true : emu.func_70681_au().nextBoolean());
                Vector3d vector3d2 = event.getEntity().func_213322_ci().func_178785_b((float)((double)(left ? -0.5f : 0.5f) * Math.PI)).func_72432_b();
                emu.setAnimation(left ? EntityEmu.ANIMATION_DODGE_LEFT : EntityEmu.ANIMATION_DODGE_RIGHT);
                emu.field_70160_al = true;
                if (!emu.field_70123_F) {
                    emu.func_213315_a(MoverType.SELF, new Vector3d(vector3d2.func_82615_a() * 0.25, (double)0.1f, vector3d2.func_82616_c() * 0.25));
                }
                if (!event.getEntity().field_70170_p.field_72995_K) {
                    Entity thrower;
                    ServerPlayerEntity serverPlayerEntity = null;
                    if (event.getEntity() instanceof ArrowEntity && (thrower = ((ArrowEntity)event.getEntity()).func_234616_v_()) instanceof ServerPlayerEntity) {
                        serverPlayerEntity = (ServerPlayerEntity)thrower;
                    }
                    if (event.getEntity() instanceof ThrowableEntity && (thrower = ((ThrowableEntity)event.getEntity()).func_234616_v_()) instanceof ServerPlayerEntity) {
                        serverPlayerEntity = (ServerPlayerEntity)thrower;
                    }
                    if (serverPlayerEntity != null) {
                        AMAdvancementTriggerRegistry.EMU_DODGE.trigger(serverPlayerEntity);
                    }
                }
                emu.func_213317_d(emu.func_213322_ci().func_72441_c(vector3d2.func_82615_a() * 0.5, (double)0.32f, vector3d2.func_82616_c() * 0.5));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDespawnAttempt(LivingSpawnEvent.AllowDespawn event) {
        if (event.getEntityLiving().func_70644_a(AMEffectRegistry.DEBILITATING_STING) && event.getEntityLiving().func_70660_b(AMEffectRegistry.DEBILITATING_STING) != null && event.getEntityLiving().func_70660_b(AMEffectRegistry.DEBILITATING_STING).func_76458_c() > 0) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onTradeSetup(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.field_221157_g) {
            EmeraldsForItemsTrade ambergrisTrade = new EmeraldsForItemsTrade((IItemProvider)AMItemRegistry.AMBERGRIS, 20, 3, 4);
            List l = (List)event.getTrades().get(2);
            l.add(ambergrisTrade);
            event.getTrades().put(2, (Object)l);
        }
    }

    @SubscribeEvent
    public void onWanderingTradeSetup(WandererTradesEvent event) {
        if (AMConfig.wanderingTraderOffers) {
            List genericTrades = event.getGenericTrades();
            List rareTrades = event.getRareTrades();
            genericTrades.add(new ItemsForEmeraldsTrade(AMItemRegistry.ANIMAL_DICTIONARY, 4, 1, 2, 1));
            genericTrades.add(new ItemsForEmeraldsTrade(AMItemRegistry.ACACIA_BLOSSOM, 3, 2, 2, 1));
            if (AMConfig.cockroachSpawnWeight > 0) {
                genericTrades.add(new ItemsForEmeraldsTrade(AMItemRegistry.COCKROACH_OOTHECA, 2, 1, 2, 1));
            }
            if (AMConfig.blobfishSpawnWeight > 0) {
                genericTrades.add(new ItemsForEmeraldsTrade(AMItemRegistry.BLOBFISH_BUCKET, 4, 1, 3, 1));
            }
            if (AMConfig.crocodileSpawnWeight > 0) {
                genericTrades.add(new ItemsForEmeraldsTrade(AMBlockRegistry.CROCODILE_EGG.func_199767_j(), 6, 1, 2, 1));
            }
            genericTrades.add(new ItemsForEmeraldsTrade(AMItemRegistry.BEAR_FUR, 1, 1, 2, 1));
            genericTrades.add(new ItemsForEmeraldsTrade(AMItemRegistry.CROCODILE_SCUTE, 5, 1, 2, 1));
            genericTrades.add(new ItemsForEmeraldsTrade(AMItemRegistry.MOSQUITO_LARVA, 1, 3, 5, 1));
            rareTrades.add(new ItemsForEmeraldsTrade(AMItemRegistry.SOMBRERO, 20, 1, 1, 1));
            rareTrades.add(new ItemsForEmeraldsTrade(AMBlockRegistry.BANANA_PEEL, 1, 2, 1, 1));
            rareTrades.add(new ItemsForEmeraldsTrade(AMItemRegistry.BLOOD_SAC, 5, 2, 3, 1));
        }
    }

    @SubscribeEvent
    public void onLootLevelEvent(LootingLevelEvent event) {
        Entity dmgSrc;
        DamageSource src = event.getDamageSource();
        if (src != null && (dmgSrc = src.func_76346_g()) != null && dmgSrc instanceof EntitySnowLeopard) {
            event.setLootingLevel(event.getLootingLevel() + 2);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ItemFalconryGlove.onLeftClick(event.getPlayer(), event.getPlayer().func_184592_cb());
        ItemFalconryGlove.onLeftClick(event.getPlayer(), event.getPlayer().func_184614_ca());
        if (event.getWorld().field_72995_K) {
            AlexsMobs.sendMSGToServer(new MessageSwingArm());
        }
    }

    @SubscribeEvent
    public void onUseItem(PlayerInteractEvent.RightClickItem event) {
        BlockRayTraceResult raytraceresult;
        if (event.getItemStack().func_77973_b() == Items.field_151015_O && event.getPlayer().func_184187_bx() instanceof EntityElephant && ((EntityElephant)event.getPlayer().func_184187_bx()).triggerCharge(event.getItemStack())) {
            event.getPlayer().func_184609_a(event.getHand());
            if (!event.getPlayer().func_184812_l_()) {
                event.getItemStack().func_190918_g(1);
            }
        }
        if (event.getItemStack().func_77973_b() == Items.field_151069_bo && AMConfig.lavaBottleEnabled && (raytraceresult = ServerEvents.rayTrace(event.getWorld(), event.getPlayer(), RayTraceContext.FluidMode.SOURCE_ONLY)).func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_216350_a();
            if (event.getWorld().func_175660_a(event.getPlayer(), blockpos) && event.getWorld().func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206960_b)) {
                event.getWorld().func_184148_a(event.getPlayer(), event.getPlayer().func_226277_ct_(), event.getPlayer().func_226278_cu_(), event.getPlayer().func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                event.getPlayer().func_71029_a(Stats.field_75929_E.func_199076_b((Object)Items.field_151069_bo));
                event.getPlayer().func_70015_d(6);
                if (!event.getPlayer().func_191521_c(new ItemStack((IItemProvider)AMItemRegistry.LAVA_BOTTLE))) {
                    event.getPlayer().func_199701_a_(new ItemStack((IItemProvider)AMItemRegistry.LAVA_BOTTLE));
                }
                event.getPlayer().func_184609_a(event.getHand());
                if (!event.getPlayer().func_184812_l_()) {
                    event.getItemStack().func_190918_g(1);
                }
            }
        }
    }

    @SubscribeEvent
    public void onInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof LivingEntity && !(event.getTarget() instanceof PlayerEntity) && !(event.getTarget() instanceof EntityEndergrade) && ((LivingEntity)event.getTarget()).func_70644_a(AMEffectRegistry.ENDER_FLU) && event.getItemStack().func_77973_b() == Items.field_185161_cS) {
            if (!event.getPlayer().func_184812_l_()) {
                event.getItemStack().func_190918_g(1);
            }
            event.getTarget().func_184185_a(SoundEvents.field_187537_bA, 1.0f, 0.5f + event.getPlayer().func_70681_au().nextFloat());
            if (event.getPlayer().func_70681_au().nextFloat() < 0.4f) {
                ((LivingEntity)event.getTarget()).func_195063_d(AMEffectRegistry.ENDER_FLU);
                Items.field_185161_cS.func_77654_b(event.getItemStack().func_77946_l(), event.getWorld(), (LivingEntity)event.getTarget());
            }
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getEntity() instanceof WanderingTraderEntity && AMConfig.elephantTraderSpawnChance > 0.0) {
            Random rand = new Random();
            Biome biome = event.getWorld().func_226691_t_(event.getEntity().func_233580_cy_());
            if ((double)rand.nextFloat() <= AMConfig.elephantTraderSpawnChance && (!AMConfig.limitElephantTraderBiomes || biome.func_242445_k() >= 1.0f)) {
                WanderingTraderEntity traderEntity = (WanderingTraderEntity)event.getEntity();
                EntityElephant elephant = (EntityElephant)AMEntityRegistry.ELEPHANT.func_200721_a(traderEntity.field_70170_p);
                elephant.func_82149_j((Entity)traderEntity);
                if (elephant.canSpawnWithTraderHere()) {
                    elephant.setTrader(true);
                    elephant.setChested(true);
                    if (!event.getWorld().func_201670_d()) {
                        traderEntity.field_70170_p.func_217376_c((Entity)elephant);
                        traderEntity.func_184205_a((Entity)elephant, true);
                    }
                    elephant.addElephantLoot(null, rand.nextInt());
                }
            }
        }
        try {
            if (event.getEntity() != null && event.getEntity() instanceof SpiderEntity && AMConfig.spidersAttackFlies) {
                SpiderEntity spider = (SpiderEntity)event.getEntity();
                spider.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)spider, EntityFly.class, 1, true, false, null));
            }
            if (event.getEntity() != null && event.getEntity() instanceof WolfEntity && AMConfig.wolvesAttackMoose) {
                WolfEntity wolf = (WolfEntity)event.getEntity();
                wolf.field_70715_bh.func_75776_a(6, (Goal)new NonTamedTargetGoal((TameableEntity)wolf, EntityMoose.class, false, null));
            }
            if (event.getEntity() != null && event.getEntity() instanceof PolarBearEntity && AMConfig.polarBearsAttackSeals) {
                PolarBearEntity bear = (PolarBearEntity)event.getEntity();
                bear.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)bear, EntitySeal.class, 15, true, true, null));
            }
            if (event.getEntity() != null && event.getEntity() instanceof CreeperEntity) {
                CreeperEntity creeper = (CreeperEntity)event.getEntity();
                creeper.field_70715_bh.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)creeper, EntitySnowLeopard.class, 6.0f, 1.0, 1.2));
                creeper.field_70715_bh.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)creeper, EntityTiger.class, 6.0f, 1.0, 1.2));
            }
        }
        catch (Exception e) {
            AlexsMobs.LOGGER.warn("Tried to add unique behaviors to vanilla mobs and encountered an error");
        }
    }

    @SubscribeEvent
    public void onPlayerAttackEntityEvent(AttackEntityEvent event) {
        if (event.getPlayer().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == AMItemRegistry.MOOSE_HEADGEAR && event.getTarget() instanceof LivingEntity) {
            float f1 = 2.0f;
            ((LivingEntity)event.getTarget()).func_233627_a_(f1 * 0.5f, (double)MathHelper.func_76126_a((float)(event.getPlayer().field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(event.getPlayer().field_70177_z * ((float)Math.PI / 180)))));
        }
        if (event.getPlayer().func_70644_a(AMEffectRegistry.TIGERS_BLESSING) && event.getTarget() instanceof LivingEntity && !event.getTarget().func_184191_r((Entity)event.getPlayer()) && !(event.getTarget() instanceof EntityTiger)) {
            AxisAlignedBB bb = new AxisAlignedBB(event.getPlayer().func_226277_ct_() - 32.0, event.getPlayer().func_226278_cu_() - 32.0, event.getPlayer().func_226281_cx_() - 32.0, event.getPlayer().func_226281_cx_() + 32.0, event.getPlayer().func_226278_cu_() + 32.0, event.getPlayer().func_226281_cx_() + 32.0);
            List tigers = event.getPlayer().field_70170_p.func_175647_a(EntityTiger.class, bb, EntityPredicates.field_94557_a);
            for (EntityTiger tiger : tigers) {
                if (tiger.func_70631_g_()) continue;
                tiger.func_70624_b((LivingEntity)event.getTarget());
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamageEvent(LivingDamageEvent event) {
        LivingEntity attacker;
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            attacker = (LivingEntity)event.getSource().func_76346_g();
            if (event.getAmount() > 0.0f && attacker.func_70644_a(AMEffectRegistry.SOULSTEAL) && attacker.func_70660_b(AMEffectRegistry.SOULSTEAL) != null) {
                int level = attacker.func_70660_b(AMEffectRegistry.SOULSTEAL).func_76458_c() + 1;
                Random rand = new Random();
                if (attacker.func_110143_aJ() < attacker.func_110138_aP() && rand.nextFloat() < 0.25f + (float)level * 0.25f) {
                    attacker.func_70691_i(Math.min(event.getAmount() / 2.0f * (float)level, (float)(2 + 2 * level)));
                }
            }
        }
        if (event.getEntityLiving() instanceof PlayerEntity && event.getSource().func_76346_g() instanceof LivingEntity) {
            attacker = (LivingEntity)event.getSource().func_76346_g();
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (attacker instanceof EntityMimicOctopus && ((EntityMimicOctopus)attacker).func_152114_e((LivingEntity)player)) {
                event.setCanceled(true);
                return;
            }
            if (player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == AMItemRegistry.SPIKED_TURTLE_SHELL) {
                float f1 = 1.0f;
                if (attacker.func_70032_d((Entity)player) < attacker.func_213311_cf() + player.func_213311_cf() + 0.5f) {
                    attacker.func_70097_a(DamageSource.func_92087_a((Entity)player), 1.0f);
                    attacker.func_233627_a_(f1 * 0.5f, (double)MathHelper.func_76126_a((float)((attacker.field_70177_z + 180.0f) * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)((attacker.field_70177_z + 180.0f) * ((float)Math.PI / 180)))));
                }
            }
        }
        if (!event.getEntityLiving().func_184582_a(EquipmentSlotType.LEGS).func_190926_b() && event.getEntityLiving().func_184582_a(EquipmentSlotType.LEGS).func_77973_b() == AMItemRegistry.EMU_LEGGINGS && event.getSource().func_76352_a() && (double)event.getEntityLiving().func_70681_au().nextFloat() < AMConfig.emuPantsDodgeChance) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onStructureGetSpawnLists(StructureSpawnListGatherEvent event) {
        if (AMConfig.mimicubeSpawnInEndCity && AMConfig.mimicubeSpawnWeight > 0 && event.getStructure() == Structure.field_236379_o_) {
            event.addEntitySpawn(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(AMEntityRegistry.MIMICUBE, AMConfig.mimicubeSpawnWeight, 1, 3));
        }
        if (AMConfig.soulVultureSpawnOnFossil && AMConfig.soulVultureSpawnWeight > 0 && event.getStructure() == Structure.field_236382_r_) {
            event.addEntitySpawn(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(AMEntityRegistry.SOUL_VULTURE, AMConfig.soulVultureSpawnWeight, 2, 3));
        }
    }

    @SubscribeEvent
    public void onLivingSetTargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getTarget() != null && event.getEntityLiving() instanceof MobEntity && event.getEntityLiving().func_70668_bt() == CreatureAttribute.field_223224_c_ && event.getTarget().func_70644_a(AMEffectRegistry.BUG_PHEROMONES) && event.getEntityLiving().func_70643_av() != event.getTarget()) {
            ((MobEntity)event.getEntityLiving()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            if ((double)event.getEntityLiving().func_70047_e() < (double)event.getEntityLiving().func_213302_cg() * 0.5) {
                event.getEntityLiving().func_213323_x_();
            }
            ModifiableAttributeInstance modifiableattributeinstance = event.getEntityLiving().func_110148_a(Attributes.field_233821_d_);
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET).func_77973_b() == AMItemRegistry.ROADDRUNNER_BOOTS || modifiableattributeinstance.func_180374_a(SAND_SPEED_BONUS)) {
                boolean sand = event.getEntityLiving().field_70170_p.func_180495_p(this.getDownPos(event.getEntityLiving().func_233580_cy_(), (IWorld)event.getEntityLiving().field_70170_p)).func_177230_c().func_203417_a((ITag)BlockTags.field_203436_u);
                if (sand && !modifiableattributeinstance.func_180374_a(SAND_SPEED_BONUS)) {
                    modifiableattributeinstance.func_233769_c_(SAND_SPEED_BONUS);
                }
                if (event.getEntityLiving().field_70173_aa % 25 == 0 && (event.getEntityLiving().func_184582_a(EquipmentSlotType.FEET).func_77973_b() != AMItemRegistry.ROADDRUNNER_BOOTS || !sand) && modifiableattributeinstance.func_180374_a(SAND_SPEED_BONUS)) {
                    modifiableattributeinstance.func_111124_b(SAND_SPEED_BONUS);
                }
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == AMItemRegistry.FRONTIER_CAP || modifiableattributeinstance.func_180374_a(SNEAK_SPEED_BONUS)) {
                if (event.getEntityLiving().func_225608_bj_() && !modifiableattributeinstance.func_180374_a(SNEAK_SPEED_BONUS)) {
                    modifiableattributeinstance.func_233769_c_(SNEAK_SPEED_BONUS);
                }
                if ((!event.getEntityLiving().func_225608_bj_() || event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() != AMItemRegistry.FRONTIER_CAP) && modifiableattributeinstance.func_180374_a(SNEAK_SPEED_BONUS)) {
                    modifiableattributeinstance.func_111124_b(SNEAK_SPEED_BONUS);
                }
            }
            if (event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == AMItemRegistry.SPIKED_TURTLE_SHELL && !event.getEntityLiving().func_208600_a((ITag)FluidTags.field_206959_a)) {
                event.getEntityLiving().func_195064_c(new EffectInstance(Effects.field_76427_o, 210, 0, false, false, true));
            }
        }
        if (event.getEntityLiving().func_184582_a(EquipmentSlotType.LEGS).func_77973_b() == AMItemRegistry.CENTIPEDE_LEGGINGS && event.getEntityLiving().field_70123_F && !event.getEntityLiving().func_70090_H()) {
            event.getEntityLiving().field_70143_R = 0.0f;
            Vector3d motion = event.getEntityLiving().func_213322_ci();
            double d0 = MathHelper.func_151237_a((double)motion.field_72450_a, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.func_151237_a((double)motion.field_72449_c, (double)-0.15f, (double)0.15f);
            double d2 = 0.1;
            if (d2 < 0.0 && !event.getEntityLiving().func_213339_cH().isScaffolding(event.getEntityLiving()) && event.getEntityLiving().func_230491_ea_()) {
                d2 = 0.0;
            }
            motion = new Vector3d(d0, d2, d1);
            event.getEntityLiving().func_213317_d(motion);
        }
    }

    private BlockPos getDownPos(BlockPos entered, IWorld world) {
        for (int i = 0; world.func_175623_d(entered) && i < 3; ++i) {
            entered = entered.func_177977_b();
        }
        return entered;
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        if (event.getEntity().func_70644_a(AMEffectRegistry.FEAR)) {
            event.setNewfov(1.0f);
        }
    }

    @SubscribeEvent
    public void onEntityLeaveWorld(EntityLeaveWorldEvent event) {
        String dim;
        if (event.getEntity() instanceof ItemEntity && ((ItemEntity)event.getEntity()).func_92059_d().func_77973_b() == AMItemRegistry.MYSTERIOUS_WORM && AMConfig.voidWormSummonable && AMConfig.voidWormSpawnDimensions.contains(dim = event.getEntity().field_70170_p.func_234923_W_().func_240901_a_().toString()) && event.getEntity().func_226278_cu_() < -10.0) {
            EntityVoidWorm worm = (EntityVoidWorm)AMEntityRegistry.VOID_WORM.func_200721_a(event.getWorld());
            worm.func_70107_b(event.getEntity().func_226277_ct_(), 0.0, event.getEntity().func_226281_cx_());
            worm.setSegmentCount(25 + new Random().nextInt(15));
            worm.field_70125_A = -90.0f;
            worm.updatePostSummon = true;
            if (!event.getWorld().field_72995_K) {
                if (((ItemEntity)event.getEntity()).func_200214_m() != null) {
                    UUID uuid = ((ItemEntity)event.getEntity()).func_200214_m();
                    if (event.getWorld().func_217371_b(uuid) instanceof ServerPlayerEntity) {
                        AMAdvancementTriggerRegistry.VOID_WORM_SUMMON.trigger((ServerPlayerEntity)event.getWorld().func_217371_b(uuid));
                    }
                }
                event.getWorld().func_217376_c((Entity)worm);
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        Entity attacker;
        if (!event.getEntityLiving().func_184607_cu().func_190926_b() && event.getSource() != null && event.getSource().func_76346_g() != null && event.getEntityLiving().func_184607_cu().func_77973_b() == AMItemRegistry.SHIELD_OF_THE_DEEP && (attacker = event.getSource().func_76346_g()) instanceof LivingEntity) {
            boolean flag = false;
            if (attacker.func_70032_d((Entity)event.getEntityLiving()) <= 4.0f && !((LivingEntity)attacker).func_70644_a(AMEffectRegistry.EXSANGUINATION)) {
                ((LivingEntity)attacker).func_195064_c(new EffectInstance(AMEffectRegistry.EXSANGUINATION, 60, 2));
                flag = true;
            }
            if (event.getEntityLiving().func_203005_aq()) {
                event.getEntityLiving().func_70050_g(Math.min(event.getEntityLiving().func_205010_bg(), event.getEntityLiving().func_70086_ai() + 150));
                flag = true;
            }
            if (flag) {
                event.getEntityLiving().func_184607_cu().func_222118_a(1, event.getEntityLiving(), playerIn -> playerIn.func_213334_d(event.getEntityLiving().func_184600_cs()));
            }
        }
    }

    @SubscribeEvent
    public void onChestGenerated(LootTableLoadEvent event) {
        LootPool.Builder builder;
        StandaloneLootEntry.Builder item;
        if (event.getName().equals((Object)LootTables.field_186430_l)) {
            item = ItemLootEntry.func_216168_a((IItemProvider)AMItemRegistry.ANCIENT_DART).func_216085_b(40).func_216086_a(1);
            builder = new LootPool.Builder().name("am_dart").func_216045_a((LootEntry.Builder)item).func_212840_b_(RandomChance.func_216004_a((float)1.0f)).func_216046_a((IRandomRange)new RandomValueRange(0.0f, 1.0f)).bonusRolls(0.0f, 1.0f);
            event.getTable().addPool(builder.func_216044_b());
        }
        if (event.getName().equals((Object)LootTables.field_189420_m)) {
            item = ItemLootEntry.func_216168_a((IItemProvider)AMItemRegistry.ANCIENT_DART).func_216085_b(20).func_216086_a(3);
            builder = new LootPool.Builder().name("am_dart_dispenser").func_216045_a((LootEntry.Builder)item).func_212840_b_(RandomChance.func_216004_a((float)1.0f)).func_216046_a((IRandomRange)new RandomValueRange(0.0f, 2.0f)).bonusRolls(0.0f, 1.0f);
            event.getTable().addPool(builder.func_216044_b());
        }
    }
}

