/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.obfuscate.common.data;

import com.mrcrayfish.obfuscate.common.data.IDataSerializer;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class Serializers {
    public static final IDataSerializer<Boolean> BOOLEAN = new IDataSerializer<Boolean>(){

        @Override
        public void write(PacketBuffer buf, Boolean value) {
            buf.writeBoolean(value.booleanValue());
        }

        @Override
        public Boolean read(PacketBuffer buf) {
            return buf.readBoolean();
        }

        @Override
        public INBT write(Boolean value) {
            return ByteNBT.func_229672_a_((boolean)value);
        }

        @Override
        public Boolean read(INBT nbt) {
            return ((ByteNBT)nbt).func_150290_f() != 0;
        }
    };
    public static final IDataSerializer<Byte> BYTE = new IDataSerializer<Byte>(){

        @Override
        public void write(PacketBuffer buf, Byte value) {
            buf.writeByte((int)value.byteValue());
        }

        @Override
        public Byte read(PacketBuffer buf) {
            return buf.readByte();
        }

        @Override
        public INBT write(Byte value) {
            return ByteNBT.func_229671_a_((byte)value);
        }

        @Override
        public Byte read(INBT nbt) {
            return ((ByteNBT)nbt).func_150290_f();
        }
    };
    public static final IDataSerializer<Short> SHORT = new IDataSerializer<Short>(){

        @Override
        public void write(PacketBuffer buf, Short value) {
            buf.writeShort((int)value.shortValue());
        }

        @Override
        public Short read(PacketBuffer buf) {
            return buf.readShort();
        }

        @Override
        public INBT write(Short value) {
            return ShortNBT.func_229701_a_((short)value);
        }

        @Override
        public Short read(INBT nbt) {
            return ((ShortNBT)nbt).func_150289_e();
        }
    };
    public static final IDataSerializer<Integer> INTEGER = new IDataSerializer<Integer>(){

        @Override
        public void write(PacketBuffer buf, Integer value) {
            buf.func_150787_b(value.intValue());
        }

        @Override
        public Integer read(PacketBuffer buf) {
            return buf.func_150792_a();
        }

        @Override
        public INBT write(Integer value) {
            return IntNBT.func_229692_a_((int)value);
        }

        @Override
        public Integer read(INBT nbt) {
            return ((IntNBT)nbt).func_150287_d();
        }
    };
    public static final IDataSerializer<Long> LONG = new IDataSerializer<Long>(){

        @Override
        public void write(PacketBuffer buf, Long value) {
            buf.writeLong(value.longValue());
        }

        @Override
        public Long read(PacketBuffer buf) {
            return buf.readLong();
        }

        @Override
        public INBT write(Long value) {
            return LongNBT.func_229698_a_((long)value);
        }

        @Override
        public Long read(INBT nbt) {
            return ((LongNBT)nbt).func_150291_c();
        }
    };
    public static final IDataSerializer<Float> FLOAT = new IDataSerializer<Float>(){

        @Override
        public void write(PacketBuffer buf, Float value) {
            buf.writeFloat(value.floatValue());
        }

        @Override
        public Float read(PacketBuffer buf) {
            return Float.valueOf(buf.readFloat());
        }

        @Override
        public INBT write(Float value) {
            return FloatNBT.func_229689_a_((float)value.floatValue());
        }

        @Override
        public Float read(INBT nbt) {
            return Float.valueOf(((FloatNBT)nbt).func_150288_h());
        }
    };
    public static final IDataSerializer<Double> DOUBLE = new IDataSerializer<Double>(){

        @Override
        public void write(PacketBuffer buf, Double value) {
            buf.writeDouble(value.doubleValue());
        }

        @Override
        public Double read(PacketBuffer buf) {
            return buf.readDouble();
        }

        @Override
        public INBT write(Double value) {
            return DoubleNBT.func_229684_a_((double)value);
        }

        @Override
        public Double read(INBT nbt) {
            return ((DoubleNBT)nbt).func_150286_g();
        }
    };
    public static final IDataSerializer<Character> CHARACTER = new IDataSerializer<Character>(){

        @Override
        public void write(PacketBuffer buf, Character value) {
            buf.writeChar((int)value.charValue());
        }

        @Override
        public Character read(PacketBuffer buf) {
            return Character.valueOf(buf.readChar());
        }

        @Override
        public INBT write(Character value) {
            return IntNBT.func_229692_a_((int)value.charValue());
        }

        @Override
        public Character read(INBT nbt) {
            return Character.valueOf((char)((IntNBT)nbt).func_150287_d());
        }
    };
    public static final IDataSerializer<String> STRING = new IDataSerializer<String>(){

        @Override
        public void write(PacketBuffer buf, String value) {
            buf.func_180714_a(value);
        }

        @Override
        public String read(PacketBuffer buf) {
            return buf.func_218666_n();
        }

        @Override
        public INBT write(String value) {
            return StringNBT.func_229705_a_((String)value);
        }

        @Override
        public String read(INBT nbt) {
            return nbt.func_150285_a_();
        }
    };
    public static final IDataSerializer<CompoundNBT> TAG_COMPOUND = new IDataSerializer<CompoundNBT>(){

        @Override
        public void write(PacketBuffer buf, CompoundNBT value) {
            buf.func_150786_a(value);
        }

        @Override
        public CompoundNBT read(PacketBuffer buf) {
            return buf.func_150793_b();
        }

        @Override
        public INBT write(CompoundNBT value) {
            return value;
        }

        @Override
        public CompoundNBT read(INBT nbt) {
            return (CompoundNBT)nbt;
        }
    };
    public static final IDataSerializer<BlockPos> BLOCK_POS = new IDataSerializer<BlockPos>(){

        @Override
        public void write(PacketBuffer buf, BlockPos value) {
            buf.func_179255_a(value);
        }

        @Override
        public BlockPos read(PacketBuffer buf) {
            return buf.func_179259_c();
        }

        @Override
        public INBT write(BlockPos value) {
            return LongNBT.func_229698_a_((long)value.func_218275_a());
        }

        @Override
        public BlockPos read(INBT nbt) {
            return BlockPos.func_218283_e((long)((LongNBT)nbt).func_150291_c());
        }
    };
    public static final IDataSerializer<UUID> UUID = new IDataSerializer<UUID>(){

        @Override
        public void write(PacketBuffer buf, UUID value) {
            buf.func_179252_a(value);
        }

        @Override
        public UUID read(PacketBuffer buf) {
            return buf.func_179253_g();
        }

        @Override
        public INBT write(UUID value) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74772_a("Most", value.getMostSignificantBits());
            compound.func_74772_a("Least", value.getLeastSignificantBits());
            return compound;
        }

        @Override
        public UUID read(INBT nbt) {
            CompoundNBT compound = new CompoundNBT();
            return new UUID(compound.func_74763_f("Most"), compound.func_74763_f("Least"));
        }
    };
    public static final IDataSerializer<ItemStack> ITEM_STACK = new IDataSerializer<ItemStack>(){

        @Override
        public void write(PacketBuffer buf, ItemStack value) {
            buf.func_150788_a(value);
        }

        @Override
        public ItemStack read(PacketBuffer buf) {
            return buf.func_150791_c();
        }

        @Override
        public INBT write(ItemStack value) {
            return value.func_77955_b(new CompoundNBT());
        }

        @Override
        public ItemStack read(INBT nbt) {
            return ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt));
        }
    };
    public static final IDataSerializer<ResourceLocation> RESOURCE_LOCATION = new IDataSerializer<ResourceLocation>(){

        @Override
        public void write(PacketBuffer buf, ResourceLocation value) {
            buf.func_192572_a(value);
        }

        @Override
        public ResourceLocation read(PacketBuffer buf) {
            return buf.func_192575_l();
        }

        @Override
        public INBT write(ResourceLocation value) {
            return StringNBT.func_229705_a_((String)value.toString());
        }

        @Override
        public ResourceLocation read(INBT nbt) {
            return ResourceLocation.func_208304_a((String)nbt.func_150285_a_());
        }
    };
}

