/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.api.recipes.inputs.chemical.InfusionStackIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class MetallurgicInfuserRecipe
extends MekanismRecipe
implements BiPredicate<InfusionStack, ItemStack> {
    private final ItemStackIngredient itemInput;
    private final InfusionStackIngredient infusionInput;
    private final ItemStack output;

    public MetallurgicInfuserRecipe(ResourceLocation id, ItemStackIngredient itemInput, InfusionStackIngredient infusionInput, ItemStack output) {
        super(id);
        this.itemInput = itemInput;
        this.infusionInput = infusionInput;
        this.output = output.func_77946_l();
    }

    @Override
    public boolean test(InfusionStack infusionContainer, ItemStack itemStack) {
        return this.infusionInput.test(infusionContainer) && this.itemInput.test(itemStack);
    }

    public List<@NonNull ItemStack> getOutputDefinition() {
        return this.output.func_190926_b() ? Collections.emptyList() : Collections.singletonList(this.output);
    }

    @Contract(value="_, _ -> new", pure=true)
    public ItemStack getOutput(InfusionStack inputInfuse, ItemStack inputItem) {
        return this.output.func_77946_l();
    }

    @Override
    @Nonnull
    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public InfusionStackIngredient getInfusionInput() {
        return this.infusionInput;
    }

    public ItemStackIngredient getItemInput() {
        return this.itemInput;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.itemInput.write(buffer);
        this.infusionInput.write(buffer);
        buffer.func_150788_a(this.output);
    }
}

