/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiMergedChemicalBar;
import mekanism.client.gui.element.button.GuiGasMode;
import mekanism.client.gui.element.tab.GuiRedstoneControlTab;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.text.TextUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiChemicalTank
extends GuiConfigurableTile<TileEntityChemicalTank, MekanismTileContainer<TileEntityChemicalTank>> {
    public GuiChemicalTank(MekanismTileContainer<TileEntityChemicalTank> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new GuiMergedChemicalBar<TileEntityMekanism>(this, this.tile, ((TileEntityChemicalTank)this.tile).getChemicalTank(), 42, 16, 116, 10, true));
        this.func_230480_a_(new GuiInnerScreen((IGuiWrapper)this, 42, 37, 118, 28, () -> {
            ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
            MergedChemicalTank.Current current = ((TileEntityChemicalTank)this.tile).getChemicalTank().getCurrent();
            if (current == MergedChemicalTank.Current.EMPTY) {
                ret.add((ITextComponent)MekanismLang.CHEMICAL.translate(MekanismLang.NONE));
                ret.add((ITextComponent)MekanismLang.GENERIC_FRACTION.translate(0, ((TileEntityChemicalTank)this.tile).getTier() == ChemicalTankTier.CREATIVE ? MekanismLang.INFINITE : TextUtils.format(((TileEntityChemicalTank)this.tile).getTier().getStorage())));
            } else if (current == MergedChemicalTank.Current.GAS) {
                this.addStored(ret, ((TileEntityChemicalTank)this.tile).getChemicalTank().getGasTank(), MekanismLang.GAS);
            } else if (current == MergedChemicalTank.Current.INFUSION) {
                this.addStored(ret, ((TileEntityChemicalTank)this.tile).getChemicalTank().getInfusionTank(), MekanismLang.INFUSE_TYPE);
            } else if (current == MergedChemicalTank.Current.PIGMENT) {
                this.addStored(ret, ((TileEntityChemicalTank)this.tile).getChemicalTank().getPigmentTank(), MekanismLang.PIGMENT);
            } else if (current == MergedChemicalTank.Current.SLURRY) {
                this.addStored(ret, ((TileEntityChemicalTank)this.tile).getChemicalTank().getSlurryTank(), MekanismLang.SLURRY);
            } else {
                throw new IllegalStateException("Unknown current type");
            }
            return ret;
        }));
        this.func_230480_a_(new GuiRedstoneControlTab(this, this.tile));
        this.func_230480_a_(new GuiSecurityTab((IGuiWrapper)this, this.tile));
        this.func_230480_a_(new GuiGasMode((IGuiWrapper)this, this.field_147003_i + 159, this.field_147009_r + 72, true, () -> ((TileEntityChemicalTank)this.tile).dumping, ((TileEntityChemicalTank)this.tile).func_174877_v(), 0));
    }

    private void addStored(List<ITextComponent> ret, IChemicalTank<?, ?> tank, ILangEntry langKey) {
        ret.add((ITextComponent)langKey.translate(tank.getStack()));
        if (!tank.isEmpty() && ((TileEntityChemicalTank)this.tile).getTier() == ChemicalTankTier.CREATIVE) {
            ret.add((ITextComponent)MekanismLang.INFINITE.translate(new Object[0]));
        } else {
            ret.add((ITextComponent)MekanismLang.GENERIC_FRACTION.translate(TextUtils.format(tank.getStored()), ((TileEntityChemicalTank)this.tile).getTier() == ChemicalTankTier.CREATIVE ? MekanismLang.INFINITE : TextUtils.format(tank.getCapacity())));
        }
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

