/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiScalableElement;
import mekanism.client.jei.interfaces.IJEIRecipeArea;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiInnerScreen
extends GuiScalableElement
implements IJEIRecipeArea<GuiInnerScreen> {
    public static final ResourceLocation SCREEN = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "inner_screen.png");
    private Supplier<List<ITextComponent>> renderStrings;
    private Supplier<List<ITextComponent>> tooltipStrings;
    private ResourceLocation[] recipeCategories;
    private boolean centerY;
    private int spacing = 1;
    private int padding = 3;
    private float textScale = 1.0f;

    public GuiInnerScreen(IGuiWrapper gui, int x, int y, int width, int height) {
        super(SCREEN, gui, x, y, width, height, 32, 32);
    }

    public GuiInnerScreen(IGuiWrapper gui, int x, int y, int width, int height, Supplier<List<ITextComponent>> renderStrings) {
        this(gui, x, y, width, height);
        this.renderStrings = renderStrings;
        this.defaultFormat();
    }

    public GuiInnerScreen tooltip(Supplier<List<ITextComponent>> tooltipStrings) {
        this.tooltipStrings = tooltipStrings;
        this.field_230693_o_ = true;
        return this;
    }

    public GuiInnerScreen spacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    public GuiInnerScreen padding(int padding) {
        this.padding = padding;
        return this;
    }

    public GuiInnerScreen textScale(float textScale) {
        this.textScale = textScale;
        return this;
    }

    public GuiInnerScreen centerY() {
        this.centerY = true;
        return this;
    }

    public GuiInnerScreen clearFormat() {
        this.centerY = false;
        return this;
    }

    public GuiInnerScreen defaultFormat() {
        return this.padding(5).spacing(3).textScale(0.8f).centerY();
    }

    @Override
    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        if (this.renderStrings != null) {
            List<ITextComponent> list = this.renderStrings.get();
            float startY = this.relativeY + this.padding;
            if (this.centerY) {
                int totalHeight = list.size() * 8 + this.spacing * (list.size() - 1);
                startY = (float)this.relativeY + (float)this.func_238483_d_() / 2.0f - (float)totalHeight / 2.0f;
            }
            for (ITextComponent text : this.renderStrings.get()) {
                this.drawText(matrix, text, this.relativeX + this.padding, startY);
                startY += (float)(8 + this.spacing);
            }
        }
    }

    @Override
    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        List<ITextComponent> list;
        super.func_230443_a_(matrix, mouseX, mouseY);
        if (this.tooltipStrings != null && (list = this.tooltipStrings.get()) != null && !list.isEmpty()) {
            this.displayTooltips(matrix, list, mouseX, mouseY);
        }
    }

    private void drawText(MatrixStack matrix, ITextComponent text, float x, float y) {
        this.drawScaledTextScaledBound(matrix, text, x, y, this.screenTextColor(), this.func_230998_h_() - this.padding * 2, this.textScale);
    }

    @Override
    @Nonnull
    public GuiInnerScreen jeiCategories(ResourceLocation ... recipeCategories) {
        this.recipeCategories = recipeCategories;
        return this;
    }

    @Override
    @Nullable
    public ResourceLocation[] getRecipeCategories() {
        return this.recipeCategories;
    }

    @Override
    public boolean isMouseOverJEIArea(double mouseX, double mouseY) {
        return this.field_230694_p_ && mouseX >= (double)this.field_230690_l_ && mouseY >= (double)this.field_230691_m_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_);
    }
}

