/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.armor;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.model.BaseModelCache;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.armor.CustomArmor;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import mekanism.client.render.lib.effect.BoltRenderer;
import mekanism.client.render.obj.TransmitterBakedModel;
import mekanism.common.Mekanism;
import mekanism.common.content.gear.Modules;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.gear.ItemMekaTool;
import mekanism.common.lib.effect.BoltEffect;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import org.apache.commons.lang3.tuple.Pair;

public class MekaSuitArmor
extends CustomArmor {
    private static final String LED_TAG = "led";
    private static final String OVERRIDDEN_TAG = "override_";
    private static final String EXCLUSIVE_TAG = "excl_";
    private static final String SHARED_TAG = "shared_";
    private static final String GLASS_TAG = "glass";
    public static final MekaSuitArmor HELMET = new MekaSuitArmor(0.5f, EquipmentSlotType.HEAD, EquipmentSlotType.CHEST);
    public static final MekaSuitArmor BODYARMOR = new MekaSuitArmor(0.5f, EquipmentSlotType.CHEST, EquipmentSlotType.HEAD);
    public static final MekaSuitArmor PANTS = new MekaSuitArmor(0.5f, EquipmentSlotType.LEGS, EquipmentSlotType.FEET);
    public static final MekaSuitArmor BOOTS = new MekaSuitArmor(0.5f, EquipmentSlotType.FEET, EquipmentSlotType.LEGS);
    private static final Set<BaseModelCache.ModelData> specialModels = Sets.newHashSet((Object[])new BaseModelCache.ModelData[]{MekanismModelCache.INSTANCE.MEKASUIT_MODULES});
    private static final Table<EquipmentSlotType, Modules.ModuleData<?>, ModuleModelSpec> moduleModelSpec = HashBasedTable.create();
    private static final Map<UUID, BoltRenderer> boltRenderMap = new Object2ObjectOpenHashMap();
    private static final QuadTransformation BASE_TRANSFORM;
    private final LoadingCache<TransmitterBakedModel.QuickHash, ArmorQuads> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TransmitterBakedModel.QuickHash, ArmorQuads>(){

        public ArmorQuads load(@Nonnull TransmitterBakedModel.QuickHash key) {
            return MekaSuitArmor.this.createQuads((Set)key.get()[0], (Set)key.get()[1], (Boolean)key.get()[2]);
        }
    });
    private final EquipmentSlotType type;
    private final EquipmentSlotType adjacentType;

    private MekaSuitArmor(float size, EquipmentSlotType type, EquipmentSlotType adjacentType) {
        super(size);
        this.type = type;
        this.adjacentType = adjacentType;
        MekanismModelCache.INSTANCE.reloadCallback(() -> this.cache.invalidateAll());
    }

    @Override
    public void render(@Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight, float partialTicks, boolean hasEffect, LivingEntity entity, ItemStack stack) {
        if (this.field_217114_e) {
            matrix.func_227860_a_();
            float f1 = 1.0f / this.field_228225_h_;
            matrix.func_227862_a_(f1, f1, f1);
            matrix.func_227861_a_(0.0, (double)(this.field_228226_i_ / 16.0f), 0.0);
            this.renderMekaSuit(matrix, renderer, light, overlayLight, partialTicks, hasEffect, entity);
            matrix.func_227865_b_();
        } else {
            this.renderMekaSuit(matrix, renderer, light, overlayLight, partialTicks, hasEffect, entity);
        }
    }

    private void renderMekaSuit(@Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight, float partialTicks, boolean hasEffect, LivingEntity entity) {
        ArmorQuads armorQuads = (ArmorQuads)this.cache.getUnchecked((Object)this.key(entity));
        armorQuads.getOpaqueMap().forEach((modelPos, quads) -> {
            matrix.func_227860_a_();
            modelPos.translate(this, matrix);
            this.render(renderer, matrix, light, overlayLight, hasEffect, (List<BakedQuad>)quads, false);
            matrix.func_227865_b_();
        });
        if (this.type == EquipmentSlotType.CHEST) {
            BoltRenderer boltRenderer = boltRenderMap.computeIfAbsent(entity.func_110124_au(), id -> new BoltRenderer());
            if (Modules.isEnabled(entity.func_184582_a(EquipmentSlotType.CHEST), Modules.GRAVITATIONAL_MODULATING_UNIT)) {
                BoltEffect leftBolt = new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, new Vector3d(-0.01, 0.35, 0.37), new Vector3d(-0.01, 0.15, 0.37), 10).size(0.012f).lifespan(6).spawn(BoltEffect.SpawnFunction.noise(3.0f, 1.0f));
                BoltEffect rightBolt = new BoltEffect(BoltEffect.BoltRenderInfo.ELECTRICITY, new Vector3d(0.025, 0.35, 0.37), new Vector3d(0.025, 0.15, 0.37), 10).size(0.012f).lifespan(6).spawn(BoltEffect.SpawnFunction.noise(3.0f, 1.0f));
                boltRenderer.update(0, leftBolt, partialTicks);
                boltRenderer.update(1, rightBolt, partialTicks);
            }
            matrix.func_227860_a_();
            ModelPos.BODY.translate(this, matrix);
            boltRenderer.render(partialTicks, matrix, renderer);
            matrix.func_227865_b_();
        }
        armorQuads.getTransparentMap().forEach((modelPos, quads) -> {
            matrix.func_227860_a_();
            modelPos.translate(this, matrix);
            this.render(renderer, matrix, light, overlayLight, hasEffect, (List<BakedQuad>)quads, true);
            matrix.func_227865_b_();
        });
    }

    private void render(IRenderTypeBuffer renderer, MatrixStack matrix, int light, int overlayLight, boolean hasEffect, List<BakedQuad> quads, boolean transparent) {
        RenderType renderType = transparent ? RenderType.func_228644_e_((ResourceLocation)AtlasTexture.field_110575_b) : MekanismRenderType.getMekaSuit();
        IVertexBuilder builder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)renderer, (RenderType)renderType, (boolean)false, (boolean)hasEffect);
        MatrixStack.Entry last = matrix.func_227866_c_();
        for (BakedQuad quad : quads) {
            builder.addVertexData(last, quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlayLight);
        }
    }

    private static List<BakedQuad> getQuads(BaseModelCache.ModelData data, Set<String> parts, Set<String> ledParts, QuadTransformation transform) {
        List<BakedQuad> quads = data.bake(new MekaSuitModelConfiguration(parts)).getQuads(null, null, Minecraft.func_71410_x().field_71441_e.func_201674_k(), (IModelData)EmptyModelData.INSTANCE);
        List ledQuads = data.bake(new MekaSuitModelConfiguration(ledParts)).getQuads(null, null, Minecraft.func_71410_x().field_71441_e.func_201674_k(), (IModelData)EmptyModelData.INSTANCE);
        quads.addAll(QuadUtils.transformBakedQuads(ledQuads, QuadTransformation.fullbright));
        if (transform != null) {
            quads = QuadUtils.transformBakedQuads(quads, transform);
        }
        return quads;
    }

    private ArmorQuads createQuads(Set<ModuleModelSpec> modules, Set<EquipmentSlotType> wornParts, boolean hasMekaTool) {
        String name;
        Object2ObjectOpenHashMap specialQuadsToRenderMap = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap specialLEDQuadsToRenderMap = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap overrides = new Object2ObjectOpenHashMap();
        HashSet<String> ignored = new HashSet<String>();
        if (!modules.isEmpty()) {
            Map moduleQuadsToRender = specialQuadsToRenderMap.computeIfAbsent(MekanismModelCache.INSTANCE.MEKASUIT_MODULES, d -> new Object2ObjectOpenHashMap());
            Map moduleLEDQuadsToRender = specialLEDQuadsToRenderMap.computeIfAbsent(MekanismModelCache.INSTANCE.MEKASUIT_MODULES, d -> new Object2ObjectOpenHashMap());
            for (IModelGeometryPart part : MekanismModelCache.INSTANCE.MEKASUIT_MODULES.getModel().getParts()) {
                name = part.name();
                ModuleModelSpec matchingSpec = modules.stream().filter(m -> name.contains(((ModuleModelSpec)m).name)).findFirst().orElse(null);
                if (matchingSpec == null) continue;
                if (name.contains(OVERRIDDEN_TAG)) {
                    overrides.put(matchingSpec.processOverrideName(name), Pair.of((Object)MekanismModelCache.INSTANCE.MEKASUIT_MODULES, (Object)name));
                }
                if (this.type != matchingSpec.slotType) continue;
                ModelPos pos = ModelPos.get(name);
                if (pos == null) {
                    Mekanism.logger.warn("MekaSuit part '{}' is invalid from modules model. Ignoring.", (Object)name);
                }
                if (name.contains(LED_TAG)) {
                    moduleLEDQuadsToRender.computeIfAbsent(pos, p -> new HashSet()).add(name);
                    continue;
                }
                moduleQuadsToRender.computeIfAbsent(pos, p -> new HashSet()).add(name);
            }
        }
        if (this.type == EquipmentSlotType.CHEST && hasMekaTool) {
            for (IModelGeometryPart part : MekanismModelCache.INSTANCE.MEKATOOL.getModel().getParts()) {
                String name2 = part.name();
                if (!name2.contains(OVERRIDDEN_TAG)) continue;
                ignored.add(MekaSuitArmor.processOverrideName(name2, "mekatool"));
            }
        }
        Object2ObjectOpenHashMap armorQuadsToRender = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap armorLEDQuadsToRender = new Object2ObjectOpenHashMap();
        for (IModelGeometryPart part : MekanismModelCache.INSTANCE.MEKASUIT.getModel().getParts()) {
            name = part.name();
            if (!MekaSuitArmor.checkEquipment(this.type, name) || name.startsWith(EXCLUSIVE_TAG) && wornParts.contains(this.adjacentType) || name.startsWith(SHARED_TAG) && wornParts.contains(this.adjacentType) && this.adjacentType.ordinal() > this.type.ordinal()) continue;
            ModelPos pos = ModelPos.get(name);
            if (pos == null) {
                Mekanism.logger.warn("MekaSuit part '{}' is invalid. Ignoring.", (Object)name);
            }
            if (ignored.contains(name)) continue;
            Pair override = (Pair)overrides.get(name);
            if (override != null) {
                String overrideName = (String)override.getRight();
                if (overrideName.contains(LED_TAG)) {
                    ((Map)specialLEDQuadsToRenderMap.get(override.getLeft())).computeIfAbsent(pos, p -> new HashSet()).add(overrideName);
                    continue;
                }
                ((Map)specialQuadsToRenderMap.get(override.getLeft())).computeIfAbsent(pos, p -> new HashSet()).add(overrideName);
                continue;
            }
            if (name.contains(LED_TAG)) {
                armorLEDQuadsToRender.computeIfAbsent(pos, p -> new HashSet()).add(name);
                continue;
            }
            armorQuadsToRender.computeIfAbsent(pos, p -> new HashSet()).add(name);
        }
        Object2ObjectOpenHashMap opaqueMap = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap transparentMap = new Object2ObjectOpenHashMap();
        for (ModelPos pos : ModelPos.VALUES) {
            for (BaseModelCache.ModelData modelData : specialModels) {
                MekaSuitArmor.parseTransparency(modelData, pos, (Map<ModelPos, List<BakedQuad>>)opaqueMap, (Map<ModelPos, List<BakedQuad>>)transparentMap, ((Map)specialQuadsToRenderMap.getOrDefault(modelData, new Object2ObjectOpenHashMap())).getOrDefault((Object)pos, new HashSet()), ((Map)specialLEDQuadsToRenderMap.getOrDefault(modelData, new Object2ObjectOpenHashMap())).getOrDefault((Object)pos, new HashSet()));
            }
            MekaSuitArmor.parseTransparency(MekanismModelCache.INSTANCE.MEKASUIT, pos, (Map<ModelPos, List<BakedQuad>>)opaqueMap, (Map<ModelPos, List<BakedQuad>>)transparentMap, armorQuadsToRender.getOrDefault((Object)pos, new HashSet()), armorLEDQuadsToRender.getOrDefault((Object)pos, new HashSet()));
        }
        return new ArmorQuads((Map<ModelPos, List<BakedQuad>>)opaqueMap, (Map<ModelPos, List<BakedQuad>>)transparentMap);
    }

    private static void parseTransparency(BaseModelCache.ModelData modelData, ModelPos pos, Map<ModelPos, List<BakedQuad>> opaqueMap, Map<ModelPos, List<BakedQuad>> transparentMap, Set<String> regularQuads, Set<String> ledQuads) {
        HashSet<String> opaqueRegularQuads = new HashSet<String>();
        HashSet<String> opaqueLEDQuads = new HashSet<String>();
        HashSet<String> transparentRegularQuads = new HashSet<String>();
        HashSet<String> transparentLEDQuads = new HashSet<String>();
        regularQuads.forEach(s -> (s.contains(GLASS_TAG) ? transparentRegularQuads : opaqueRegularQuads).add(s));
        ledQuads.forEach(s -> (s.contains(GLASS_TAG) ? transparentLEDQuads : opaqueLEDQuads).add(s));
        opaqueMap.computeIfAbsent(pos, p -> new ArrayList()).addAll(MekaSuitArmor.getQuads(modelData, opaqueRegularQuads, opaqueLEDQuads, pos.getTransform()));
        transparentMap.computeIfAbsent(pos, p -> new ArrayList()).addAll(MekaSuitArmor.getQuads(modelData, transparentRegularQuads, transparentLEDQuads, pos.getTransform()));
    }

    private static boolean checkEquipment(EquipmentSlotType type, String text) {
        if (type == EquipmentSlotType.HEAD && text.contains("helmet")) {
            return true;
        }
        if (type == EquipmentSlotType.CHEST && text.contains("chest")) {
            return true;
        }
        if (type == EquipmentSlotType.LEGS && text.contains("leggings")) {
            return true;
        }
        return type == EquipmentSlotType.FEET && text.contains("boots");
    }

    private static String processOverrideName(String part, String name) {
        return part.replace(OVERRIDDEN_TAG, "").replace(name + "_", "");
    }

    private static void registerModule(String name, Modules.ModuleData<?> module, EquipmentSlotType slotType) {
        moduleModelSpec.put((Object)slotType, module, (Object)new ModuleModelSpec(module, slotType, name));
    }

    public TransmitterBakedModel.QuickHash key(LivingEntity player) {
        ObjectOpenHashSet modules = new ObjectOpenHashSet();
        EnumSet<EquipmentSlotType> wornParts = EnumSet.noneOf(EquipmentSlotType.class);
        boolean hasMekaTool = player.func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b() instanceof ItemMekaTool;
        for (EquipmentSlotType slotType : EnumUtils.ARMOR_SLOTS) {
            if (player.func_184582_a(slotType).func_77973_b() instanceof ItemMekaSuitArmor) {
                wornParts.add(slotType);
            }
            for (Modules.ModuleData module : moduleModelSpec.row((Object)slotType).keySet()) {
                if (!Modules.isEnabled(player.func_184582_a(slotType), module)) continue;
                modules.add(moduleModelSpec.get((Object)slotType, (Object)module));
            }
        }
        return new TransmitterBakedModel.QuickHash(modules, wornParts, hasMekaTool);
    }

    static /* synthetic */ QuadTransformation access$100() {
        return BASE_TRANSFORM;
    }

    static {
        MekaSuitArmor.registerModule("solar_helmet", Modules.SOLAR_RECHARGING_UNIT, EquipmentSlotType.HEAD);
        MekaSuitArmor.registerModule("jetpack", Modules.JETPACK_UNIT, EquipmentSlotType.CHEST);
        MekaSuitArmor.registerModule("modulator", Modules.GRAVITATIONAL_MODULATING_UNIT, EquipmentSlotType.CHEST);
        BASE_TRANSFORM = QuadTransformation.list(QuadTransformation.rotate(0.0, 0.0, 180.0), QuadTransformation.translate(new Vector3d(-1.0, 0.5, 0.0)));
    }

    private static class MekaSuitModelConfiguration
    implements IModelConfiguration {
        private final Set<String> parts;

        public MekaSuitModelConfiguration(Set<String> parts) {
            this.parts = parts;
        }

        @Nullable
        public IUnbakedModel getOwnerModel() {
            return null;
        }

        @Nonnull
        public String getModelName() {
            return "mekasuit";
        }

        public boolean isTexturePresent(@Nonnull String name) {
            return false;
        }

        @Nonnull
        public RenderMaterial resolveTexture(@Nonnull String name) {
            return ModelLoaderRegistry.blockMaterial((String)name);
        }

        public boolean isShadedInGui() {
            return false;
        }

        public boolean isSideLit() {
            return false;
        }

        public boolean useSmoothLighting() {
            return true;
        }

        @Nonnull
        @Deprecated
        public ItemCameraTransforms getCameraTransforms() {
            return ItemCameraTransforms.field_178357_a;
        }

        @Nonnull
        public IModelTransform getCombinedTransform() {
            return ModelRotation.X0_Y0;
        }

        public boolean getPartVisibility(@Nonnull IModelGeometryPart part, boolean fallback) {
            return this.getPartVisibility(part);
        }

        public boolean getPartVisibility(@Nonnull IModelGeometryPart part) {
            return this.parts.contains(part.name());
        }
    }

    public static class ModuleModelSpec {
        private final Modules.ModuleData<?> module;
        private final EquipmentSlotType slotType;
        private final String name;
        private final Predicate<String> modelSpec;

        public ModuleModelSpec(Modules.ModuleData<?> module, EquipmentSlotType slotType, String name) {
            this.module = module;
            this.slotType = slotType;
            this.name = name;
            this.modelSpec = s -> s.contains(name + "_");
        }

        public boolean contains(String s) {
            return this.modelSpec.test(s);
        }

        public String processOverrideName(String part) {
            return MekaSuitArmor.processOverrideName(part, this.name);
        }

        public Modules.ModuleData<?> getModule() {
            return this.module;
        }
    }

    public static class ArmorQuads {
        private final Map<ModelPos, List<BakedQuad>> opaqueQuads;
        private final Map<ModelPos, List<BakedQuad>> transparentQuads;

        public ArmorQuads(Map<ModelPos, List<BakedQuad>> opaqueQuads, Map<ModelPos, List<BakedQuad>> transparentQuads) {
            this.opaqueQuads = opaqueQuads;
            this.transparentQuads = transparentQuads;
        }

        public Map<ModelPos, List<BakedQuad>> getOpaqueMap() {
            return this.opaqueQuads;
        }

        public Map<ModelPos, List<BakedQuad>> getTransparentMap() {
            return this.transparentQuads;
        }
    }

    public static enum ModelPos {
        HEAD(MekaSuitArmor.access$100(), s -> s.contains("head")),
        BODY(MekaSuitArmor.access$100(), s -> s.contains("body")),
        LEFT_ARM(MekaSuitArmor.access$100().and(QuadTransformation.translate(new Vector3d(-0.3125, -0.125, 0.0))), s -> s.contains("left_arm")),
        RIGHT_ARM(MekaSuitArmor.access$100().and(QuadTransformation.translate(new Vector3d(0.3125, -0.125, 0.0))), s -> s.contains("right_arm")),
        LEFT_LEG(MekaSuitArmor.access$100().and(QuadTransformation.translate(new Vector3d(-0.125, -0.75, 0.0))), s -> s.contains("left_leg")),
        RIGHT_LEG(MekaSuitArmor.access$100().and(QuadTransformation.translate(new Vector3d(0.125, -0.75, 0.0))), s -> s.contains("right_leg"));

        public static final ModelPos[] VALUES;
        private final QuadTransformation transform;
        private final Predicate<String> modelSpec;

        private ModelPos(QuadTransformation transform, Predicate<String> modelSpec) {
            this.transform = transform;
            this.modelSpec = modelSpec;
        }

        public QuadTransformation getTransform() {
            return this.transform;
        }

        public boolean contains(String s) {
            return this.modelSpec.test(s);
        }

        public static ModelPos get(String name) {
            for (ModelPos pos : VALUES) {
                if (!pos.contains(name.toLowerCase(Locale.ROOT))) continue;
                return pos;
            }
            return null;
        }

        public void translate(MekaSuitArmor armor, MatrixStack matrix) {
            switch (this) {
                case HEAD: {
                    armor.field_78116_c.func_228307_a_(matrix);
                    break;
                }
                case BODY: {
                    armor.field_78115_e.func_228307_a_(matrix);
                    break;
                }
                case LEFT_ARM: {
                    armor.field_178724_i.func_228307_a_(matrix);
                    break;
                }
                case RIGHT_ARM: {
                    armor.field_178723_h.func_228307_a_(matrix);
                    break;
                }
                case LEFT_LEG: {
                    armor.field_178722_k.func_228307_a_(matrix);
                    break;
                }
                case RIGHT_LEG: {
                    armor.field_178721_j.func_228307_a_(matrix);
                }
            }
        }

        static {
            VALUES = ModelPos.values();
        }
    }
}

