/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.model.ModelSeismicVibrator;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.IWireFrameRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.machine.TileEntitySeismicVibrator;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.vector.Vector3f;

@ParametersAreNonnullByDefault
public class RenderSeismicVibrator
extends MekanismTileEntityRenderer<TileEntitySeismicVibrator>
implements IWireFrameRenderer {
    private final ModelSeismicVibrator model = new ModelSeismicVibrator();

    public RenderSeismicVibrator(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntitySeismicVibrator tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        float actualRate = this.performTranslationsAndGetRate(tile, partialTick, matrix);
        this.model.render(matrix, renderer, light, overlayLight, actualRate, false);
        matrix.func_227865_b_();
    }

    @Override
    protected String getProfilerSection() {
        return "seismicVibrator";
    }

    public boolean isGlobalRenderer(TileEntitySeismicVibrator tile) {
        return true;
    }

    @Override
    public void renderWireFrame(TileEntity tile, float partialTick, MatrixStack matrix, IVertexBuilder buffer, float red, float green, float blue, float alpha) {
        if (tile instanceof TileEntitySeismicVibrator) {
            float actualRate = this.performTranslationsAndGetRate((TileEntitySeismicVibrator)tile, partialTick, matrix);
            this.model.renderWireFrame(matrix, buffer, actualRate, red, green, blue, alpha);
            matrix.func_227865_b_();
        }
    }

    private float performTranslationsAndGetRate(TileEntitySeismicVibrator tile, float partialTick, MatrixStack matrix) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 1.5, 0.5);
        MekanismRenderer.rotate(matrix, tile.getDirection(), 0.0f, 180.0f, 90.0f, 270.0f);
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        return Math.max(0.0f, (float)Math.sin(((float)tile.clientPiston + (tile.getActive() ? partialTick : 0.0f)) / 5.0f));
    }
}

