/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.evaporation;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IEvaporationSolar;
import mekanism.api.annotations.NonNull;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.FluidToFluidCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.fluid.MultiblockFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.MultiblockHeatCapacitor;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.sync.dynamic.ContainerSync;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.lib.multiblock.IValveHandler;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.tile.interfaces.ITileCachedRecipeHolder;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationBlock;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;

public class EvaporationMultiblockData
extends MultiblockData
implements ITileCachedRecipeHolder<FluidToFluidRecipe>,
IValveHandler {
    private static final int MAX_OUTPUT = 10000;
    private static final int MAX_HEIGHT = 18;
    public static final double MAX_MULTIPLIER_TEMP = 3000.0;
    @ContainerSync
    public BasicFluidTank inputTank;
    @ContainerSync
    public BasicFluidTank outputTank;
    @ContainerSync
    public BasicHeatCapacitor heatCapacitor;
    private boolean temperatureSet;
    private double biomeTemp;
    private double tempMultiplier;
    public float prevScale;
    @ContainerSync
    public double lastGain;
    @ContainerSync
    public double totalLoss;
    private CachedRecipe<FluidToFluidRecipe> cachedRecipe;
    private IEvaporationSolar[] solars = new IEvaporationSolar[4];
    private final IOutputHandler<@NonNull FluidStack> outputHandler;
    private final IInputHandler<@NonNull FluidStack> inputHandler;
    private final FluidInventorySlot inputInputSlot;
    private final OutputInventorySlot outputInputSlot;
    private final FluidInventorySlot inputOutputSlot;
    private final OutputInventorySlot outputOutputSlot;

    public EvaporationMultiblockData(TileEntityThermalEvaporationBlock tile) {
        super(tile);
        this.inputTank = MultiblockFluidTank.input(this, tile, this::getMaxFluid, fluid -> this.containsRecipe(recipe -> recipe.getInput().testType(fluid)));
        this.fluidTanks.add(this.inputTank);
        this.outputTank = MultiblockFluidTank.output(this, tile, () -> 10000, BasicFluidTank.alwaysTrue);
        this.fluidTanks.add(this.outputTank);
        this.inputHandler = InputHelper.getInputHandler(this.inputTank);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputTank);
        this.inputInputSlot = FluidInventorySlot.fill(this.inputTank, this, 28, 20);
        this.inventorySlots.add(this.inputInputSlot);
        this.outputInputSlot = OutputInventorySlot.at(this, 28, 51);
        this.inventorySlots.add(this.outputInputSlot);
        this.inputOutputSlot = FluidInventorySlot.drain(this.outputTank, this, 132, 20);
        this.inventorySlots.add(this.inputOutputSlot);
        this.outputOutputSlot = OutputInventorySlot.at(this, 132, 51);
        this.inventorySlots.add(this.outputOutputSlot);
        this.inputInputSlot.setSlotType(ContainerSlotType.INPUT);
        this.inputOutputSlot.setSlotType(ContainerSlotType.INPUT);
        this.heatCapacitor = MultiblockHeatCapacitor.create(this, tile, MekanismConfig.general.evaporationHeatCapacity.get() * 3.0);
        this.heatCapacitors.add(this.heatCapacitor);
    }

    @Override
    public void onCreated(World world) {
        super.onCreated(world);
        this.heatCapacitor.setHeatCapacity(MekanismConfig.general.evaporationHeatCapacity.get() * (double)this.height(), true);
        this.updateSolars(world);
    }

    @Override
    public boolean tick(World world) {
        float scale;
        boolean needsPacket = super.tick(world);
        this.updateTemperature(world);
        this.inputOutputSlot.drainTank(this.outputOutputSlot);
        this.inputInputSlot.fillTank(this.outputInputSlot);
        this.cachedRecipe = this.getUpdatedCache(0);
        if (this.cachedRecipe != null) {
            this.cachedRecipe.process();
        }
        if ((scale = MekanismUtils.getScale(this.prevScale, this.inputTank)) != this.prevScale) {
            this.prevScale = scale;
            needsPacket = true;
        }
        return needsPacket;
    }

    @Override
    public void readUpdateTag(CompoundNBT tag) {
        super.readUpdateTag(tag);
        NBTUtils.setFluidStackIfPresent(tag, "fluid", fluid -> this.inputTank.setStack((FluidStack)fluid));
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            this.prevScale = scale;
        });
        this.readValves(tag);
    }

    @Override
    public void writeUpdateTag(CompoundNBT tag) {
        super.writeUpdateTag(tag);
        tag.func_218657_a("fluid", (INBT)this.inputTank.getFluid().writeToNBT(new CompoundNBT()));
        tag.func_74776_a("scale", this.prevScale);
        this.writeValves(tag);
    }

    private void updateTemperature(World world) {
        if (!this.temperatureSet) {
            this.biomeTemp = world.func_225523_d_().func_226836_a_(this.getMinPos()).func_225486_c(this.getMinPos());
            this.temperatureSet = true;
        }
        this.heatCapacitor.handleHeat(MekanismConfig.general.evaporationSolarMultiplier.get() * (double)this.getActiveSolars() * this.heatCapacitor.getHeatCapacity());
        double biome = this.biomeTemp - 0.5;
        double base = biome > 0.0 ? biome * 20.0 : this.biomeTemp * 40.0;
        base += 300.0;
        if (Math.abs(this.getTemp() - base) < 0.001) {
            this.heatCapacitor.handleHeat(base * this.heatCapacitor.getHeatCapacity() - this.heatCapacitor.getHeat());
            this.totalLoss = 0.0;
        } else {
            double incr = MekanismConfig.general.evaporationHeatDissipation.get() * Math.sqrt(Math.abs(this.heatCapacitor.getTemperature() - base));
            if (this.heatCapacitor.getTemperature() > base) {
                incr = -incr;
            }
            this.heatCapacitor.handleHeat(this.heatCapacitor.getHeatCapacity() * incr);
            this.totalLoss = incr < 0.0 ? -incr / this.heatCapacitor.getHeatCapacity() : 0.0;
        }
        this.tempMultiplier = (Math.min(3000.0, this.heatCapacitor.getTemperature()) - 300.0) * MekanismConfig.general.evaporationTempMultiplier.get() * ((double)this.height() / 18.0);
        this.updateHeatCapacitors(null);
    }

    public double getTemp() {
        return this.heatCapacitor.getTemperature();
    }

    public int getMaxFluid() {
        return this.height() * 4 * 64000;
    }

    @Override
    @Nonnull
    public MekanismRecipeType<FluidToFluidRecipe> getRecipeType() {
        return MekanismRecipeType.EVAPORATING;
    }

    @Override
    @Nullable
    public CachedRecipe<FluidToFluidRecipe> getCachedRecipe(int cacheIndex) {
        return this.cachedRecipe;
    }

    @Override
    @Nullable
    public FluidToFluidRecipe getRecipe(int cacheIndex) {
        FluidStack fluid = this.inputHandler.getInput();
        if (fluid.isEmpty()) {
            return null;
        }
        return (FluidToFluidRecipe)this.findFirstRecipe(recipe -> recipe.test(fluid));
    }

    @Override
    @Nullable
    public CachedRecipe<FluidToFluidRecipe> createNewCachedRecipe(@Nonnull FluidToFluidRecipe recipe, int cacheIndex) {
        return new FluidToFluidCachedRecipe(recipe, this.inputHandler, this.outputHandler).setActive(active -> {
            this.lastGain = active ? (this.tempMultiplier > 0.0 && this.tempMultiplier < 1.0 ? (double)(1.0f / (float)((int)Math.ceil(1.0 / this.tempMultiplier))) : this.tempMultiplier) : 0.0;
        }).setRequiredTicks(() -> this.tempMultiplier > 0.0 && this.tempMultiplier < 1.0 ? (int)Math.ceil(1.0 / this.tempMultiplier) : 1).setPostProcessOperations(currentMax -> {
            if (currentMax <= 0) {
                return currentMax;
            }
            return Math.min(currentMax, this.tempMultiplier > 0.0 && this.tempMultiplier < 1.0 ? 1 : (int)this.tempMultiplier);
        });
    }

    @Override
    public World getTileWorld() {
        return this.getWorld();
    }

    private int getActiveSolars() {
        int ret = 0;
        for (IEvaporationSolar solar : this.solars) {
            if (solar == null || !solar.canSeeSun()) continue;
            ++ret;
        }
        return ret;
    }

    private void addSolarPanel(TileEntity tile, int i) {
        if (tile != null && !tile.func_145837_r()) {
            CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.EVAPORATION_SOLAR_CAPABILITY, Direction.DOWN).ifPresent(solar -> {
                this.solars[i] = solar;
            });
        }
    }

    public boolean isSolarSpot(BlockPos pos) {
        return pos.func_177956_o() == this.getMaxPos().func_177956_o() && this.getBounds().isOnCorner(pos);
    }

    public void updateSolars(World world) {
        this.solars = new IEvaporationSolar[4];
        this.addSolarPanel(WorldUtils.getTileEntity((IBlockReader)world, this.getMaxPos()), 0);
        this.addSolarPanel(WorldUtils.getTileEntity((IBlockReader)world, this.getMaxPos().func_177982_a(-3, 0, 0)), 1);
        this.addSolarPanel(WorldUtils.getTileEntity((IBlockReader)world, this.getMaxPos().func_177982_a(0, 0, -3)), 2);
        this.addSolarPanel(WorldUtils.getTileEntity((IBlockReader)world, this.getMaxPos().func_177982_a(-3, 0, -3)), 3);
    }

    @Override
    protected int getMultiblockRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.inputTank.getFluidAmount(), this.inputTank.getCapacity());
    }
}

