/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import mekanism.api.math.MathUtils;
import mekanism.api.text.ILangEntry;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.Modules;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public class ModuleConfigItem<TYPE> {
    private final Module module;
    private final String name;
    private final ILangEntry description;
    private final ConfigData<TYPE> data;

    public ModuleConfigItem(Module module, String name, ILangEntry description, ConfigData<TYPE> data, TYPE def) {
        this.module = module;
        this.name = name;
        this.description = description;
        this.data = data;
        data.set(def);
    }

    public ILangEntry getDescription() {
        return this.description;
    }

    public ConfigData<TYPE> getData() {
        return this.data;
    }

    public TYPE get() {
        return this.data.get();
    }

    public void set(TYPE type, Consumer<ItemStack> callback) {
        this.data.set(type);
        for (Module m : Modules.loadAll(this.module.getContainer())) {
            if (this.name.equals("enabled") && type == Boolean.TRUE && this.module.getData().isExclusive() && m.getData().isExclusive() && m.getData() != this.module.getData()) {
                m.setDisabledForce();
            }
            if (!this.name.equals("handleModeChange") || type != Boolean.TRUE || !this.module.handlesModeChange() || !m.handlesModeChange() || m.getData() == this.module.getData()) continue;
            m.setModeHandlingDisabledForce();
        }
        this.module.save(callback);
    }

    public void read(CompoundNBT tag) {
        if (tag.func_74764_b(this.name)) {
            this.data.read(this.name, tag);
        }
    }

    public void write(CompoundNBT tag) {
        this.data.write(this.name, tag);
    }

    public String getName() {
        return this.name;
    }

    public static class EnumData<TYPE extends Enum<TYPE>>
    implements ConfigData<TYPE> {
        private final Class<TYPE> enumClass;
        private final int selectableCount;
        private TYPE value;

        public EnumData(Class<TYPE> enumClass) {
            this(enumClass, ((Enum[])enumClass.getEnumConstants()).length);
        }

        public EnumData(Class<TYPE> enumClass, int selectableCount) {
            this.enumClass = enumClass;
            this.selectableCount = selectableCount;
        }

        @Override
        public TYPE get() {
            return this.value;
        }

        @Override
        public void set(TYPE val) {
            this.value = val;
        }

        @Override
        public void read(String name, CompoundNBT tag) {
            int index = Math.min(tag.func_74762_e(name), this.selectableCount - 1);
            this.value = MathUtils.getByIndexMod(this.getEnums(), index);
        }

        @Override
        public void write(String name, CompoundNBT tag) {
            tag.func_74768_a(name, ((Enum)this.value).ordinal());
        }

        public TYPE[] getEnums() {
            return (Enum[])this.enumClass.getEnumConstants();
        }

        public int getSelectableCount() {
            return this.selectableCount;
        }
    }

    public static class BooleanData
    implements ConfigData<Boolean> {
        private boolean value;

        public BooleanData() {
            this(true);
        }

        public BooleanData(boolean def) {
            this.value = def;
        }

        @Override
        public Boolean get() {
            return this.value;
        }

        @Override
        public void set(Boolean val) {
            this.value = val;
        }

        @Override
        public void read(String name, CompoundNBT tag) {
            this.value = tag.func_74767_n(name);
        }

        @Override
        public void write(String name, CompoundNBT tag) {
            tag.func_74757_a(name, this.value);
        }
    }

    public static class DisableableModuleConfigItem
    extends ModuleConfigItem<Boolean> {
        private final BooleanSupplier isConfigEnabled;

        public DisableableModuleConfigItem(Module module, String name, ILangEntry description, boolean def, BooleanSupplier isConfigEnabled) {
            super(module, name, description, new BooleanData(), def);
            this.isConfigEnabled = isConfigEnabled;
        }

        @Override
        public Boolean get() {
            return this.isConfigEnabled() && (Boolean)super.get() != false;
        }

        public boolean isConfigEnabled() {
            return this.isConfigEnabled.getAsBoolean();
        }
    }

    public static interface ConfigData<TYPE> {
        public TYPE get();

        public void set(TYPE var1);

        public void read(String var1, CompoundNBT var2);

        public void write(String var1, CompoundNBT var2);
    }
}

