/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync.list;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.annotations.NonNull;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.container.property.list.ListPropertyData;

public abstract class SyncableList<TYPE>
implements ISyncableData {
    private final Supplier<@NonNull List<TYPE>> getter;
    private final Consumer<@NonNull List<TYPE>> setter;
    private int lastKnownHashCode;

    protected SyncableList(Supplier<@NonNull List<TYPE>> getter, Consumer<@NonNull List<TYPE>> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @Nonnull
    public List<TYPE> get() {
        return this.getter.get();
    }

    public void set(@Nonnull List<TYPE> value) {
        this.setter.accept(value);
    }

    @Override
    public abstract ListPropertyData<TYPE> getPropertyData(short var1, ISyncableData.DirtyType var2);

    @Override
    public ISyncableData.DirtyType isDirty() {
        List<TYPE> values = this.get();
        int valuesHashCode = values.hashCode();
        if (this.lastKnownHashCode == valuesHashCode) {
            return ISyncableData.DirtyType.CLEAN;
        }
        this.lastKnownHashCode = valuesHashCode;
        return ISyncableData.DirtyType.DIRTY;
    }
}

