/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.item.ItemEnergized;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.lib.transmitter.TransmitterNetworkRegistry;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemNetworkReader
extends ItemEnergized {
    public ItemNetworkReader(Item.Properties properties) {
        super(MekanismConfig.gear.networkReaderChargeRate, MekanismConfig.gear.networkReaderMaxEnergy, properties.func_208103_a(Rarity.UNCOMMON));
    }

    private void displayBorder(PlayerEntity player, Object toDisplay, boolean brackets) {
        player.func_145747_a((ITextComponent)MekanismLang.NETWORK_READER_BORDER.translateColored(EnumColor.GRAY, "-------------", EnumColor.DARK_BLUE, brackets ? MekanismLang.GENERIC_SQUARE_BRACKET.translate(toDisplay) : toDisplay), Util.field_240973_b_);
    }

    private void displayEndBorder(PlayerEntity player) {
        this.displayBorder(player, "[=======]", false);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        if (!world.field_72995_K && player != null) {
            BlockPos pos = context.func_195995_a();
            TileEntity tile = WorldUtils.getTileEntity((IBlockReader)world, pos);
            if (tile != null) {
                if (!player.func_184812_l_()) {
                    FloatingLong energyPerUse = (FloatingLong)MekanismConfig.gear.networkReaderEnergyUsage.get();
                    IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(context.func_195996_i(), 0);
                    if (energyContainer == null || energyContainer.extract(energyPerUse, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyPerUse)) {
                        return ActionResultType.FAIL;
                    }
                    energyContainer.extract(energyPerUse, Action.EXECUTE, AutomationType.MANUAL);
                }
                Direction opposite = context.func_196000_l().func_176734_d();
                if (tile instanceof TileEntityTransmitter) {
                    this.displayTransmitterInfo(player, ((TileEntityTransmitter)tile).getTransmitter(), tile, opposite);
                } else {
                    Optional heatHandler = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.HEAT_HANDLER_CAPABILITY, opposite).resolve();
                    if (heatHandler.isPresent()) {
                        IHeatHandler transfer = (IHeatHandler)heatHandler.get();
                        this.displayBorder(player, MekanismLang.MEKANISM, true);
                        this.sendTemperature(player, transfer);
                        this.displayEndBorder(player);
                    } else {
                        this.displayConnectedNetworks(player, world, pos);
                    }
                }
                return ActionResultType.SUCCESS;
            }
            if (player.func_225608_bj_() && MekanismAPI.debug) {
                this.displayBorder(player, MekanismLang.DEBUG_TITLE, true);
                for (ITextComponent component : TransmitterNetworkRegistry.getInstance().toComponents()) {
                    player.func_145747_a((ITextComponent)TextComponentUtil.build(EnumColor.DARK_GRAY, component), Util.field_240973_b_);
                }
                this.displayEndBorder(player);
            }
        }
        return ActionResultType.PASS;
    }

    private void displayTransmitterInfo(PlayerEntity player, Transmitter<?, ?, ?> transmitter, TileEntity tile, Direction opposite) {
        this.displayBorder(player, MekanismLang.MEKANISM, true);
        if (transmitter.hasTransmitterNetwork()) {
            Object transmitterNetwork = transmitter.getTransmitterNetwork();
            player.func_145747_a((ITextComponent)MekanismLang.NETWORK_READER_TRANSMITTERS.translateColored(EnumColor.GRAY, EnumColor.DARK_GRAY, ((DynamicNetwork)transmitterNetwork).transmittersSize()), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)MekanismLang.NETWORK_READER_ACCEPTORS.translateColored(EnumColor.GRAY, EnumColor.DARK_GRAY, ((DynamicNetwork)transmitterNetwork).getAcceptorCount()), Util.field_240973_b_);
            this.sendMessageIfNonNull(player, MekanismLang.NETWORK_READER_NEEDED, transmitterNetwork.getNeededInfo());
            this.sendMessageIfNonNull(player, MekanismLang.NETWORK_READER_BUFFER, transmitterNetwork.getStoredInfo());
            this.sendMessageIfNonNull(player, MekanismLang.NETWORK_READER_THROUGHPUT, transmitterNetwork.getFlowInfo());
            this.sendMessageIfNonNull(player, MekanismLang.NETWORK_READER_CAPACITY, transmitterNetwork.getNetworkReaderCapacity());
            CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.HEAT_HANDLER_CAPABILITY, opposite).ifPresent(heatHandler -> this.sendTemperature(player, (IHeatHandler)heatHandler));
        } else {
            player.func_145747_a((ITextComponent)MekanismLang.NO_NETWORK.translate(new Object[0]), Util.field_240973_b_);
        }
        this.displayEndBorder(player);
    }

    private void displayConnectedNetworks(PlayerEntity player, World world, BlockPos pos) {
        ObjectOpenHashSet iteratedNetworks = new ObjectOpenHashSet();
        for (Direction side : EnumUtils.DIRECTIONS) {
            Transmitter<?, ?, ?> transmitter;
            Object transmitterNetwork;
            TileEntity tile = WorldUtils.getTileEntity((IBlockReader)world, pos.func_177972_a(side));
            if (!(tile instanceof TileEntityTransmitter) || !((DynamicNetwork)(transmitterNetwork = (transmitter = ((TileEntityTransmitter)tile).getTransmitter()).getTransmitterNetwork())).hasAcceptor(pos) || iteratedNetworks.contains(transmitterNetwork)) continue;
            this.displayBorder(player, this.compileList(transmitter.getSupportedTransmissionTypes()), false);
            player.func_145747_a((ITextComponent)MekanismLang.NETWORK_READER_CONNECTED_SIDES.translateColored(EnumColor.GRAY, EnumColor.DARK_GRAY, this.compileList(((DynamicNetwork)transmitterNetwork).getAcceptorDirections(pos))), Util.field_240973_b_);
            this.displayEndBorder(player);
            iteratedNetworks.add(transmitterNetwork);
        }
    }

    private void sendTemperature(PlayerEntity player, IHeatHandler handler) {
        ITextComponent temp = MekanismUtils.getTemperatureDisplay(handler.getTotalTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true);
        player.func_145747_a((ITextComponent)MekanismLang.NETWORK_READER_TEMPERATURE.translateColored(EnumColor.GRAY, EnumColor.DARK_GRAY, temp), Util.field_240973_b_);
    }

    private void sendMessageIfNonNull(PlayerEntity player, ILangEntry langEntry, Object toSend) {
        if (toSend != null) {
            player.func_145747_a((ITextComponent)langEntry.translateColored(EnumColor.GRAY, EnumColor.DARK_GRAY, toSend), Util.field_240973_b_);
        }
    }

    private <ENUM extends Enum<ENUM>> ITextComponent compileList(Set<ENUM> elements) {
        if (elements.isEmpty()) {
            return MekanismLang.GENERIC_SQUARE_BRACKET.translate("");
        }
        IFormattableTextComponent component = null;
        for (Enum element : elements) {
            if (component == null) {
                component = TextComponentUtil.build(element);
                continue;
            }
            component = MekanismLang.GENERIC_WITH_COMMA.translate(component, element);
        }
        return MekanismLang.GENERIC_SQUARE_BRACKET.translate(component);
    }
}

