/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.item.ItemPortableTeleporter;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.network.PacketPortableTeleporter;
import mekanism.common.network.PacketPortalFX;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PacketPortableTeleporterGui {
    private final PortableTeleporterPacketType packetType;
    private final TeleporterFrequency frequency;
    private final Hand currentHand;

    public PacketPortableTeleporterGui(PortableTeleporterPacketType type, Hand hand, TeleporterFrequency freq) {
        this.packetType = type;
        this.currentHand = hand;
        this.frequency = freq;
    }

    public static void handle(PacketPortableTeleporterGui message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity player = ctx.getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = player.func_184586_b(message.currentHand);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemPortableTeleporter) {
                if (message.packetType == PortableTeleporterPacketType.DATA_REQUEST) {
                    PacketPortableTeleporterGui.sendDataResponse(message.frequency, (PlayerEntity)player, stack);
                } else if (message.packetType == PortableTeleporterPacketType.TELEPORT) {
                    ServerWorld teleWorld;
                    TileEntityTeleporter teleporter;
                    FrequencyManager<TeleporterFrequency> manager2 = FrequencyType.TELEPORTER.getManager(message.frequency.isPublic() ? null : player.func_110124_au());
                    TeleporterFrequency found = manager2.getFrequency(message.frequency.getName());
                    if (found == null) {
                        return;
                    }
                    Coord4D coords = found.getClosestCoords(new Coord4D((Entity)player));
                    if (coords != null && (teleporter = WorldUtils.getTileEntity(TileEntityTeleporter.class, (IBlockReader)(teleWorld = ServerLifecycleHooks.getCurrentServer().func_71218_a(coords.dimension)), coords.getPos())) != null) {
                        try {
                            if (!player.func_184812_l_()) {
                                FloatingLong energyCost = TileEntityTeleporter.calculateEnergyCost((Entity)player, coords);
                                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                                if (energyContainer == null || energyContainer.extract(energyCost, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyCost)) {
                                    return;
                                }
                                energyContainer.extract(energyCost, Action.EXECUTE, AutomationType.MANUAL);
                            }
                            teleporter.didTeleport.add(player.func_110124_au());
                            teleporter.teleDelay = 5;
                            player.field_71135_a.field_147365_f = 0;
                            player.func_71053_j();
                            Mekanism.packetHandler.sendToAllTracking(new PacketPortalFX(player.func_233580_cy_()), player.field_70170_p, coords.getPos());
                            if (player.func_184218_aH()) {
                                player.func_184210_p();
                            }
                            TileEntityTeleporter.teleportEntityTo((Entity)player, coords, teleporter);
                            BlockPos coordsPos = coords.getPos();
                            Direction frameDirection = teleporter.frameDirection();
                            if (frameDirection != null) {
                                coordsPos = coordsPos.func_177977_b().func_177972_a(frameDirection);
                            }
                            TileEntityTeleporter.alignPlayer(player, coordsPos);
                            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            Mekanism.packetHandler.sendToAllTracking(new PacketPortalFX(coordsPos), (World)teleWorld, coordsPos);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketPortableTeleporterGui pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.packetType);
        buf.func_179249_a((Enum)pkt.currentHand);
        if (pkt.frequency == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.func_180714_a(pkt.frequency.getName());
            buf.writeBoolean(pkt.frequency.isPublic());
        }
    }

    public static PacketPortableTeleporterGui decode(PacketBuffer buf) {
        PortableTeleporterPacketType packetType = (PortableTeleporterPacketType)buf.func_179257_a(PortableTeleporterPacketType.class);
        Hand currentHand = (Hand)buf.func_179257_a(Hand.class);
        TeleporterFrequency frequency = null;
        if (buf.readBoolean()) {
            frequency = new TeleporterFrequency(BasePacketHandler.readString(buf), null);
            frequency.setPublic(buf.readBoolean());
        }
        return new PacketPortableTeleporterGui(packetType, currentHand, frequency);
    }

    private static void sendDataResponse(TeleporterFrequency given, PlayerEntity player, ItemStack stack) {
        FrequencyManager<TeleporterFrequency> manager;
        TeleporterFrequency freq;
        int status = 3;
        if (given != null && (freq = (manager = FrequencyType.TELEPORTER.getManager(given.isPublic() ? null : player.func_110124_au())).getFrequency(given.getName())) != null && !freq.getActiveCoords().isEmpty()) {
            Coord4D coords;
            status = 1;
            if (!player.func_184812_l_() && (coords = given.getClosestCoords(new Coord4D((Entity)player))) != null) {
                FloatingLong energyNeeded = TileEntityTeleporter.calculateEnergyCost((Entity)player, coords);
                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                if (energyContainer == null || energyContainer.extract(energyNeeded, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyNeeded)) {
                    status = 4;
                }
            }
        }
        Mekanism.packetHandler.sendTo(new PacketPortableTeleporter((byte)status), (ServerPlayerEntity)player);
    }

    public static enum PortableTeleporterPacketType {
        DATA_REQUEST,
        TELEPORT;

    }
}

