/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public final class ItemDataUtils {
    private ItemDataUtils() {
    }

    @Nonnull
    public static CompoundNBT getDataMap(ItemStack stack) {
        ItemDataUtils.initStack(stack);
        return stack.func_77978_p().func_74775_l("mekData");
    }

    @Nullable
    public static CompoundNBT getDataMapIfPresent(ItemStack stack) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack) : null;
    }

    @Nonnull
    public static CompoundNBT getDataMapIfPresentNN(ItemStack stack) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack) : new CompoundNBT();
    }

    public static boolean hasData(ItemStack stack, String key, int type) {
        return ItemDataUtils.hasDataTag(stack) && ItemDataUtils.getDataMap(stack).func_150297_b(key, type);
    }

    public static boolean hasUUID(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) && ItemDataUtils.getDataMap(stack).func_186855_b(key);
    }

    public static void removeData(ItemStack stack, String key) {
        if (ItemDataUtils.hasDataTag(stack)) {
            CompoundNBT dataMap = ItemDataUtils.getDataMap(stack);
            dataMap.func_82580_o(key);
            if (dataMap.isEmpty()) {
                stack.func_77978_p().func_82580_o("mekData");
            }
        }
    }

    public static int getInt(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack).func_74762_e(key) : 0;
    }

    public static long getLong(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack).func_74763_f(key) : 0L;
    }

    public static boolean getBoolean(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) && ItemDataUtils.getDataMap(stack).func_74767_n(key);
    }

    public static double getDouble(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack).func_74769_h(key) : 0.0;
    }

    public static String getString(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack).func_74779_i(key) : "";
    }

    public static CompoundNBT getCompound(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack).func_74775_l(key) : new CompoundNBT();
    }

    @Nullable
    public static UUID getUniqueID(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack).func_186857_a(key) : null;
    }

    public static ListNBT getList(ItemStack stack, String key) {
        return ItemDataUtils.hasDataTag(stack) ? ItemDataUtils.getDataMap(stack).func_150295_c(key, 10) : new ListNBT();
    }

    public static void setInt(ItemStack stack, String key, int i) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).func_74768_a(key, i);
    }

    public static void setLong(ItemStack stack, String key, long l) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).func_74772_a(key, l);
    }

    public static void setBoolean(ItemStack stack, String key, boolean b) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).func_74757_a(key, b);
    }

    public static void setDouble(ItemStack stack, String key, double d) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).func_74780_a(key, d);
    }

    public static void setString(ItemStack stack, String key, String s) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).func_74778_a(key, s);
    }

    public static void setCompound(ItemStack stack, String key, CompoundNBT tag) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).func_218657_a(key, (INBT)tag);
    }

    public static void setUUID(ItemStack stack, String key, UUID uuid) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).func_186854_a(key, uuid);
    }

    public static void setList(ItemStack stack, String key, ListNBT tag) {
        ItemDataUtils.initStack(stack);
        ItemDataUtils.getDataMap(stack).func_218657_a(key, (INBT)tag);
    }

    private static boolean hasDataTag(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("mekData", 10);
    }

    private static void initStack(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (!tag.func_150297_b("mekData", 10)) {
            tag.func_218657_a("mekData", (INBT)new CompoundNBT());
        }
    }
}

