/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.bukkit;

import io.izzel.arclight.common.bridge.bukkit.MaterialBridge;
import io.izzel.arclight.common.mod.util.ResourceLocationUtil;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistries;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftNamespacedKey;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftBlock.class}, remap=false)
public abstract class CraftBlockMixin {
    @Shadow
    public abstract Material getType();

    @Inject(method={"getState"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$getState(CallbackInfoReturnable<BlockState> cir) {
        MaterialBridge bridge = (MaterialBridge)((Object)this.getType());
        if (bridge.bridge$shouldApplyStateFactory()) {
            cir.setReturnValue((Object)bridge.bridge$blockStateFactory().apply((CraftBlock)((Object)this)));
        }
    }

    @Overwrite
    public static Biome biomeBaseToBiome(Registry<net.minecraft.world.biome.Biome> registry, net.minecraft.world.biome.Biome base) {
        return Biome.valueOf(ResourceLocationUtil.standardize(base.getRegistryName()));
    }

    @Overwrite
    public static net.minecraft.world.biome.Biome biomeToBiomeBase(Registry<net.minecraft.world.biome.Biome> registry, Biome bio) {
        return (net.minecraft.world.biome.Biome)ForgeRegistries.BIOMES.getValue(CraftNamespacedKey.toMinecraft(bio.getKey()));
    }
}

