/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.bukkit;

import com.google.common.base.Function;
import io.izzel.arclight.common.bridge.entity.EntityBridge;
import io.izzel.arclight.common.mod.ArclightMod;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftEventFactory.class}, remap=false)
public class CraftEventFactoryMixin {
    @Shadow
    public static Entity entityDamage;
    @Shadow
    public static Block blockDamage;

    @Inject(method={"handleEntityDamageEvent(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/DamageSource;Ljava/util/Map;Ljava/util/Map;Z)Lorg/bukkit/event/entity/EntityDamageEvent;"}, at={@At(value="HEAD")})
    private static void arclight$captureSource(Entity entity, DamageSource source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, Function<? super Double, Double>> modifierFunctions, boolean cancelled, CallbackInfoReturnable<EntityDamageEvent> cir) {
        Entity damageEventEntity = ArclightCaptures.getDamageEventEntity();
        BlockPos damageEventBlock = ArclightCaptures.getDamageEventBlock();
        if (damageEventEntity != null && entityDamage == null && source.field_76373_n.equals(DamageSource.field_180137_b.field_76373_n)) {
            entityDamage = damageEventEntity;
        }
        if (damageEventBlock != null && blockDamage == null && (source.field_76373_n.equals(DamageSource.field_76367_g.field_76373_n) || source.field_76373_n.equals(DamageSource.field_220302_v.field_76373_n) || source.field_76373_n.equals(DamageSource.field_190095_e.field_76373_n))) {
            blockDamage = CraftBlock.at((IWorld)entity.func_130014_f_(), damageEventBlock);
        }
    }

    @Inject(method={"handleEntityDamageEvent(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/DamageSource;Ljava/util/Map;Ljava/util/Map;Z)Lorg/bukkit/event/entity/EntityDamageEvent;"}, cancellable=true, at={@At(value="NEW", target="java/lang/IllegalStateException")})
    private static void arclight$unhandledDamage(Entity entity, DamageSource source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, Function<? super Double, Double>> modifierFunctions, boolean cancelled, CallbackInfoReturnable<EntityDamageEvent> cir) {
        EntityDamageEvent event;
        if (source.func_76346_g() != null) {
            ArclightMod.LOGGER.debug("Unhandled damage of {} by {} from {}", (Object)entity, (Object)source.func_76346_g(), (Object)source.field_76373_n);
            event = new EntityDamageByEntityEvent(((EntityBridge)source.func_76346_g()).bridge$getBukkitEntity(), ((EntityBridge)entity).bridge$getBukkitEntity(), EntityDamageEvent.DamageCause.CUSTOM, modifiers, modifierFunctions);
        } else {
            ArclightMod.LOGGER.debug("Unhandled damage of {} from {}", (Object)entity, (Object)source.field_76373_n);
            event = new EntityDamageEvent(((EntityBridge)entity).bridge$getBukkitEntity(), EntityDamageEvent.DamageCause.CUSTOM, modifiers, modifierFunctions);
        }
        event.setCancelled(cancelled);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            ((EntityBridge)entity).bridge$getBukkitEntity().setLastDamageCause(event);
        }
        cir.setReturnValue((Object)event);
    }
}

