/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.bukkit;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import io.izzel.arclight.common.bridge.bukkit.CraftServerBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.mod.server.ArclightServer;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import jline.console.ConsoleReader;
import net.minecraft.command.CommandSource;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_16_R3.command.CraftCommandMap;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.help.SimpleHelpMap;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CraftServer.class})
public abstract class CraftServerMixin
implements CraftServerBridge {
    @Shadow(remap=false)
    @Final
    private CraftCommandMap commandMap;
    @Shadow(remap=false)
    @Final
    private SimplePluginManager pluginManager;
    @Shadow(remap=false)
    @Final
    private SimpleHelpMap helpMap;
    @Shadow(remap=false)
    @Final
    protected DedicatedServer console;
    @Shadow(remap=false)
    @Final
    @Mutable
    private String serverName;
    @Shadow(remap=false)
    @Final
    @Mutable
    protected DedicatedPlayerList playerList;
    @Shadow(remap=false)
    @Final
    private Map<String, World> worlds;

    @Shadow(remap=false)
    protected abstract void enablePlugin(Plugin var1);

    @Shadow(remap=false)
    protected abstract void loadCustomPermissions();

    @Accessor(value="logger", remap=false)
    @Mutable
    public abstract void setLogger(Logger var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void arclight$setBrand(DedicatedServer console, PlayerList playerList, CallbackInfo ci) {
        this.serverName = "Arclight";
    }

    @Overwrite(remap=false)
    public String getName() {
        return "Arclight";
    }

    @Overwrite(remap=false)
    public ConsoleReader getReader() {
        try {
            return new ConsoleReader();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void bridge$setPlayerList(PlayerList playerList) {
        this.playerList = (DedicatedPlayerList)playerList;
    }

    @Inject(method={"unloadWorld(Lorg/bukkit/World;Z)Z"}, require=1, at={@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;getChunkProvider()Lnet/minecraft/world/server/ServerChunkProvider;")})
    private void arclight$unloadForge(World world, boolean save, CallbackInfoReturnable<Boolean> cir) {
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((IWorld)((CraftWorld)world).getHandle()));
        this.console.markWorldsDirty();
    }

    @ModifyVariable(method={"dispatchCommand"}, remap=false, index=2, at=@At(value="INVOKE", shift=At.Shift.AFTER, target="Lorg/spigotmc/AsyncCatcher;catchOp(Ljava/lang/String;)V"))
    private String arclight$forgeCommandEvent(String commandLine, CommandSender sender) {
        ParseResults parse;
        CommandEvent event;
        CommandSource commandSource;
        if (sender instanceof CraftEntity) {
            commandSource = ((CraftEntity)sender).getHandle().func_195051_bN();
        } else if (sender == Bukkit.getConsoleSender()) {
            commandSource = ArclightServer.getMinecraftServer().func_195573_aM();
        } else if (sender instanceof CraftBlockCommandSender) {
            commandSource = ((CraftBlockCommandSender)sender).getWrapper();
        } else {
            return commandLine;
        }
        StringReader stringreader = new StringReader("/" + commandLine);
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new CommandEvent(parse = ArclightServer.getMinecraftServer().func_195571_aL().func_197054_a().parse(stringreader, (Object)commandSource))))) {
            return null;
        }
        if (event.getException() != null) {
            return null;
        }
        String s2 = event.getParseResults().getReader().getString();
        return s2.startsWith("/") ? s2.substring(1) : s2;
    }

    @Inject(method={"dispatchCommand"}, remap=false, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lorg/spigotmc/AsyncCatcher;catchOp(Ljava/lang/String;)V")})
    private void arclight$returnIfFail(CommandSender sender, String commandLine, CallbackInfoReturnable<Boolean> cir) {
        if (commandLine == null) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public void bridge$removeWorld(ServerWorld world) {
        if (world == null) {
            return;
        }
        this.worlds.remove(((WorldBridge)world).bridge$getWorld().getName().toLowerCase(Locale.ROOT));
    }
}

