/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.block;

import io.izzel.arclight.common.bridge.entity.EntityBridge;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.event.block.CauldronLevelChangeEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CauldronBlock.class})
public class CauldronBlockMixin {
    @Inject(method={"onEntityCollision"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;extinguish()V")})
    public void arclight$extinguish(BlockState state, World worldIn, BlockPos pos, Entity entityIn, CallbackInfo ci) {
        int i = (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a);
        if (!this.changeLevel(worldIn, pos, state, i - 1, entityIn, CauldronLevelChangeEvent.ChangeReason.EXTINGUISH)) {
            ci.cancel();
        }
    }

    @Inject(method={"onBlockActivated"}, cancellable=true, at={@At(value="FIELD", target="Lnet/minecraft/entity/player/PlayerEntity;abilities:Lnet/minecraft/entity/player/PlayerAbilities;")})
    public void arclight$levelChange(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit, CallbackInfoReturnable<ActionResultType> cir) {
        int newLevel;
        CauldronLevelChangeEvent.ChangeReason reason;
        ItemStack itemStack = player.func_184586_b(handIn);
        Item item = itemStack.func_77973_b();
        int i = (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a);
        if (item == Items.field_151131_as) {
            reason = CauldronLevelChangeEvent.ChangeReason.BUCKET_EMPTY;
            newLevel = 3;
        } else if (item == Items.field_151133_ar) {
            reason = CauldronLevelChangeEvent.ChangeReason.BUCKET_FILL;
            newLevel = 0;
        } else if (item == Items.field_151069_bo) {
            reason = CauldronLevelChangeEvent.ChangeReason.BOTTLE_FILL;
            newLevel = i - 1;
        } else if (item == Items.field_151068_bn && PotionUtils.func_185191_c((ItemStack)itemStack) == Potions.field_185230_b) {
            reason = CauldronLevelChangeEvent.ChangeReason.BOTTLE_EMPTY;
            newLevel = i + 1;
        } else {
            reason = null;
            newLevel = 0;
        }
        if (reason != null && !this.changeLevel(worldIn, pos, state, newLevel, (Entity)player, reason)) {
            cir.setReturnValue((Object)ActionResultType.SUCCESS);
        }
    }

    @Inject(method={"onBlockActivated"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/item/IDyeableArmorItem;removeColor(Lnet/minecraft/item/ItemStack;)V")})
    public void arclight$removeColor(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit, CallbackInfoReturnable<ActionResultType> cir) {
        int i = (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a);
        if (!this.changeLevel(worldIn, pos, state, i - 1, (Entity)player, CauldronLevelChangeEvent.ChangeReason.ARMOR_WASH)) {
            cir.setReturnValue((Object)ActionResultType.SUCCESS);
        }
    }

    @Inject(method={"onBlockActivated"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/tileentity/BannerTileEntity;removeBannerData(Lnet/minecraft/item/ItemStack;)V")})
    public void arclight$removeBanner(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit, CallbackInfoReturnable<ActionResultType> cir) {
        int i = (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a);
        if (!this.changeLevel(worldIn, pos, state, i - 1, (Entity)player, CauldronLevelChangeEvent.ChangeReason.BANNER_WASH)) {
            cir.setReturnValue((Object)ActionResultType.SUCCESS);
        }
    }

    @Inject(method={"fillWithRain"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;I)Z")})
    public void arclight$fillRain(World worldIn, BlockPos pos, CallbackInfo ci) {
        BlockState cycle;
        int newLevel;
        BlockState state = worldIn.func_180495_p(pos);
        if (!this.changeLevel(worldIn, pos, state, newLevel = ((Integer)(cycle = (BlockState)state.func_235896_a_((Property)CauldronBlock.field_176591_a)).func_177229_b((Property)CauldronBlock.field_176591_a)).intValue(), null, CauldronLevelChangeEvent.ChangeReason.UNKNOWN)) {
            ci.cancel();
        }
    }

    private boolean changeLevel(World world, BlockPos pos, BlockState state, int i, Entity entity, CauldronLevelChangeEvent.ChangeReason reason) {
        int newLevel = MathHelper.func_76125_a((int)i, (int)0, (int)3);
        CauldronLevelChangeEvent event = new CauldronLevelChangeEvent(CraftBlock.at((IWorld)world, pos), entity == null ? null : ((EntityBridge)entity).bridge$getBukkitEntity(), reason, (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a), newLevel);
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }
}

