/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.block;

import io.izzel.arclight.common.bridge.block.FireBlockBridge;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FireBlock.class})
public abstract class FireBlockMixin
implements FireBlockBridge {
    @Shadow
    @Final
    private Object2IntMap<Block> field_149848_b;

    @Shadow
    protected abstract BlockState func_196448_a(IBlockReader var1, BlockPos var2);

    @Redirect(method={"tick"}, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/world/server/ServerWorld;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;I)Z"))
    public boolean arclight$fireSpread(ServerWorld world, BlockPos mutablePos, BlockState newState, int flags, BlockState state, ServerWorld worldIn, BlockPos pos) {
        if (world.func_180495_p(mutablePos).func_177230_c() != Blocks.field_150480_ab && !CraftEventFactory.callBlockIgniteEvent((World)world, mutablePos, pos).isCancelled()) {
            return CraftEventFactory.handleBlockSpreadEvent((World)world, pos, mutablePos, newState, flags);
        }
        return false;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;removeBlock(Lnet/minecraft/util/math/BlockPos;Z)Z"))
    public boolean arclight$extinguish1(ServerWorld world, BlockPos pos, boolean isMoving) {
        if (!CraftEventFactory.callBlockFadeEvent((IWorld)world, pos, Blocks.field_150350_a.func_176223_P()).isCancelled()) {
            world.func_217377_a(pos, isMoving);
        }
        return false;
    }

    @Inject(method={"tryCatchFire"}, cancellable=true, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;")})
    public void arclight$blockBurn(World worldIn, BlockPos pos, int chance, Random random, int age, Direction face, CallbackInfo ci) {
        CraftBlock theBlock = CraftBlock.at((IWorld)worldIn, pos);
        CraftBlock sourceBlock = CraftBlock.at((IWorld)worldIn, pos.func_177972_a(face));
        BlockBurnEvent event = new BlockBurnEvent(theBlock, sourceBlock);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    @Redirect(method={"updatePostPlacement"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;getDefaultState()Lnet/minecraft/block/BlockState;"))
    public BlockState arclight$blockFade(Block block, BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!(worldIn instanceof World)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        CraftBlockState blockState = CraftBlockState.getBlockState(worldIn, currentPos);
        blockState.setData(Blocks.field_150350_a.func_176223_P());
        BlockFadeEvent event = new BlockFadeEvent(blockState.getBlock(), blockState);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return (BlockState)this.func_196448_a((IBlockReader)worldIn, currentPos).func_206870_a((Property)FireBlock.field_176543_a, stateIn.func_177229_b((Property)FireBlock.field_176543_a));
        }
        return blockState.getHandle();
    }

    @Override
    public boolean bridge$canBurn(Block block) {
        return this.field_149848_b.containsKey((Object)block);
    }
}

