/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.entity.passive;

import io.izzel.arclight.common.bridge.entity.passive.AnimalEntityBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.mixin.core.entity.AgeableEntityMixin;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnimalEntity.class})
public abstract class AnimalEntityMixin
extends AgeableEntityMixin
implements AnimalEntityBridge {
    @Shadow
    public int field_70881_d;
    public ItemStack breedItem;
    private transient int arclight$loveTime;

    @Shadow
    public ActionResultType func_230254_b_(PlayerEntity playerIn, Hand hand) {
        return null;
    }

    @Shadow
    public abstract void func_70875_t();

    @Shadow
    @Nullable
    public abstract ServerPlayerEntity func_191993_do();

    @Override
    @Overwrite
    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    @Inject(method={"setInLove(Lnet/minecraft/entity/player/PlayerEntity;)V"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$enterLove(PlayerEntity player, CallbackInfo ci) {
        EntityEnterLoveModeEvent event = CraftEventFactory.callEntityEnterLoveModeEvent(player, (AnimalEntity)this, 600);
        if (event.isCancelled()) {
            ci.cancel();
        } else {
            this.arclight$loveTime = event.getTicksInLove();
        }
    }

    @Inject(method={"setInLove(Lnet/minecraft/entity/player/PlayerEntity;)V"}, at={@At(value="FIELD", shift=At.Shift.AFTER, target="Lnet/minecraft/entity/passive/AnimalEntity;inLove:I")})
    private void arclight$inLove(PlayerEntity player, CallbackInfo ci) {
        this.field_70881_d = this.arclight$loveTime;
        if (player != null) {
            this.breedItem = player.field_71071_by.func_70448_g();
        }
    }

    @Override
    public ItemStack bridge$getBreedItem() {
        return this.breedItem;
    }

    @Overwrite
    public void func_234177_a_(ServerWorld world, AnimalEntity animalEntity) {
        AgeableEntity child = this.func_241840_a(world, (AgeableEntity)animalEntity);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((MobEntity)((AnimalEntity)this), (MobEntity)animalEntity, child);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        child = event.getChild();
        if (cancelled) {
            this.func_70873_a(6000);
            animalEntity.func_70873_a(6000);
            this.func_70875_t();
            animalEntity.func_70875_t();
            return;
        }
        if (child != null) {
            int experience;
            EntityBreedEvent entityBreedEvent;
            ServerPlayerEntity serverplayerentity;
            if (child instanceof TameableEntity && ((TameableEntity)child).func_70909_n()) {
                child.field_82179_bU = true;
            }
            if ((serverplayerentity = this.func_191993_do()) == null && animalEntity.func_191993_do() != null) {
                serverplayerentity = animalEntity.func_191993_do();
            }
            if ((entityBreedEvent = CraftEventFactory.callEntityBreedEvent((LivingEntity)child, (LivingEntity)((AnimalEntity)this), (LivingEntity)animalEntity, (LivingEntity)serverplayerentity, this.breedItem, experience = this.func_70681_au().nextInt(7) + 1)).isCancelled()) {
                return;
            }
            experience = entityBreedEvent.getExperience();
            if (serverplayerentity != null) {
                serverplayerentity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, (AnimalEntity)this, animalEntity, child);
            }
            this.func_70873_a(6000);
            animalEntity.func_70873_a(6000);
            this.func_70875_t();
            animalEntity.func_70875_t();
            child.func_82227_f(true);
            child.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
            ((WorldBridge)world).bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason.BREEDING);
            world.func_242417_l((Entity)child);
            world.func_72960_a((Entity)((AnimalEntity)this), (byte)18);
            if (world.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), experience));
            }
        }
    }
}

