/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.entity.player;

import com.mojang.datafixers.util.Either;
import io.izzel.arclight.common.bridge.block.PortalInfoBridge;
import io.izzel.arclight.common.bridge.entity.EntityBridge;
import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.inventory.container.ContainerBridge;
import io.izzel.arclight.common.bridge.network.play.ServerPlayNetHandlerBridge;
import io.izzel.arclight.common.bridge.util.FoodStatsBridge;
import io.izzel.arclight.common.bridge.world.TeleporterBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.mixin.core.entity.player.PlayerEntityMixin;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import io.izzel.arclight.common.mod.util.ChestBlockDoubleInventoryHacks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.PortalInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.player.SpawnLocationHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.HorseInventoryContainer;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SCombatPacket;
import net.minecraft.network.play.server.SOpenHorseWindowPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SRespawnPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.network.play.server.SUpdateHealthPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.state.Property;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.FoodStats;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.DimensionType;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerPlayerEntity.class})
public abstract class ServerPlayerEntityMixin
extends PlayerEntityMixin
implements ServerPlayerEntityBridge {
    @Shadow
    @Final
    public MinecraftServer field_71133_b;
    @Shadow
    @Final
    public PlayerInteractionManager field_71134_c;
    @Shadow
    public ServerPlayNetHandler field_71135_a;
    @Shadow
    public boolean field_184851_cj;
    @Shadow
    public boolean field_71136_j;
    @Shadow
    private boolean field_192040_cp;
    @Shadow
    @Nullable
    private Vector3d field_193110_cw;
    @Shadow
    public int field_71144_ck;
    @Shadow
    private float field_71149_ch;
    @Shadow
    private int field_71146_ci;
    @Shadow
    public int field_71139_cq;
    @Shadow(remap=false)
    private String language;
    @Shadow
    private RegistryKey<World> field_241137_cq_;
    @Shadow
    @Final
    private static Logger field_147102_bM;
    public String displayName;
    public ITextComponent listName;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public Integer clientViewDistance;
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;
    public String locale = "en_us";
    private boolean arclight$initialized = false;
    private transient PlayerTeleportEvent.TeleportCause arclight$cause;

    @Shadow
    protected abstract int func_205735_q(int var1);

    @Shadow
    public abstract boolean func_175149_v();

    @Shadow
    public abstract void func_175145_a(Stat<?> var1);

    @Shadow
    public abstract void func_71053_j();

    @Shadow
    public abstract void func_175399_e(Entity var1);

    @Shadow
    public abstract ServerWorld func_71121_q();

    @Shadow
    public abstract void func_213846_b(ServerWorld var1);

    @Shadow
    public abstract void func_71117_bO();

    @Shadow
    public abstract void func_200619_a(ServerWorld var1, double var2, double var4, double var6, float var8, float var9);

    @Shadow
    public abstract void func_195068_e(int var1);

    @Shadow
    @Nullable
    public abstract BlockPos func_241140_K_();

    @Shadow
    public abstract float func_242109_L();

    @Shadow
    protected abstract void func_241157_eT_();

    @Shadow
    protected abstract void func_242110_a(ServerWorld var1, BlockPos var2);

    @Shadow
    public abstract boolean func_184812_l_();

    @Shadow
    public abstract void func_242111_a(RegistryKey<World> var1, @org.jetbrains.annotations.Nullable BlockPos var2, float var3, boolean var4, boolean var5);

    @Shadow
    protected abstract boolean func_241156_b_(BlockPos var1, Direction var2);

    @Shadow
    protected abstract boolean func_241147_a_(BlockPos var1, Direction var2);

    @Shadow
    public abstract void func_145747_a(ITextComponent var1, UUID var2);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void arclight$init(CallbackInfo ci) {
        this.displayName = this.func_146103_bH() != null ? this.func_195047_I_() : "~FakePlayer~";
        this.canPickUpLoot = true;
        this.maxHealthCache = this.func_110138_aP();
        this.arclight$initialized = true;
    }

    @Override
    public boolean bridge$initialized() {
        return this.arclight$initialized;
    }

    public final BlockPos getSpawnPoint(ServerWorld worldserver) {
        BlockPos blockposition = worldserver.func_241135_u_();
        if (worldserver.func_230315_m_().func_218272_d() && worldserver.field_241103_E_.func_76077_q() != GameType.ADVENTURE) {
            long k;
            long l;
            int i = Math.max(0, this.field_71133_b.func_184108_a(worldserver));
            int j = MathHelper.func_76128_c((double)worldserver.func_175723_af().func_177729_b((double)blockposition.func_177958_n(), (double)blockposition.func_177952_p()));
            if (j < i) {
                i = j;
            }
            if (j <= 1) {
                i = 1;
            }
            int i1 = (l = (k = (long)(i * 2 + 1)) * k) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
            int j1 = this.func_205735_q(i1);
            int k1 = new Random().nextInt(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i2 = (k1 + j1 * l1) % i1;
                int j2 = i2 % (i * 2 + 1);
                int k2 = i2 / (i * 2 + 1);
                BlockPos blockposition1 = SpawnLocationHelper.func_241092_a_((ServerWorld)worldserver, (int)(blockposition.func_177958_n() + j2 - i), (int)(blockposition.func_177952_p() + k2 - i), (boolean)false);
                if (blockposition1 == null) continue;
                return blockposition1;
            }
        }
        return blockposition;
    }

    @Override
    public BlockPos bridge$getSpawnPoint(ServerWorld world) {
        return this.getSpawnPoint(world);
    }

    @Inject(method={"readAdditional"}, at={@At(value="RETURN")})
    private void arclight$readExtra(CompoundNBT compound, CallbackInfo ci) {
        this.getBukkitEntity().readExtraData(compound);
        String spawnWorld = compound.func_74779_i("SpawnWorld");
        CraftWorld oldWorld = (CraftWorld)Bukkit.getWorld(spawnWorld);
        if (oldWorld != null) {
            this.field_241137_cq_ = oldWorld.getHandle().func_234923_W_();
        }
    }

    @Redirect(method={"writeAdditional"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isOnePlayerRiding()Z"))
    private boolean arclight$nonPersistVehicle(Entity entity) {
        Entity entity1 = this.func_184187_bx();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (Entity vehicle = entity1; vehicle != null; vehicle = vehicle.func_184187_bx()) {
                if (((EntityBridge)vehicle).bridge$isPersist()) continue;
                persistVehicle = false;
                break;
            }
        }
        return persistVehicle && entity.func_200601_bK();
    }

    @Inject(method={"writeAdditional"}, at={@At(value="RETURN")})
    private void arclight$writeExtra(CompoundNBT compound, CallbackInfo ci) {
        this.getBukkitEntity().setExtraData(compound);
    }

    @Override
    public void func_70029_a(World world) {
        super.func_70029_a(world);
        if (world == null) {
            this.revive();
            Vector3d position = null;
            if (this.field_241137_cq_ != null && (world = ServerLifecycleHooks.getCurrentServer().func_71218_a(this.field_241137_cq_)) != null && this.func_241140_K_() != null) {
                position = PlayerEntity.func_242374_a((ServerWorld)((ServerWorld)world), (BlockPos)this.func_241140_K_(), (float)this.func_242109_L(), (boolean)false, (boolean)false).orElse(null);
            }
            if (world == null || position == null) {
                world = ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle();
                position = Vector3d.func_237489_a_((Vector3i)((ServerWorld)world).func_241135_u_());
            }
            this.field_70170_p = world;
            this.func_70107_b(position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
        }
        this.field_71134_c.func_73080_a((ServerWorld)world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void arclight$joining(CallbackInfo ci) {
        if (this.joining) {
            this.joining = false;
        }
    }

    @Redirect(method={"playerTick"}, at=@At(value="NEW", target="net/minecraft/network/play/server/SUpdateHealthPacket"))
    private SUpdateHealthPacket arclight$useScaledHealth(float healthIn, int foodLevelIn, float saturationLevelIn) {
        return new SUpdateHealthPacket(this.getBukkitEntity().getScaledHealth(), foodLevelIn, saturationLevelIn);
    }

    @Inject(method={"playerTick"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/player/ServerPlayerEntity;ticksExisted:I")})
    private void arclight$updateHealthAndExp(CallbackInfo ci) {
        if (this.maxHealthCache != (double)this.func_110138_aP()) {
            this.getBukkitEntity().updateScaledHealth();
        }
        if (this.oldLevel == -1) {
            this.oldLevel = this.field_71068_ca;
        }
        if (this.oldLevel != this.field_71068_ca) {
            CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.field_71068_ca);
            this.oldLevel = this.field_71068_ca;
        }
    }

    @Override
    @Overwrite
    public void func_70645_a(DamageSource damagesource) {
        String deathMessage;
        PlayerInventory copyInv;
        boolean keepInventory;
        if (ForgeHooks.onLivingDeath((LivingEntity)((ServerPlayerEntity)this), (DamageSource)damagesource)) {
            return;
        }
        boolean flag = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223609_l);
        if (this.field_70128_L) {
            return;
        }
        boolean bl = keepInventory = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) || this.func_175149_v();
        if (keepInventory) {
            copyInv = this.field_71071_by;
        } else {
            copyInv = new PlayerInventory((PlayerEntity)((ServerPlayerEntity)this));
            copyInv.func_70455_b(this.field_71071_by);
        }
        this.func_213345_d(damagesource);
        ITextComponent defaultMessage = this.func_110142_aN().func_151521_b();
        String deathmessage = defaultMessage.getString();
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        Collection<ItemEntity> drops = this.captureDrops(null);
        if (drops != null) {
            for (ItemEntity entity : drops) {
                CraftItemStack craftItemStack = CraftItemStack.asCraftMirror(entity.func_92059_d());
                loot.add(craftItemStack);
            }
        }
        if (!keepInventory) {
            this.field_71071_by.func_70455_b(copyInv);
        }
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent((ServerPlayerEntity)this, loot, deathmessage, keepInventory);
        if (this.field_71070_bA != this.field_71069_bz) {
            this.func_71053_j();
        }
        if ((deathMessage = event.getDeathMessage()) != null && deathMessage.length() > 0 && flag) {
            ITextComponent itextcomponent = deathMessage.equals(deathmessage) ? this.func_110142_aN().func_151521_b() : CraftChatMessage.fromStringOrNull(deathMessage);
            this.field_71135_a.func_211148_a((IPacket)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTITY_DIED, itextcomponent), p_212356_2_ -> {
                if (!p_212356_2_.isSuccess()) {
                    int i = 256;
                    String s2 = itextcomponent.func_212636_a(256);
                    TranslationTextComponent itextcomponent1 = new TranslationTextComponent("death.attack.message_too_long", new Object[]{new StringTextComponent(s2).func_240699_a_(TextFormatting.YELLOW)});
                    IFormattableTextComponent itextcomponent2 = new TranslationTextComponent("death.attack.even_more_magic", new Object[]{this.func_145748_c_()}).func_240700_a_(arg_0 -> ServerPlayerEntityMixin.lambda$null$0((ITextComponent)itextcomponent1, arg_0));
                    this.field_71135_a.func_147359_a((IPacket)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTITY_DIED, (ITextComponent)itextcomponent2));
                }
            });
            Team scoreboardteambase = this.func_96124_cp();
            if (scoreboardteambase != null && scoreboardteambase.func_178771_j() != Team.Visible.ALWAYS) {
                if (scoreboardteambase.func_178771_j() == Team.Visible.HIDE_FOR_OTHER_TEAMS) {
                    this.field_71133_b.func_184103_al().func_177453_a((PlayerEntity)((ServerPlayerEntity)this), itextcomponent);
                } else if (scoreboardteambase.func_178771_j() == Team.Visible.HIDE_FOR_OWN_TEAM) {
                    this.field_71133_b.func_184103_al().func_177452_b((PlayerEntity)((ServerPlayerEntity)this), itextcomponent);
                }
            } else {
                this.field_71133_b.func_184103_al().func_232641_a_(itextcomponent, ChatType.SYSTEM, Util.field_240973_b_);
            }
        } else {
            this.field_71135_a.func_147359_a((IPacket)new SCombatPacket(this.func_110142_aN(), SCombatPacket.Event.ENTITY_DIED));
        }
        this.func_192030_dh();
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_234895_F_)) {
            this.func_241157_eT_();
        }
        this.func_226294_cV_();
        if (!event.getKeepInventory()) {
            this.field_71071_by.func_174888_l();
        }
        this.func_175399_e((Entity)((ServerPlayerEntity)this));
        ((CraftScoreboardManager)Bukkit.getScoreboardManager()).getScoreboardScores(ScoreCriteria.field_96642_c, this.func_195047_I_(), Score::func_96648_a);
        LivingEntity entityliving = this.func_94060_bK();
        if (entityliving != null) {
            this.func_71029_a(Stats.field_199091_i.func_199076_b((Object)entityliving.func_200600_R()));
            entityliving.func_191956_a((Entity)((ServerPlayerEntity)this), this.field_70744_aE, damagesource);
            this.func_226298_f_(entityliving);
        }
        this.field_70170_p.func_72960_a((Entity)((ServerPlayerEntity)this), (byte)3);
        this.func_195066_a(Stats.field_188069_A);
        this.func_175145_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188098_h));
        this.func_175145_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n));
        this.func_70066_B();
        this.func_70052_a(0, false);
        this.func_110142_aN().func_94549_h();
    }

    @Redirect(method={"awardKillScore"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;forAllObjectives(Lnet/minecraft/scoreboard/ScoreCriteria;Ljava/lang/String;Ljava/util/function/Consumer;)V"))
    private void arclight$useCustomScoreboard(Scoreboard scoreboard, ScoreCriteria p_197893_1_, String p_197893_2_, Consumer<Score> p_197893_3_) {
        ((CraftServer)Bukkit.getServer()).getScoreboardManager().getScoreboardScores(p_197893_1_, p_197893_2_, p_197893_3_);
    }

    @Redirect(method={"handleTeamKill"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;forAllObjectives(Lnet/minecraft/scoreboard/ScoreCriteria;Ljava/lang/String;Ljava/util/function/Consumer;)V"))
    private void arclight$teamKill(Scoreboard scoreboard, ScoreCriteria p_197893_1_, String p_197893_2_, Consumer<Score> p_197893_3_) {
        ((CraftServer)Bukkit.getServer()).getScoreboardManager().getScoreboardScores(p_197893_1_, p_197893_2_, p_197893_3_);
    }

    @Inject(method={"canPlayersAttack"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$pvpMode(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)((WorldBridge)this.field_70170_p).bridge$isPvpMode());
    }

    @Override
    @Nullable
    @Overwrite
    protected PortalInfo func_241829_a(ServerWorld p_241829_1_) {
        PortalInfo portalinfo = super.func_241829_a(p_241829_1_);
        if (portalinfo != null && ((WorldBridge)this.field_70170_p).bridge$getTypeKey() == DimensionType.field_235999_c_ && ((WorldBridge)p_241829_1_).bridge$getTypeKey() == DimensionType.field_236001_e_) {
            Vector3d vector3d = portalinfo.field_222505_a.func_72441_c(0.0, -1.0, 0.0);
            PortalInfo newInfo = new PortalInfo(vector3d, Vector3d.field_186680_a, 90.0f, 0.0f);
            ((PortalInfoBridge)newInfo).bridge$setWorld(p_241829_1_);
            ((PortalInfoBridge)newInfo).bridge$setPortalEventInfo(((PortalInfoBridge)portalinfo).bridge$getPortalEventInfo());
            return newInfo;
        }
        return portalinfo;
    }

    @Override
    public Entity bridge$changeDimension(ServerWorld world, PlayerTeleportEvent.TeleportCause cause) {
        this.arclight$cause = cause;
        return this.func_241206_a_(world);
    }

    @Override
    @Overwrite(remap=false)
    @Nullable
    public Entity changeDimension(ServerWorld server, ITeleporter teleporter) {
        if (this.func_70608_bn()) {
            return (ServerPlayerEntity)this;
        }
        if (!ForgeHooks.onTravelToDimension((Entity)((ServerPlayerEntity)this), (RegistryKey)server.func_234923_W_())) {
            return null;
        }
        PlayerTeleportEvent.TeleportCause cause = this.arclight$cause == null ? PlayerTeleportEvent.TeleportCause.UNKNOWN : this.arclight$cause;
        this.arclight$cause = null;
        ServerWorld serverworld = this.func_71121_q();
        RegistryKey<DimensionType> registrykey = ((WorldBridge)serverworld).bridge$getTypeKey();
        if (registrykey == DimensionType.field_236001_e_ && ((WorldBridge)server).bridge$getTypeKey() == DimensionType.field_235999_c_ && teleporter.isVanilla()) {
            this.field_184851_cj = true;
            this.func_213319_R();
            this.func_71121_q().removePlayer((ServerPlayerEntity)this, true);
            if (!this.field_71136_j) {
                this.field_71136_j = true;
                this.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241768_e_, this.field_192040_cp ? 0.0f : 1.0f));
                this.field_192040_cp = true;
            }
            return (ServerPlayerEntity)this;
        }
        IWorldInfo iworldinfo = server.func_72912_H();
        this.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(server.func_230315_m_(), server.func_234923_W_(), BiomeManager.func_235200_a_((long)server.func_72905_C()), this.field_71134_c.func_73081_b(), this.field_71134_c.func_241815_c_(), server.func_234925_Z_(), server.func_241109_A_(), true));
        this.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(iworldinfo.func_176130_y(), iworldinfo.func_176123_z()));
        PlayerList playerlist = this.field_71133_b.func_184103_al();
        playerlist.func_187243_f((ServerPlayerEntity)this);
        serverworld.removeEntity((Entity)((ServerPlayerEntity)this), true);
        this.revive();
        PortalInfo portalinfo = teleporter.getPortalInfo((Entity)((ServerPlayerEntity)this), server, this::func_241829_a);
        ServerWorld[] exitWorld = new ServerWorld[]{server};
        if (portalinfo != null) {
            Entity e = teleporter.placeEntity((Entity)((ServerPlayerEntity)this), serverworld, exitWorld[0], this.field_70177_z, spawnPortal -> {
                serverworld.func_217381_Z().func_76320_a("moving");
                if (((PortalInfoBridge)portalinfo).bridge$getWorld() != null) {
                    exitWorld[0] = ((PortalInfoBridge)portalinfo).bridge$getWorld();
                }
                if (exitWorld[0] != null) {
                    if (registrykey == DimensionType.field_235999_c_ && ((WorldBridge)exitWorld[0]).bridge$getTypeKey() == DimensionType.field_236000_d_) {
                        this.field_193110_cw = this.func_213303_ch();
                    } else if (spawnPortal.booleanValue() && ((WorldBridge)exitWorld[0]).bridge$getTypeKey() == DimensionType.field_236001_e_ && (((PortalInfoBridge)portalinfo).bridge$getPortalEventInfo() == null || ((PortalInfoBridge)portalinfo).bridge$getPortalEventInfo().getCanCreatePortal())) {
                        this.func_242110_a(exitWorld[0], new BlockPos(portalinfo.field_222505_a));
                    }
                }
                Location enter = this.getBukkitEntity().getLocation();
                Location exit = exitWorld[0] == null ? null : new Location(((WorldBridge)exitWorld[0]).bridge$getWorld(), portalinfo.field_222505_a.field_72450_a, portalinfo.field_222505_a.field_72448_b, portalinfo.field_222505_a.field_72449_c, portalinfo.field_242960_c, portalinfo.field_242961_d);
                PlayerTeleportEvent tpEvent = new PlayerTeleportEvent(this.getBukkitEntity(), enter, exit, cause);
                Bukkit.getServer().getPluginManager().callEvent(tpEvent);
                if (tpEvent.isCancelled() || tpEvent.getTo() == null) {
                    return null;
                }
                exit = tpEvent.getTo();
                serverworld.func_217381_Z().func_76319_b();
                serverworld.func_217381_Z().func_76320_a("placing");
                this.field_184851_cj = true;
                ServerWorld newWorld = ((CraftWorld)exit.getWorld()).getHandle();
                if (newWorld != exitWorld[0]) {
                    exitWorld[0] = newWorld;
                    IWorldInfo newWorldInfo = exitWorld[0].func_72912_H();
                    this.field_71135_a.func_147359_a((IPacket)new SRespawnPacket(exitWorld[0].func_230315_m_(), exitWorld[0].func_234923_W_(), BiomeManager.func_235200_a_((long)exitWorld[0].func_72905_C()), this.field_71134_c.func_73081_b(), this.field_71134_c.func_241815_c_(), exitWorld[0].func_234925_Z_(), exitWorld[0].func_241109_A_(), true));
                    this.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(newWorldInfo.func_176130_y(), newWorldInfo.func_176123_z()));
                }
                this.func_70029_a((World)exitWorld[0]);
                exitWorld[0].func_217447_b((ServerPlayerEntity)this);
                ((ServerPlayNetHandlerBridge)this.field_71135_a).bridge$teleport(exit);
                this.field_71135_a.func_184342_d();
                serverworld.func_217381_Z().func_76319_b();
                this.func_213846_b(exitWorld[0]);
                return (ServerPlayerEntity)this;
            });
            if (e == null) {
                serverworld.func_217447_b((ServerPlayerEntity)this);
                return (ServerPlayerEntity)this;
            }
            if (e != this) {
                throw new IllegalArgumentException(String.format("Teleporter %s returned not the player entity but instead %s, expected PlayerEntity %s", teleporter, e, this));
            }
            this.field_71134_c.func_73080_a(exitWorld[0]);
            this.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(this.field_71075_bZ));
            playerlist.func_72354_b((ServerPlayerEntity)this, exitWorld[0]);
            playerlist.func_72385_f((ServerPlayerEntity)this);
            for (EffectInstance effectinstance : this.func_70651_bq()) {
                this.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(this.func_145782_y(), effectinstance));
            }
            if (teleporter.playTeleportSound((ServerPlayerEntity)this, serverworld, exitWorld[0])) {
                this.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(1032, BlockPos.field_177992_a, 0, false));
            }
            this.field_71144_ck = -1;
            this.field_71149_ch = -1.0f;
            this.field_71146_ci = -1;
            BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)((ServerPlayerEntity)this), (RegistryKey)serverworld.func_234923_W_(), (RegistryKey)exitWorld[0].func_234923_W_());
            PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), ((WorldBridge)serverworld).bridge$getWorld());
            Bukkit.getPluginManager().callEvent(changeEvent);
        }
        return (ServerPlayerEntity)this;
    }

    @Override
    protected CraftPortalEvent callPortalEvent(Entity entity, ServerWorld exitWorldServer, BlockPos exitPosition, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        Location exit = new Location(((WorldBridge)exitWorldServer).bridge$getWorld(), exitPosition.func_177958_n(), exitPosition.func_177956_o(), exitPosition.func_177952_p(), this.field_70177_z, this.field_70125_A);
        PlayerPortalEvent event = new PlayerPortalEvent(this.getBukkitEntity(), enter, exit, cause, 128, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    @Override
    protected Optional<TeleportationRepositioner.Result> findOrCreatePortal(ServerWorld worldserver, BlockPos blockposition, boolean flag, int searchRadius, boolean canCreatePortal, int createRadius) {
        Optional<TeleportationRepositioner.Result> optional = super.findOrCreatePortal(worldserver, blockposition, flag, searchRadius, canCreatePortal, createRadius);
        if (optional.isPresent() || !canCreatePortal) {
            return optional;
        }
        Direction.Axis enumdirection_enumaxis = this.field_70170_p.func_180495_p(this.field_242271_ac).func_235903_d_((Property)NetherPortalBlock.field_176550_a).orElse(Direction.Axis.X);
        Optional<TeleportationRepositioner.Result> optional1 = ((TeleporterBridge)worldserver.func_85176_s()).bridge$createPortal(blockposition, enumdirection_enumaxis, (Entity)((ServerPlayerEntity)this), createRadius);
        if (!optional1.isPresent()) {
            field_147102_bM.error("Unable to create a portal, likely target out of worldborder");
        }
        return optional1;
    }

    private Either<PlayerEntity.SleepResult, Unit> getBedResult(BlockPos blockposition, Direction enumdirection) {
        if (!this.func_70608_bn() && this.func_70089_S()) {
            if (!this.field_70170_p.func_230315_m_().func_236043_f_()) {
                return Either.left((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_HERE);
            }
            if (!this.func_241147_a_(blockposition, enumdirection)) {
                return Either.left((Object)PlayerEntity.SleepResult.TOO_FAR_AWAY);
            }
            if (this.func_241156_b_(blockposition, enumdirection)) {
                return Either.left((Object)PlayerEntity.SleepResult.OBSTRUCTED);
            }
            this.func_242111_a((RegistryKey<World>)this.field_70170_p.func_234923_W_(), blockposition, this.field_70177_z, false, true);
            if (this.field_70170_p.func_72935_r()) {
                return Either.left((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_NOW);
            }
            if (!this.func_184812_l_()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vector3d vec3d = Vector3d.func_237492_c_((Vector3i)blockposition);
                List list = this.field_70170_p.func_175647_a(MonsterEntity.class, new AxisAlignedBB(vec3d.func_82615_a() - 8.0, vec3d.func_82617_b() - 5.0, vec3d.func_82616_c() - 8.0, vec3d.func_82615_a() + 8.0, vec3d.func_82617_b() + 5.0, vec3d.func_82616_c() + 8.0), entitymonster -> entitymonster.func_230292_f_((PlayerEntity)((ServerPlayerEntity)this)));
                if (!list.isEmpty()) {
                    return Either.left((Object)PlayerEntity.SleepResult.NOT_SAFE);
                }
            }
            return Either.right((Object)Unit.INSTANCE);
        }
        return Either.left((Object)PlayerEntity.SleepResult.OTHER_PROBLEM);
    }

    @Redirect(method={"trySleep"}, at=@At(value="INVOKE", remap=false, target="Lcom/mojang/datafixers/util/Either;left(Ljava/lang/Object;)Lcom/mojang/datafixers/util/Either;"))
    private <L, R> Either<L, R> arclight$failSleep(L value, BlockPos pos) {
        Either either = Either.left(value);
        return this.arclight$fireBedEvent(either, pos);
    }

    @Redirect(method={"trySleep"}, at=@At(value="INVOKE", remap=false, target="Lcom/mojang/datafixers/util/Either;ifRight(Ljava/util/function/Consumer;)Lcom/mojang/datafixers/util/Either;"))
    private <L, R> Either<L, R> arclight$successSleep(Either<L, R> either, Consumer<? super R> consumer, BlockPos pos) {
        return this.arclight$fireBedEvent(either, pos).ifRight(consumer);
    }

    private <L, R> Either<L, R> arclight$fireBedEvent(Either<L, R> e, BlockPos pos) {
        Either either = e;
        if (either.left().orElse(null) == PlayerEntity.SleepResult.OTHER_PROBLEM) {
            return either;
        }
        if (this.arclight$forceSleep) {
            either = Either.right((Object)Unit.INSTANCE);
        }
        return CraftEventFactory.callPlayerBedEnterEvent((PlayerEntity)((ServerPlayerEntity)this), pos, (Either<PlayerEntity.SleepResult, Unit>)either);
    }

    @Inject(method={"stopSleepInBed"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$wakeupOutBed(boolean p_225652_1_, boolean p_225652_2_, CallbackInfo ci) {
        if (!this.func_70608_bn()) {
            ci.cancel();
        }
    }

    public int nextContainerCounter() {
        this.func_71117_bO();
        return this.field_71139_cq;
    }

    @Inject(method={"openContainer"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/inventory/container/INamedContainerProvider;createMenu(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/inventory/container/Container;")})
    private void arclight$invOpen(INamedContainerProvider itileinventory, CallbackInfoReturnable<OptionalInt> cir, Container container) {
        if (container != null) {
            ((ContainerBridge)container).bridge$setTitle(itileinventory.func_145748_c_());
            boolean cancelled = false;
            ArclightCaptures.captureContainerOwner((PlayerEntity)((ServerPlayerEntity)this));
            container = CraftEventFactory.callInventoryOpenEvent((ServerPlayerEntity)this, container, cancelled);
            ArclightCaptures.resetContainerOwner();
            if (container == null && !cancelled) {
                if (itileinventory instanceof IInventory) {
                    ((IInventory)itileinventory).func_174886_c((PlayerEntity)((ServerPlayerEntity)this));
                } else if (ChestBlockDoubleInventoryHacks.isInstance(itileinventory)) {
                    ChestBlockDoubleInventoryHacks.get(itileinventory).func_174886_c((PlayerEntity)((ServerPlayerEntity)this));
                }
                cir.setReturnValue((Object)OptionalInt.empty());
            }
        }
    }

    @Overwrite
    public void func_184826_a(AbstractHorseEntity entityhorseabstract, IInventory iinventory) {
        this.nextContainerCounter();
        HorseInventoryContainer container = new HorseInventoryContainer(this.field_71139_cq, this.field_71071_by, iinventory, entityhorseabstract);
        ((ContainerBridge)container).bridge$setTitle(entityhorseabstract.func_145748_c_());
        container = CraftEventFactory.callInventoryOpenEvent((ServerPlayerEntity)this, (Container)container);
        if (container == null) {
            iinventory.func_174886_c((PlayerEntity)((ServerPlayerEntity)this));
            return;
        }
        if (this.field_71070_bA != this.field_71069_bz) {
            this.func_71053_j();
        }
        this.field_71135_a.func_147359_a((IPacket)new SOpenHorseWindowPacket(this.field_71139_cq, iinventory.func_70302_i_(), entityhorseabstract.func_145782_y()));
        this.field_71070_bA = container;
        this.field_71070_bA.func_75132_a((IContainerListener)((ServerPlayerEntity)this));
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((PlayerEntity)((ServerPlayerEntity)this), this.field_71070_bA));
    }

    @Inject(method={"sendAllContents"}, at={@At(value="RETURN")})
    private void arclight$sendExtra(Container container, NonNullList<net.minecraft.item.ItemStack> itemsList, CallbackInfo ci) {
        ArclightCaptures.captureContainerOwner((PlayerEntity)((ServerPlayerEntity)this));
        if (EnumSet.of(InventoryType.CRAFTING, InventoryType.WORKBENCH).contains((Object)((ContainerBridge)container).bridge$getBukkitView().getType())) {
            this.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(container.field_75152_c, 0, container.func_75139_a(0).func_75211_c()));
        }
        ArclightCaptures.resetContainerOwner();
    }

    @Inject(method={"closeContainer"}, at={@At(value="HEAD")})
    private void arclight$invClose(CallbackInfo ci) {
        if (this.field_71070_bA != this.field_71069_bz) {
            CraftEventFactory.handleInventoryCloseEvent((PlayerEntity)((ServerPlayerEntity)this));
        }
    }

    @Redirect(method={"addStat"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;forAllObjectives(Lnet/minecraft/scoreboard/ScoreCriteria;Ljava/lang/String;Ljava/util/function/Consumer;)V"))
    private void arclight$addStats(Scoreboard scoreboard, ScoreCriteria p_197893_1_, String p_197893_2_, Consumer<Score> p_197893_3_) {
        ((CraftScoreboardManager)Bukkit.getScoreboardManager()).getScoreboardScores(p_197893_1_, p_197893_2_, p_197893_3_);
    }

    @Redirect(method={"takeStat"}, at=@At(value="INVOKE", target="Lnet/minecraft/scoreboard/Scoreboard;forAllObjectives(Lnet/minecraft/scoreboard/ScoreCriteria;Ljava/lang/String;Ljava/util/function/Consumer;)V"))
    private void arclight$takeStats(Scoreboard scoreboard, ScoreCriteria p_197893_1_, String p_197893_2_, Consumer<Score> p_197893_3_) {
        ((CraftScoreboardManager)Bukkit.getScoreboardManager()).getScoreboardScores(p_197893_1_, p_197893_2_, p_197893_3_);
    }

    @Inject(method={"setPlayerHealthUpdated"}, at={@At(value="HEAD")})
    private void arclight$setExpUpdate(CallbackInfo ci) {
        this.field_71144_ck = -1;
    }

    public void sendMessage(UUID uuid, ITextComponent[] components) {
        for (ITextComponent component : components) {
            this.func_145747_a(component, uuid == null ? Util.field_240973_b_ : uuid);
        }
    }

    @Override
    public void bridge$sendMessage(ITextComponent[] components, UUID uuid) {
        this.sendMessage(uuid, components);
    }

    @Override
    public void bridge$sendMessage(ITextComponent component, UUID uuid) {
        this.func_145747_a(component, uuid == null ? Util.field_240973_b_ : uuid);
    }

    @Inject(method={"setGameType"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$gameModeChange(GameType gameType, CallbackInfo ci) {
        if (gameType == this.field_71134_c.func_73081_b()) {
            ci.cancel();
            return;
        }
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this.getBukkitEntity(), GameMode.getByValue(gameType.func_77148_a()));
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"handleClientSettings"}, at={@At(value="HEAD")})
    private void arclight$settingChange(CClientSettingsPacket packetIn, CallbackInfo ci) {
        if (this.func_184591_cq() != packetIn.func_186991_f()) {
            PlayerChangedMainHandEvent event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), this.func_184591_cq() == HandSide.LEFT ? MainHand.LEFT : MainHand.RIGHT);
            Bukkit.getPluginManager().callEvent(event);
        }
        if (!this.language.equals(packetIn.func_149524_c())) {
            PlayerLocaleChangeEvent event2 = new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), packetIn.func_149524_c());
            Bukkit.getPluginManager().callEvent(event2);
        }
        this.locale = packetIn.func_149524_c();
        this.clientViewDistance = packetIn.field_149528_b;
    }

    @Inject(method={"setSpectatingEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;setPositionAndUpdate(DDD)V")})
    private void arclight$spectatorReason(Entity entityToSpectate, CallbackInfo ci) {
        this.bridge$pushChangeDimensionCause(PlayerTeleportEvent.TeleportCause.SPECTATE);
    }

    @Overwrite
    @Nullable
    public ITextComponent func_175396_E() {
        return this.listName;
    }

    @Inject(method={"teleport"}, cancellable=true, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/entity/player/ServerPlayerEntity;stopRiding()V")})
    private void arclight$handleBy(ServerWorld world, double x, double y, double z, float yaw, float pitch, CallbackInfo ci) {
        PlayerTeleportEvent.TeleportCause cause = this.arclight$cause == null ? PlayerTeleportEvent.TeleportCause.UNKNOWN : this.arclight$cause;
        this.arclight$cause = null;
        this.getBukkitEntity().teleport(new Location(((WorldBridge)world).bridge$getWorld(), x, y, z, yaw, pitch), cause);
        ci.cancel();
    }

    public void a(ServerWorld worldserver, double d0, double d1, double d2, float f, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.bridge$pushChangeDimensionCause(cause);
        this.func_200619_a(worldserver, d0, d1, d2, f, f1);
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)this.internal$getBukkitEntity();
    }

    @Override
    public CraftPlayer bridge$getBukkitEntity() {
        return (CraftPlayer)this.internal$getBukkitEntity();
    }

    @Override
    public void bridge$pushChangeDimensionCause(PlayerTeleportEvent.TeleportCause cause) {
        this.arclight$cause = cause;
    }

    @Override
    public Optional<PlayerTeleportEvent.TeleportCause> bridge$getTeleportCause() {
        try {
            Optional<PlayerTeleportEvent.TeleportCause> optional = Optional.ofNullable(this.arclight$cause);
            return optional;
        }
        finally {
            this.arclight$cause = null;
        }
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.field_70170_p.func_72820_D() + this.timeOffset;
        }
        return this.field_70170_p.func_72820_D() - this.field_70170_p.func_72820_D() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241766_c_, 0.0f));
        } else {
            this.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241765_b_, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241771_h_, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241771_h_, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241772_i_, newThunder));
            } else {
                this.field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241772_i_, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (this.pluginRainPosition += 0.01f) : (this.pluginRainPosition -= 0.01f);
        this.pluginRainPosition = MathHelper.func_76131_a((float)this.pluginRainPosition, (float)0.0f, (float)1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.field_70170_p.func_72912_H().func_76059_o() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    public String toString() {
        return super.toString() + "(" + this.func_195047_I_() + " at " + this.func_226277_ct_() + "," + this.func_226278_cu_() + "," + this.func_226281_cx_() + ")";
    }

    public void forceSetPositionRotation(double x, double y, double z, float yaw, float pitch) {
        this.func_70012_b(x, y, z, yaw, pitch);
        this.field_71135_a.func_184342_d();
    }

    @Override
    protected boolean func_70610_aX() {
        return super.func_70610_aX() || !this.getBukkitEntity().isOnline();
    }

    @Override
    public Scoreboard func_96123_co() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        boolean keepInventory = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c);
        if (this.keepLevel || keepInventory) {
            exp = this.field_71106_cc;
            this.newTotalExp = this.field_71067_cb;
            this.newLevel = this.field_71068_ca;
        }
        this.func_70606_j(this.func_110138_aP());
        this.field_190534_ay = 0;
        this.field_70143_R = 0.0f;
        this.field_71100_bB = new FoodStats();
        ((FoodStatsBridge)this.field_71100_bB).bridge$setEntityHuman((PlayerEntity)((ServerPlayerEntity)this));
        this.field_71068_ca = this.newLevel;
        this.field_71067_cb = this.newTotalExp;
        this.field_71106_cc = 0.0f;
        this.field_70725_aQ = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.field_70752_e = true;
        this.field_71070_bA = this.field_71069_bz;
        this.field_70717_bb = null;
        this.field_70755_b = null;
        this.field_94063_bt = new CombatTracker((LivingEntity)((ServerPlayerEntity)this));
        this.field_71144_ck = -1;
        if (this.keepLevel || keepInventory) {
            this.field_71106_cc = exp;
        } else {
            this.func_195068_e(this.newExp);
        }
        this.keepLevel = false;
    }

    @Override
    public boolean bridge$isMovementBlocked() {
        return this.func_70610_aX();
    }

    @Override
    public void bridge$setCompassTarget(Location location) {
        this.compassTarget = location;
    }

    @Override
    public boolean bridge$isJoining() {
        return this.joining;
    }

    @Override
    public void bridge$reset() {
        this.reset();
    }

    private static /* synthetic */ Style lambda$null$0(ITextComponent itextcomponent1, Style p_212357_1_) {
        return p_212357_1_.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)itextcomponent1));
    }
}

