/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.item;

import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.item.ItemStackBridge;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
extends CapabilityProvider<ItemStack>
implements ItemStackBridge {
    @Shadow
    @Deprecated
    private Item field_151002_e;
    @Shadow
    private int field_77994_a;
    @Shadow(remap=false)
    private CompoundNBT capNBT;
    @Mutable
    @Shadow(remap=false)
    @Final
    private IRegistryDelegate<Item> delegate;
    private static final Logger LOG = LogManager.getLogger((String)"Arclight");

    protected ItemStackMixin(Class<ItemStack> baseClass) {
        super(baseClass);
    }

    @Override
    public CompoundNBT bridge$getForgeCaps() {
        return this.serializeCaps();
    }

    @Override
    public void bridge$setForgeCaps(CompoundNBT caps) {
        this.capNBT = caps;
        if (caps != null) {
            this.deserializeCaps(caps);
        }
    }

    public void convertStack(int version) {
        if (0 < version && version < CraftMagicNumbers.INSTANCE.getDataVersion()) {
            LOG.warn("Legacy ItemStack being used, updates will not applied: {}", (Object)this);
        }
    }

    @Override
    public void bridge$convertStack(int version) {
        this.convertStack(version);
    }

    @ModifyVariable(method={"attemptDamageItem"}, index=1, name={"amount"}, at=@At(value="JUMP", opcode=157, ordinal=0))
    private int arclight$itemDamage(int i, int amount, Random rand, ServerPlayerEntity damager) {
        if (damager != null) {
            PlayerItemDamageEvent event = new PlayerItemDamageEvent(((ServerPlayerEntityBridge)damager).bridge$getBukkitEntity(), CraftItemStack.asCraftMirror((ItemStack)this), i);
            event.getPlayer().getServer().getPluginManager().callEvent(event);
            if (i != event.getDamage() || event.isCancelled()) {
                event.getPlayer().updateInventory();
            }
            if (event.isCancelled()) {
                return -1;
            }
            return event.getDamage();
        }
        return i;
    }

    @Inject(method={"damageItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;shrink(I)V")})
    private <T extends LivingEntity> void arclight$itemBreak(int amount, T entityIn, Consumer<T> onBroken, CallbackInfo ci) {
        if (this.field_77994_a == 1 && entityIn instanceof PlayerEntity) {
            CraftEventFactory.callPlayerItemBreakEvent((PlayerEntity)entityIn, (ItemStack)this);
        }
    }

    @Deprecated
    public void setItem(Item item) {
        this.field_151002_e = item;
        this.delegate = item.delegate;
    }
}

