/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.izzel.arclight.common.bridge.inventory.IInventoryBridge;
import io.izzel.arclight.common.bridge.item.crafting.RecipeManagerBridge;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RecipeManager.class})
public abstract class RecipeManagerMixin
implements RecipeManagerBridge {
    @Shadow
    public Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> field_199522_d;
    @Shadow
    private boolean field_199523_e;
    @Shadow
    @Final
    private static Logger field_199521_c;

    @Shadow
    protected abstract <C extends IInventory, T extends IRecipe<C>> Map<ResourceLocation, IRecipe<C>> func_215366_a(IRecipeType<T> var1);

    @Shadow
    public static IRecipe<?> func_215377_a(ResourceLocation recipeId, JsonObject json) {
        return null;
    }

    @Overwrite
    protected void func_212853_a_(Map<ResourceLocation, JsonElement> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        this.field_199523_e = false;
        HashMap<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> map = Maps.newHashMap();
        for (IRecipeType type : Registry.field_218367_H) {
            map.put((IRecipeType<?>)type, (Map<ResourceLocation, IRecipe<?>>)new Object2ObjectLinkedOpenHashMap());
        }
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            if (resourcelocation.func_110623_a().startsWith("_")) continue;
            try {
                if (entry.getValue().isJsonObject() && !CraftingHelper.processConditions((JsonObject)entry.getValue().getAsJsonObject(), (String)"conditions")) {
                    field_199521_c.info("Skipping loading recipe {} as it's conditions were not met", (Object)resourcelocation);
                    continue;
                }
                IRecipe<?> irecipe = RecipeManagerMixin.func_215377_a(resourcelocation, JSONUtils.func_151210_l((JsonElement)entry.getValue(), (String)"top element"));
                if (irecipe == null) {
                    field_199521_c.info("Skipping loading recipe {} as it's serializer returned null", (Object)resourcelocation);
                    continue;
                }
                map.computeIfAbsent(irecipe.func_222127_g(), recipeType -> new Object2ObjectLinkedOpenHashMap()).putAndMoveToFirst((Object)resourcelocation, irecipe);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                field_199521_c.error("Parsing error loading recipe {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        this.field_199522_d = map;
        field_199521_c.info("Loaded {} recipes", (Object)map.size());
    }

    @Overwrite
    public <C extends IInventory, T extends IRecipe<C>> Optional<T> func_215371_a(IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn) {
        Optional optional = this.func_215366_a(recipeTypeIn).values().stream().flatMap(recipe -> Util.func_215081_a((Optional)recipeTypeIn.func_222148_a(recipe, worldIn, inventoryIn))).findFirst();
        ((IInventoryBridge)inventoryIn).setCurrentRecipe(optional.orElse(null));
        return optional;
    }

    public void addRecipe(IRecipe<?> recipe) {
        Object2ObjectLinkedOpenHashMap map;
        Map<ResourceLocation, IRecipe<?>> original;
        if (this.field_199522_d instanceof ImmutableMap) {
            this.field_199522_d = new HashMap(this.field_199522_d);
        }
        if (!((original = this.field_199522_d.get(recipe.func_222127_g())) instanceof Object2ObjectLinkedOpenHashMap)) {
            Object2ObjectLinkedOpenHashMap hashMap = new Object2ObjectLinkedOpenHashMap();
            hashMap.putAll(original);
            this.field_199522_d.put((IRecipeType<?>)recipe.func_222127_g(), (Map<ResourceLocation, IRecipe<?>>)hashMap);
            map = hashMap;
        } else {
            map = (Object2ObjectLinkedOpenHashMap)original;
        }
        if (map.containsKey((Object)recipe.func_199560_c())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + recipe.func_199560_c());
        }
        map.putAndMoveToFirst((Object)recipe.func_199560_c(), recipe);
    }

    @Override
    public void bridge$addRecipe(IRecipe<?> recipe) {
        this.addRecipe(recipe);
    }

    public void clearRecipes() {
        this.field_199522_d = new HashMap();
        for (IRecipeType type : Registry.field_218367_H) {
            this.field_199522_d.put((IRecipeType<?>)type, (Map<ResourceLocation, IRecipe<?>>)new Object2ObjectLinkedOpenHashMap());
        }
    }

    @Override
    public void bridge$clearRecipes() {
        this.clearRecipes();
    }
}

