/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.loot;

import io.izzel.arclight.common.bridge.world.storage.loot.LootTableBridge;
import io.izzel.arclight.mixin.Eject;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.event.world.LootGenerateEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LootTable.class})
public abstract class LootTableMixin
implements LootTableBridge {
    @Shadow
    @Final
    private static Logger field_186465_b;

    @Shadow
    public abstract List<ItemStack> func_216113_a(LootContext var1);

    @Shadow
    protected abstract List<Integer> func_186459_a(IInventory var1, Random var2);

    @Shadow
    protected abstract void func_186463_a(List<ItemStack> var1, int var2, Random var3);

    @Eject(method={"fillInventory"}, at=@At(value="INVOKE", target="Lnet/minecraft/loot/LootTable;generate(Lnet/minecraft/loot/LootContext;)Ljava/util/List;"))
    private List<ItemStack> arclight$nonPluginEvent(LootTable lootTable, LootContext context, CallbackInfo ci, IInventory inv) {
        List list = lootTable.func_216113_a(context);
        if (!context.func_216033_a(LootParameters.field_237457_g_) && !context.func_216033_a(LootParameters.field_216281_a)) {
            return list;
        }
        LootGenerateEvent event = CraftEventFactory.callLootGenerateEvent(inv, (LootTable)this, context, list, false);
        if (event.isCancelled()) {
            ci.cancel();
            return null;
        }
        return event.getLoot().stream().map(CraftItemStack::asNMSCopy).collect(Collectors.toList());
    }

    public void fillInventory(IInventory inv, LootContext context, boolean plugin) {
        List<Object> list = this.func_216113_a(context);
        Random random = context.func_216032_b();
        LootGenerateEvent event = CraftEventFactory.callLootGenerateEvent(inv, (LootTable)this, context, list, plugin);
        if (event.isCancelled()) {
            return;
        }
        list = event.getLoot().stream().map(CraftItemStack::asNMSCopy).collect(Collectors.toList());
        List<Integer> list1 = this.func_186459_a(inv, random);
        this.func_186463_a(list, list1.size(), random);
        for (ItemStack itemStack : list) {
            if (list1.isEmpty()) {
                field_186465_b.warn("Tried to over-fill a container");
                return;
            }
            if (itemStack.func_190926_b()) {
                inv.func_70299_a(list1.remove(list1.size() - 1).intValue(), ItemStack.field_190927_a);
                continue;
            }
            inv.func_70299_a(list1.remove(list1.size() - 1).intValue(), itemStack);
        }
    }

    @Override
    public void bridge$fillInventory(IInventory inv, LootContext context, boolean plugin) {
        this.fillInventory(inv, context, plugin);
    }
}

