/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.network.login;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.izzel.arclight.common.bridge.network.NetworkManagerBridge;
import io.izzel.arclight.common.bridge.network.login.ServerLoginNetHandlerBridge;
import io.izzel.arclight.common.bridge.server.MinecraftServerBridge;
import io.izzel.arclight.common.bridge.server.management.PlayerListBridge;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.login.ServerLoginNetHandler;
import net.minecraft.network.login.client.CEncryptionResponsePacket;
import net.minecraft.network.login.client.CLoginStartPacket;
import net.minecraft.network.login.server.SDisconnectLoginPacket;
import net.minecraft.network.login.server.SEnableCompressionPacket;
import net.minecraft.network.login.server.SEncryptionRequestPacket;
import net.minecraft.network.login.server.SLoginSuccessPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.CryptException;
import net.minecraft.util.CryptManager;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.util.Waitable;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ServerLoginNetHandler.class})
public abstract class ServerLoginNetHandlerMixin
implements ServerLoginNetHandlerBridge {
    @Shadow
    private ServerLoginNetHandler.State field_147328_g;
    @Shadow
    @Final
    private MinecraftServer field_147327_f;
    @Shadow
    @Final
    private byte[] field_147330_e;
    @Shadow
    private SecretKey field_147335_k;
    @Shadow
    @Final
    public NetworkManager field_147333_a;
    @Shadow
    @Final
    private static AtomicInteger field_147331_b;
    @Shadow
    private GameProfile field_147337_i;
    @Shadow
    @Final
    private static Logger field_147332_c;
    @Shadow
    private ServerPlayerEntity field_181025_l;
    public String hostname;

    @Shadow
    protected abstract GameProfile func_152506_a(GameProfile var1);

    @Shadow
    public abstract void func_194026_b(ITextComponent var1);

    @Shadow
    public abstract String func_147317_d();

    @Override
    public String bridge$getHostname() {
        return this.hostname;
    }

    @Override
    public void bridge$setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void disconnect(String s2) {
        try {
            StringTextComponent ichatbasecomponent = new StringTextComponent(s2);
            field_147332_c.info("Disconnecting {}: {}", (Object)this.func_147317_d(), (Object)s2);
            this.field_147333_a.func_179290_a((IPacket)new SDisconnectLoginPacket((ITextComponent)ichatbasecomponent));
            this.field_147333_a.func_150718_a((ITextComponent)ichatbasecomponent);
        }
        catch (Exception exception) {
            field_147332_c.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    @Overwrite
    public void func_147326_c() {
        ServerPlayerEntity entity = ((PlayerListBridge)this.field_147327_f.func_184103_al()).bridge$canPlayerLogin(this.field_147333_a.func_74430_c(), this.field_147337_i, (ServerLoginNetHandler)this);
        if (entity != null) {
            this.field_147328_g = ServerLoginNetHandler.State.ACCEPTED;
            if (this.field_147327_f.func_175577_aI() >= 0 && !this.field_147333_a.func_150731_c()) {
                this.field_147333_a.func_201058_a((IPacket)new SEnableCompressionPacket(this.field_147327_f.func_175577_aI()), p_210149_1_ -> this.field_147333_a.func_179289_a(this.field_147327_f.func_175577_aI()));
            }
            this.field_147333_a.func_179290_a((IPacket)new SLoginSuccessPacket(this.field_147337_i));
            ServerPlayerEntity serverplayerentity = this.field_147327_f.func_184103_al().func_177451_a(this.field_147337_i.getId());
            if (serverplayerentity != null) {
                this.field_147328_g = ServerLoginNetHandler.State.DELAY_ACCEPT;
                this.field_181025_l = entity;
            } else {
                this.field_147327_f.func_184103_al().func_72355_a(this.field_147333_a, entity);
            }
        }
    }

    @Overwrite
    public void func_147316_a(CLoginStartPacket packetIn) {
        Validate.validState((this.field_147328_g == ServerLoginNetHandler.State.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        this.field_147337_i = packetIn.func_149304_c();
        if (this.field_147327_f.func_71266_T() && !this.field_147333_a.func_150731_c()) {
            this.field_147328_g = ServerLoginNetHandler.State.KEY;
            this.field_147333_a.func_179290_a((IPacket)new SEncryptionRequestPacket("", this.field_147327_f.func_71250_E().getPublic().getEncoded(), this.field_147330_e));
        } else {
            class Handler
            extends Thread {
                Handler() {
                    super((ThreadGroup)SidedThreadGroups.SERVER, "User Authenticator #" + field_147331_b.incrementAndGet());
                }

                @Override
                public void run() {
                    try {
                        ServerLoginNetHandlerMixin.this.initUUID();
                        ServerLoginNetHandlerMixin.this.arclight$preLogin();
                    }
                    catch (Exception ex) {
                        ServerLoginNetHandlerMixin.this.disconnect("Failed to verify username!");
                        field_147332_c.warn("Exception verifying {} ", (Object)ServerLoginNetHandlerMixin.this.field_147337_i.getName(), (Object)ex);
                    }
                }
            }
            new Handler().start();
        }
    }

    public void initUUID() {
        UUID uuid = ((NetworkManagerBridge)this.field_147333_a).bridge$getSpoofedUUID() != null ? ((NetworkManagerBridge)this.field_147333_a).bridge$getSpoofedUUID() : PlayerEntity.func_175147_b((String)this.field_147337_i.getName());
        this.field_147337_i = new GameProfile(uuid, this.field_147337_i.getName());
        if (((NetworkManagerBridge)this.field_147333_a).bridge$getSpoofedProfile() != null) {
            for (Property property : ((NetworkManagerBridge)this.field_147333_a).bridge$getSpoofedProfile()) {
                this.field_147337_i.getProperties().put((Object)property.getName(), (Object)property);
            }
        }
    }

    @Overwrite
    public void func_147315_a(CEncryptionResponsePacket packetIn) {
        String s2;
        Validate.validState((this.field_147328_g == ServerLoginNetHandler.State.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        PrivateKey privatekey = this.field_147327_f.func_71250_E().getPrivate();
        try {
            if (!Arrays.equals(this.field_147330_e, packetIn.func_149299_b(privatekey))) {
                throw new IllegalStateException("Protocol error");
            }
            this.field_147335_k = packetIn.func_149300_a(privatekey);
            Cipher cipher = CryptManager.func_151229_a((int)2, (Key)this.field_147335_k);
            Cipher cipher1 = CryptManager.func_151229_a((int)1, (Key)this.field_147335_k);
            s2 = new BigInteger(CryptManager.func_75895_a((String)"", (PublicKey)this.field_147327_f.func_71250_E().getPublic(), (SecretKey)this.field_147335_k)).toString(16);
            this.field_147328_g = ServerLoginNetHandler.State.AUTHENTICATING;
            this.field_147333_a.func_244777_a(cipher, cipher1);
        }
        catch (CryptException cryptexception) {
            throw new IllegalStateException("Protocol error", cryptexception);
        }
        class Handler
        extends Thread {
            Handler() {
                super((ThreadGroup)SidedThreadGroups.SERVER, "User Authenticator #" + field_147331_b.incrementAndGet());
            }

            @Override
            public void run() {
                GameProfile gameprofile = ServerLoginNetHandlerMixin.this.field_147337_i;
                try {
                    ServerLoginNetHandlerMixin.this.field_147337_i = ServerLoginNetHandlerMixin.this.field_147327_f.func_147130_as().hasJoinedServer(new GameProfile(null, gameprofile.getName()), s2, this.getAddress());
                    if (ServerLoginNetHandlerMixin.this.field_147337_i != null) {
                        if (!ServerLoginNetHandlerMixin.this.field_147333_a.func_150724_d()) {
                            return;
                        }
                        ServerLoginNetHandlerMixin.this.arclight$preLogin();
                    } else if (ServerLoginNetHandlerMixin.this.field_147327_f.func_71264_H()) {
                        field_147332_c.warn("Failed to verify username but will let them in anyway!");
                        ServerLoginNetHandlerMixin.this.field_147337_i = ServerLoginNetHandlerMixin.this.func_152506_a(gameprofile);
                        ServerLoginNetHandlerMixin.this.field_147328_g = ServerLoginNetHandler.State.NEGOTIATING;
                    } else {
                        ServerLoginNetHandlerMixin.this.func_194026_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.unverified_username"));
                        field_147332_c.error("Username '{}' tried to join with an invalid session", (Object)gameprofile.getName());
                    }
                }
                catch (Exception var3) {
                    if (ServerLoginNetHandlerMixin.this.field_147327_f.func_71264_H()) {
                        field_147332_c.warn("Authentication servers are down but will let them in anyway!");
                        ServerLoginNetHandlerMixin.this.field_147337_i = ServerLoginNetHandlerMixin.this.func_152506_a(gameprofile);
                        ServerLoginNetHandlerMixin.this.field_147328_g = ServerLoginNetHandler.State.NEGOTIATING;
                    }
                    ServerLoginNetHandlerMixin.this.func_194026_b((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.authservers_down"));
                    field_147332_c.error("Couldn't verify username because servers are unavailable");
                }
            }

            @Nullable
            private InetAddress getAddress() {
                SocketAddress socketaddress = ServerLoginNetHandlerMixin.this.field_147333_a.func_74430_c();
                return ServerLoginNetHandlerMixin.this.field_147327_f.func_190518_ac() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
            }
        }
        Handler thread = new Handler();
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_147332_c));
        thread.start();
    }

    private void arclight$preLogin() throws Exception {
        String playerName = this.field_147337_i.getName();
        InetAddress address = ((InetSocketAddress)this.field_147333_a.func_74430_c()).getAddress();
        UUID uniqueId = this.field_147337_i.getId();
        final CraftServer craftServer = (CraftServer)Bukkit.getServer();
        AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, uniqueId);
        craftServer.getPluginManager().callEvent(asyncEvent);
        if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
            final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
            if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                event.disallow(asyncEvent.getResult(), asyncEvent.getKickMessage());
            }
            class SyncPreLogin
            extends Waitable<PlayerPreLoginEvent.Result> {
                SyncPreLogin() {
                }

                @Override
                protected PlayerPreLoginEvent.Result evaluate() {
                    craftServer.getPluginManager().callEvent(event);
                    return event.getResult();
                }
            }
            SyncPreLogin waitable = new SyncPreLogin();
            ((MinecraftServerBridge)this.field_147327_f).bridge$queuedProcess(waitable);
            if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                this.disconnect(event.getKickMessage());
                return;
            }
        } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.disconnect(asyncEvent.getKickMessage());
            return;
        }
        field_147332_c.info("UUID of player {} is {}", (Object)this.field_147337_i.getName(), (Object)this.field_147337_i.getId());
        this.field_147328_g = ServerLoginNetHandler.State.NEGOTIATING;
    }
}

