/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.tileentity;

import io.izzel.arclight.common.mixin.core.tileentity.LockableTileEntityMixin;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.BrewingStandTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IWorld;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.BrewingStandFuelEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.InventoryHolder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BrewingStandTileEntity.class})
public abstract class BrewingStandTileEntityMixin
extends LockableTileEntityMixin {
    @Shadow
    private NonNullList<ItemStack> field_145945_j;
    @Shadow
    public int field_184278_m;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;
    private transient Integer arclight$fuel;
    private transient boolean arclight$consume;

    @Inject(method={"tick"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="FIELD", ordinal=1, target="Lnet/minecraft/tileentity/BrewingStandTileEntity;fuel:I")})
    public void arclight$brewFuel(CallbackInfo ci, ItemStack itemStack) {
        BrewingStandFuelEvent event = new BrewingStandFuelEvent(CraftBlock.at((IWorld)this.field_145850_b, this.field_174879_c), CraftItemStack.asCraftMirror(itemStack), 20);
        Bukkit.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            ci.cancel();
            this.arclight$fuel = null;
        } else {
            this.arclight$consume = event.isConsuming();
            this.arclight$fuel = event.getFuelPower();
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;shrink(I)V"))
    public void arclight$brewFuel(ItemStack itemStack, int count) {
        if (this.arclight$fuel != null) {
            this.field_184278_m = this.arclight$fuel;
            if (this.arclight$fuel > 0 && this.arclight$consume) {
                itemStack.func_190918_g(count);
            }
        }
        this.arclight$fuel = null;
        this.arclight$consume = false;
    }

    @Inject(method={"brewPotions"}, cancellable=true, at={@At(value="HEAD")})
    public void arclight$brewPotion(CallbackInfo ci) {
        InventoryHolder owner = this.getOwner();
        if (owner != null) {
            BrewEvent event = new BrewEvent(CraftBlock.at((IWorld)this.field_145850_b, this.field_174879_c), (BrewerInventory)owner.getInventory(), this.field_184278_m);
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Override
    public List<ItemStack> getContents() {
        return this.field_145945_j;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public void setOwner(InventoryHolder owner) {
    }

    public int func_70297_j_() {
        if (this.maxStack == 0) {
            this.maxStack = 64;
        }
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }
}

