/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import io.izzel.arclight.common.bridge.entity.EntityBridge;
import io.izzel.arclight.common.bridge.world.ExplosionBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Explosion.class})
public abstract class ExplosionMixin
implements ExplosionBridge {
    @Shadow
    @Final
    private World field_77287_j;
    @Shadow
    @Final
    private Explosion.Mode field_222260_b;
    @Shadow
    @Mutable
    @Final
    private float field_77280_f;
    @Shadow
    @Final
    private List<BlockPos> field_77281_g;
    @Shadow
    @Final
    private double field_77284_b;
    @Shadow
    @Final
    private double field_77285_c;
    @Shadow
    @Final
    private double field_77282_d;
    @Shadow
    @Final
    public Entity field_77283_e;
    @Shadow
    @Final
    private Map<PlayerEntity, Vector3d> field_77288_k;
    @Shadow
    @Final
    private boolean field_77286_a;
    @Shadow
    @Final
    private Random field_77290_i;
    @Shadow
    @Final
    private ExplosionContext field_234893_k_;
    public boolean wasCanceled = false;

    @Shadow
    public abstract DamageSource func_199591_b();

    @Override
    @Accessor(value="exploder")
    public abstract Entity bridge$getExploder();

    @Override
    @Accessor(value="size")
    public abstract float bridge$getSize();

    @Override
    @Accessor(value="size")
    public abstract void bridge$setSize(float var1);

    @Override
    @Accessor(value="mode")
    public abstract Explosion.Mode bridge$getMode();

    @Shadow
    private static void func_229976_a_(ObjectArrayList<Pair<ItemStack, BlockPos>> dropPositionArray, ItemStack stack, BlockPos pos) {
    }

    @Inject(method={"<init>(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;DDDFZLnet/minecraft/world/Explosion$Mode;)V"}, at={@At(value="RETURN")})
    public void arclight$adjustSize(World worldIn, Entity exploderIn, double xIn, double yIn, double zIn, float sizeIn, boolean causesFireIn, Explosion.Mode modeIn, CallbackInfo ci) {
        this.field_77280_f = Math.max(sizeIn, 0.0f);
    }

    @Overwrite
    public void func_77278_a() {
        if (this.field_77280_f < 0.1f) {
            return;
        }
        HashSet<BlockPos> set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.field_77284_b;
                    double d6 = this.field_77285_c;
                    double d8 = this.field_77282_d;
                    float f1 = 0.3f;
                    for (float f = this.field_77280_f * (0.7f + this.field_77287_j.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        FluidState fluidstate;
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        BlockState blockstate = this.field_77287_j.func_180495_p(blockpos);
                        Optional optional = this.field_234893_k_.func_230312_a_((Explosion)this, (IBlockReader)this.field_77287_j, blockpos, blockstate, fluidstate = this.field_77287_j.func_204610_c(blockpos));
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.field_234893_k_.func_230311_a_((Explosion)this, (IBlockReader)this.field_77287_j, blockpos, blockstate, f)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.field_77281_g.addAll(set);
        float f3 = this.field_77280_f * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.field_77284_b - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.field_77284_b + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.field_77285_c - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.field_77285_c + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.field_77282_d - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.field_77282_d + (double)f3 + 1.0));
        List list = this.field_77287_j.func_72839_b(this.field_77283_e, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.field_77287_j, (Explosion)((Explosion)this), (List)list, (double)f3);
        Vector3d vec3d = new Vector3d(this.field_77284_b, this.field_77285_c, this.field_77282_d);
        for (Entity entity : list) {
            PlayerEntity playerentity;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            if (entity.func_180427_aV() || !((d12 = (double)(MathHelper.func_76133_a((double)entity.func_195048_a(vec3d)) / f3)) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.func_226277_ct_() - this.field_77284_b) * d5 + (d7 = entity.func_226280_cw_() - this.field_77285_c) * d7 + (d9 = entity.func_226281_cx_() - this.field_77282_d) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = Explosion.func_222259_a((Vector3d)vec3d, (Entity)entity);
            double d10 = (1.0 - d12) * d14;
            CraftEventFactory.entityDamage = this.field_77283_e;
            ((EntityBridge)entity).bridge$setForceExplosionKnockback(false);
            boolean wasDamaged = entity.func_70097_a(this.func_199591_b(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)));
            CraftEventFactory.entityDamage = null;
            if (!wasDamaged && !(entity instanceof TNTEntity) && !(entity instanceof FallingBlockEntity) && !((EntityBridge)entity).bridge$isForceExplosionKnockback()) continue;
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof PlayerEntity) || (playerentity = (PlayerEntity)entity).func_175149_v() || playerentity.func_184812_l_() && playerentity.field_71075_bZ.field_75100_b) continue;
            this.field_77288_k.put(playerentity, new Vector3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    @Override
    public boolean bridge$wasCancelled() {
        return this.wasCanceled;
    }

    @Overwrite
    public void func_77279_a(boolean spawnParticles) {
        boolean flag;
        if (this.field_77287_j.field_72995_K) {
            this.field_77287_j.func_184134_a(this.field_77284_b, this.field_77285_c, this.field_77282_d, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_77287_j.field_73012_v.nextFloat() - this.field_77287_j.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean bl = flag = this.field_222260_b != Explosion.Mode.NONE;
        if (spawnParticles) {
            if (!(this.field_77280_f < 2.0f) && flag) {
                this.field_77287_j.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0);
            } else {
                this.field_77287_j.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Collections.shuffle(this.field_77281_g, this.field_77287_j.field_73012_v);
            float yield = this.callBlockExplodeEvent();
            if (Float.isNaN(yield)) {
                this.wasCanceled = true;
                return;
            }
            for (BlockPos blockpos : this.field_77281_g) {
                BlockState blockstate = this.field_77287_j.func_180495_p(blockpos);
                net.minecraft.block.Block block = blockstate.func_177230_c();
                if (blockstate.isAir((IBlockReader)this.field_77287_j, blockpos)) continue;
                BlockPos blockpos1 = blockpos.func_185334_h();
                this.field_77287_j.func_217381_Z().func_76320_a("explosion_blocks");
                if (blockstate.canDropFromExplosion((IBlockReader)this.field_77287_j, blockpos, (Explosion)this) && this.field_77287_j instanceof ServerWorld) {
                    TileEntity tileentity = blockstate.hasTileEntity() ? this.field_77287_j.func_175625_s(blockpos) : null;
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_77287_j).func_216023_a(this.field_77287_j.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)blockpos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileentity).func_216021_b(LootParameters.field_216281_a, (Object)this.field_77283_e);
                    if (this.field_222260_b == Explosion.Mode.DESTROY || yield < 1.0f) {
                        lootcontext$builder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(1.0f / yield));
                    }
                    blockstate.func_215693_a(lootcontext$builder).forEach(stack -> ExplosionMixin.func_229976_a_((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, stack, blockpos1));
                }
                blockstate.onBlockExploded(this.field_77287_j, blockpos, (Explosion)this);
                this.field_77287_j.func_217381_Z().func_76319_b();
            }
            for (Pair pair : objectarraylist) {
                net.minecraft.block.Block.func_180635_a((World)this.field_77287_j, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (this.field_77286_a) {
            for (BlockPos blockpos2 : this.field_77281_g) {
                BlockIgniteEvent event;
                if (this.field_77290_i.nextInt(3) != 0 || !this.field_77287_j.func_180495_p(blockpos2).func_196958_f() || !this.field_77287_j.func_180495_p(blockpos2.func_177977_b()).func_200015_d((IBlockReader)this.field_77287_j, blockpos2.func_177977_b()) || (event = CraftEventFactory.callBlockIgniteEvent(this.field_77287_j, blockpos2.func_177958_n(), blockpos2.func_177956_o(), blockpos2.func_177952_p(), (Explosion)this)).isCancelled()) continue;
                this.field_77287_j.func_175656_a(blockpos2, AbstractFireBlock.func_235326_a_((IBlockReader)this.field_77287_j, (BlockPos)blockpos2));
            }
        }
    }

    @Inject(method={"handleExplosionDrops"}, cancellable=true, at={@At(value="HEAD")})
    private static void arclight$fix(ObjectArrayList<Pair<ItemStack, BlockPos>> dropPositionArray, ItemStack stack, BlockPos pos, CallbackInfo ci) {
        if (stack.func_190926_b()) {
            ci.cancel();
        }
    }

    private float callBlockExplodeEvent() {
        float yield;
        List<Block> bukkitBlocks;
        boolean cancelled;
        Event event;
        CraftWorld world = ((WorldBridge)this.field_77287_j).bridge$getWorld();
        CraftEntity exploder = this.field_77283_e == null ? null : ((EntityBridge)this.field_77283_e).bridge$getBukkitEntity();
        Location location = new Location(world, this.field_77284_b, this.field_77285_c, this.field_77282_d);
        ArrayList<Block> blockList = Lists.newArrayList();
        for (int i = this.field_77281_g.size() - 1; i >= 0; --i) {
            BlockPos blockPos = this.field_77281_g.get(i);
            Block block = world.getBlockAt(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            if (block.getType().isAir()) continue;
            blockList.add(block);
        }
        if (exploder != null) {
            event = new EntityExplodeEvent(exploder, location, blockList, this.field_222260_b == Explosion.Mode.DESTROY ? 1.0f / this.field_77280_f : 1.0f);
            Bukkit.getPluginManager().callEvent(event);
            cancelled = ((EntityExplodeEvent)event).isCancelled();
            bukkitBlocks = ((EntityExplodeEvent)event).blockList();
            yield = ((EntityExplodeEvent)event).getYield();
        } else {
            event = new BlockExplodeEvent(location.getBlock(), blockList, this.field_222260_b == Explosion.Mode.DESTROY ? 1.0f / this.field_77280_f : 1.0f);
            Bukkit.getPluginManager().callEvent(event);
            cancelled = ((BlockExplodeEvent)event).isCancelled();
            bukkitBlocks = ((BlockExplodeEvent)event).blockList();
            yield = ((BlockExplodeEvent)event).getYield();
        }
        this.field_77281_g.clear();
        for (Block block : bukkitBlocks) {
            BlockPos blockPos = new BlockPos(block.getX(), block.getY(), block.getZ());
            this.field_77281_g.add(blockPos);
        }
        return cancelled ? Float.NaN : yield;
    }
}

