/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world;

import io.izzel.arclight.common.bridge.entity.EntityBridge;
import io.izzel.arclight.common.bridge.world.TeleporterBridge;
import io.izzel.arclight.common.bridge.world.WorldBridge;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.util.BlockStateListPopulator;
import org.bukkit.event.world.PortalCreateEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Teleporter.class})
public abstract class TeleporterMixin
implements TeleporterBridge {
    @Shadow
    @Final
    protected ServerWorld field_85192_a;
    private transient int arclight$searchRadius = -1;
    private transient BlockStateListPopulator arclight$populator;
    private transient Entity arclight$entity;
    private transient int arclight$createRadius = -1;

    @Shadow
    public abstract Optional<TeleportationRepositioner.Result> func_242956_a(BlockPos var1, Direction.Axis var2);

    @Shadow
    public abstract Optional<TeleportationRepositioner.Result> func_242957_a(BlockPos var1, boolean var2);

    @ModifyVariable(method={"getExistingPortal"}, index=4, at=@At(value="INVOKE", target="Lnet/minecraft/village/PointOfInterestManager;ensureLoadedAndValid(Lnet/minecraft/world/IWorldReader;Lnet/minecraft/util/math/BlockPos;I)V"))
    private int arclight$useSearchRadius(int i) {
        return this.arclight$searchRadius == -1 ? i : this.arclight$searchRadius;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TeleportationRepositioner.Result> findPortal(BlockPos pos, int searchRadius) {
        this.arclight$searchRadius = searchRadius;
        try {
            Optional<TeleportationRepositioner.Result> optional = this.func_242957_a(pos, false);
            return optional;
        }
        finally {
            this.arclight$searchRadius = -1;
        }
    }

    @Override
    public Optional<TeleportationRepositioner.Result> bridge$findPortal(BlockPos pos, int searchRadius) {
        return this.findPortal(pos, searchRadius);
    }

    @ModifyArg(method={"makePortal"}, index=1, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/BlockPos;func_243514_a(Lnet/minecraft/util/math/BlockPos;ILnet/minecraft/util/Direction;Lnet/minecraft/util/Direction;)Ljava/lang/Iterable;"))
    private int arclight$changeRadius(int i) {
        return this.arclight$createRadius == -1 ? i : this.arclight$createRadius;
    }

    @Redirect(method={"makePortal"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)Z"))
    private boolean arclight$captureBlocks1(ServerWorld serverWorld, BlockPos pos, BlockState state) {
        if (this.arclight$populator == null) {
            this.arclight$populator = new BlockStateListPopulator((World)serverWorld);
        }
        return this.arclight$populator.func_180501_a(pos, state, 3);
    }

    @Redirect(method={"makePortal"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;I)Z"))
    private boolean arclight$captureBlocks2(ServerWorld serverWorld, BlockPos pos, BlockState state, int flags) {
        if (this.arclight$populator == null) {
            this.arclight$populator = new BlockStateListPopulator((World)serverWorld);
        }
        return this.arclight$populator.func_180501_a(pos, state, flags);
    }

    @Inject(method={"makePortal"}, cancellable=true, at={@At(value="RETURN")})
    private void arclight$portalCreate(BlockPos pos, Direction.Axis axis, CallbackInfoReturnable<Optional<TeleportationRepositioner.Result>> cir) {
        CraftWorld craftWorld = ((WorldBridge)this.field_85192_a).bridge$getWorld();
        List<Object> blockStates = this.arclight$populator == null ? new ArrayList() : this.arclight$populator.getList();
        PortalCreateEvent event = new PortalCreateEvent(blockStates, craftWorld, this.arclight$entity == null ? null : ((EntityBridge)this.arclight$entity).bridge$getBukkitEntity(), PortalCreateEvent.CreateReason.NETHER_PAIR);
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            cir.setReturnValue(Optional.empty());
            return;
        }
        if (this.arclight$populator != null) {
            this.arclight$populator.updateList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TeleportationRepositioner.Result> createPortal(BlockPos pos, Direction.Axis axis, Entity entity, int createRadius) {
        this.arclight$entity = entity;
        this.arclight$createRadius = createRadius;
        try {
            Optional<TeleportationRepositioner.Result> optional = this.func_242956_a(pos, axis);
            return optional;
        }
        finally {
            this.arclight$entity = null;
            this.arclight$createRadius = -1;
        }
    }

    @Override
    public Optional<TeleportationRepositioner.Result> bridge$createPortal(BlockPos pos, Direction.Axis axis, Entity entity, int createRadius) {
        return this.createPortal(pos, axis, entity, createRadius);
    }
}

