/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world;

import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.bridge.world.border.WorldBorderBridge;
import io.izzel.arclight.common.bridge.world.server.ServerChunkProviderBridge;
import io.izzel.arclight.common.mod.ArclightMod;
import io.izzel.arclight.common.mod.server.ArclightServer;
import io.izzel.arclight.common.mod.server.world.WrappedWorlds;
import io.izzel.arclight.common.mod.util.ArclightCaptures;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.ISpawnWorldInfo;
import net.minecraft.world.storage.IWorldInfo;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.generator.CustomChunkGenerator;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.generator.ChunkGenerator;
import org.spigotmc.SpigotWorldConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={World.class})
public abstract class WorldMixin
implements WorldBridge,
IWorldWriter {
    @Shadow
    @Final
    private WorldBorder field_175728_M;
    @Shadow
    @Final
    private DimensionType field_234921_x_;
    private RegistryKey<DimensionType> typeKey;
    protected CraftWorld world;
    public boolean pvpMode;
    public boolean keepSpawnInMemory = true;
    public long ticksPerAnimalSpawns;
    public long ticksPerMonsterSpawns;
    public long ticksPerWaterSpawns;
    public long ticksPerWaterAmbientSpawns;
    public long ticksPerAmbientSpawns;
    public boolean populating;
    public ChunkGenerator generator;
    protected World.Environment environment;
    public SpigotWorldConfig spigotConfig;
    private static BlockPos lastPhysicsProblem;

    @Shadow
    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return null;
    }

    @Shadow
    public abstract BlockState func_180495_p(BlockPos var1);

    @Shadow
    public abstract void func_175690_a(BlockPos var1, @Nullable TileEntity var2);

    @Shadow
    public abstract WorldBorder func_175723_af();

    @Shadow
    public abstract long func_72820_D();

    @Shadow
    public abstract MinecraftServer shadow$func_73046_m();

    @Shadow
    public abstract IWorldInfo func_72912_H();

    @Shadow
    public abstract RegistryKey<World> func_234923_W_();

    @Accessor(value="mainThread")
    public abstract Thread arclight$getMainThread();

    public void arclight$constructor(ISpawnWorldInfo worldInfo, RegistryKey<World> dimension, DimensionType dimensionType, Supplier<IProfiler> profiler, boolean isRemote, boolean isDebug, long seed) {
        throw new RuntimeException();
    }

    public void arclight$constructor(ISpawnWorldInfo worldInfo, RegistryKey<World> dimension, DimensionType dimensionType, Supplier<IProfiler> profiler, boolean isRemote, boolean isDebug, long seed, ChunkGenerator gen, World.Environment env) {
        this.arclight$constructor(worldInfo, dimension, dimensionType, profiler, isRemote, isDebug, seed);
        this.generator = gen;
        this.environment = env;
        this.bridge$getWorld();
    }

    @Inject(method={"<init>(Lnet/minecraft/world/storage/ISpawnWorldInfo;Lnet/minecraft/util/RegistryKey;Lnet/minecraft/world/DimensionType;Ljava/util/function/Supplier;ZZJ)V"}, at={@At(value="RETURN")})
    private void arclight$init(ISpawnWorldInfo info, RegistryKey<World> dimension, DimensionType dimType, Supplier<IProfiler> profiler, boolean isRemote, boolean isDebug, long seed, CallbackInfo ci) {
        this.spigotConfig = new SpigotWorldConfig(((IServerWorldInfo)info).func_76065_j());
        ((WorldBorderBridge)this.field_175728_M).bridge$setWorld((World)this);
        this.ticksPerAnimalSpawns = this.getServer().getTicksPerAnimalSpawns();
        this.ticksPerMonsterSpawns = this.getServer().getTicksPerMonsterSpawns();
        this.ticksPerWaterSpawns = this.getServer().getTicksPerWaterSpawns();
        this.ticksPerWaterAmbientSpawns = this.getServer().getTicksPerWaterAmbientSpawns();
        this.ticksPerAmbientSpawns = this.getServer().getTicksPerAmbientSpawns();
        this.typeKey = this.getServer().getHandle().func_72365_p().func_244267_aX().func_230520_a_().func_230519_c_((Object)this.field_234921_x_).orElseGet(() -> {
            Registry registry = this.getServer().getHandle().func_72365_p().func_244267_aX().func_230520_a_();
            RegistryKey typeRegistryKey = RegistryKey.func_240903_a_((RegistryKey)registry.func_243578_f(), (ResourceLocation)dimension.func_240901_a_());
            ArclightMod.LOGGER.warn("Assign {} to unknown dimension type {} as {}", (Object)typeRegistryKey, (Object)dimType);
            return typeRegistryKey;
        });
    }

    @Override
    public long bridge$ticksPerAnimalSpawns() {
        return this.ticksPerAnimalSpawns;
    }

    @Override
    public long bridge$ticksPerMonsterSpawns() {
        return this.ticksPerMonsterSpawns;
    }

    @Override
    public long bridge$ticksPerWaterSpawns() {
        return this.ticksPerWaterSpawns;
    }

    @Override
    public long bridge$ticksPerAmbientSpawns() {
        return this.ticksPerAmbientSpawns;
    }

    @Override
    public long bridge$ticksPerWaterAmbientSpawns() {
        return this.ticksPerWaterAmbientSpawns;
    }

    public RegistryKey<DimensionType> getTypeKey() {
        return this.typeKey;
    }

    @Override
    public RegistryKey<DimensionType> bridge$getTypeKey() {
        return this.getTypeKey();
    }

    @Override
    public SpigotWorldConfig bridge$spigotConfig() {
        return this.spigotConfig;
    }

    @Inject(method={"setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;I)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void arclight$hooks(BlockPos pos, BlockState newState, int flags, CallbackInfoReturnable<Boolean> cir) {
        if (!this.processCaptures(pos, newState, flags)) {
            cir.setReturnValue((Object)false);
        }
    }

    private boolean processCaptures(BlockPos pos, BlockState newState, int flags) {
        Entity entityChangeBlock = ArclightCaptures.getEntityChangeBlock();
        return entityChangeBlock == null || !CraftEventFactory.callEntityChangeBlockEvent(entityChangeBlock, pos, newState).isCancelled();
    }

    @Inject(method={"markAndNotifyBlock"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;updateNeighbours(Lnet/minecraft/world/IWorld;Lnet/minecraft/util/math/BlockPos;II)V")})
    private void arclight$callBlockPhysics(BlockPos pos, Chunk chunk, BlockState blockstate, BlockState state, int flags, int recursionLeft, CallbackInfo ci) {
        try {
            if (this.world != null) {
                BlockPhysicsEvent event = new BlockPhysicsEvent(CraftBlock.at((IWorld)this, pos), CraftBlockData.fromData(state));
                Bukkit.getPluginManager().callEvent(event);
                if (event.isCancelled()) {
                    ci.cancel();
                }
            }
        }
        catch (StackOverflowError e) {
            lastPhysicsProblem = pos;
        }
    }

    @Inject(method={"neighborChanged"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;neighborChanged(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/Block;Lnet/minecraft/util/math/BlockPos;Z)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void arclight$callBlockPhysics2(BlockPos pos, Block blockIn, BlockPos fromPos, CallbackInfo ci, BlockState blockState) {
        try {
            if (this.world != null) {
                IWorld iWorld = (IWorld)this;
                BlockPhysicsEvent event = new BlockPhysicsEvent(CraftBlock.at(iWorld, pos), CraftBlockData.fromData(blockState), CraftBlock.at(iWorld, fromPos));
                Bukkit.getPluginManager().callEvent(event);
                if (event.isCancelled()) {
                    ci.cancel();
                }
            }
        }
        catch (StackOverflowError e) {
            lastPhysicsProblem = pos;
        }
    }

    public CraftServer getServer() {
        return (CraftServer)Bukkit.getServer();
    }

    public CraftWorld getWorld() {
        if (this.world == null) {
            Optional<Field> delegate = WrappedWorlds.getDelegate(this.getClass());
            if (delegate.isPresent()) {
                try {
                    return ((WorldBridge)delegate.get().get(this)).bridge$getWorld();
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.generator == null) {
                this.generator = this.getServer().getGenerator(((IServerWorldInfo)this.func_72912_H()).func_76065_j());
                if (this.generator != null && this instanceof ServerWorld) {
                    ServerWorld serverWorld = (ServerWorld)this;
                    CustomChunkGenerator gen = new CustomChunkGenerator(serverWorld, serverWorld.func_72863_F().func_201711_g(), this.generator);
                    ((ServerChunkProviderBridge)serverWorld.func_72863_F()).bridge$setChunkGenerator(gen);
                }
            }
            if (this.environment == null) {
                this.environment = ArclightServer.getEnvironment(this.typeKey);
            }
            this.world = new CraftWorld((ServerWorld)this, this.generator, this.environment);
            this.getServer().addWorld(this.world);
        }
        return this.world;
    }

    public TileEntity getTileEntity(BlockPos pos, boolean validate) {
        return this.func_175625_s(pos);
    }

    @Override
    public TileEntity bridge$getTileEntity(BlockPos pos, boolean validate) {
        return this.getTileEntity(pos, validate);
    }

    @Override
    public CraftServer bridge$getServer() {
        return (CraftServer)Bukkit.getServer();
    }

    @Override
    public CraftWorld bridge$getWorld() {
        return this.getWorld();
    }

    @Override
    public boolean bridge$isPvpMode() {
        return this.pvpMode;
    }

    @Override
    public boolean bridge$isKeepSpawnInMemory() {
        return this.keepSpawnInMemory;
    }

    @Override
    public boolean bridge$isPopulating() {
        return this.populating;
    }

    @Override
    public void bridge$setPopulating(boolean populating) {
        this.populating = populating;
    }

    @Override
    public ChunkGenerator bridge$getGenerator() {
        return this.generator;
    }

    @Override
    public ServerWorld bridge$getMinecraftWorld() {
        return this.getWorld().getHandle();
    }

    @Override
    public boolean bridge$addEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (this.getWorld().getHandle() != this) {
            return ((WorldBridge)this.getWorld().getHandle()).bridge$addEntity(entity, reason);
        }
        this.bridge$pushAddEntityReason(reason);
        return this.func_217376_c(entity);
    }

    @Override
    public void bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason reason) {
        if (this.getWorld().getHandle() != this) {
            ((WorldBridge)this.getWorld().getHandle()).bridge$pushAddEntityReason(reason);
        }
    }

    @Override
    public CreatureSpawnEvent.SpawnReason bridge$getAddEntityReason() {
        if (this.getWorld().getHandle() != this) {
            return ((WorldBridge)this.getWorld().getHandle()).bridge$getAddEntityReason();
        }
        return null;
    }
}

