/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.chunk;

import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.bridge.world.chunk.ChunkBridge;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.world.ITickList;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.server.ServerWorld;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.craftbukkit.v1_16_R3.CraftChunk;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_16_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.generator.BlockPopulator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Chunk.class})
public abstract class ChunkMixin
implements ChunkBridge {
    @Shadow
    @Final
    public World field_76637_e;
    @Shadow
    @Final
    private ChunkPos field_212816_F;
    @Shadow
    private volatile boolean field_76643_l;
    @Shadow
    private boolean field_76644_m;
    @Shadow
    private long field_76641_n;
    @Shadow
    @Final
    public ClassInheritanceMultiMap<Entity>[] field_76645_j;
    public org.bukkit.Chunk bukkitChunk;
    public boolean mustNotSave;
    public boolean needsDecoration;
    private transient boolean arclight$doPlace;
    public ServerWorld $$world;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);

    @Shadow
    @Nullable
    public abstract BlockState func_177436_a(BlockPos var1, BlockState var2, boolean var3);

    @Inject(method={"<init>(Lnet/minecraft/world/World;Lnet/minecraft/util/math/ChunkPos;Lnet/minecraft/world/biome/BiomeContainer;Lnet/minecraft/util/palette/UpgradeData;Lnet/minecraft/world/ITickList;Lnet/minecraft/world/ITickList;J[Lnet/minecraft/world/chunk/ChunkSection;Ljava/util/function/Consumer;)V"}, at={@At(value="RETURN")})
    private void arclight$init(World worldIn, ChunkPos chunkPosIn, BiomeContainer biomeContainerIn, UpgradeData upgradeDataIn, ITickList<Block> tickBlocksIn, ITickList<Fluid> tickFluidsIn, long inhabitedTimeIn, ChunkSection[] sectionsIn, Consumer<Chunk> postLoadConsumerIn, CallbackInfo ci) {
        this.$$world = (ServerWorld)worldIn;
        this.bridge$setBukkitChunk(new CraftChunk((Chunk)this));
    }

    public List<Entity>[] getEntitySlices() {
        return (List[])Arrays.stream(this.field_76645_j).map(ClassInheritanceMultiMap::func_241289_a_).toArray(List[]::new);
    }

    public org.bukkit.Chunk getBukkitChunk() {
        return this.bukkitChunk;
    }

    @Override
    public org.bukkit.Chunk bridge$getBukkitChunk() {
        return this.bukkitChunk;
    }

    @Override
    public CraftPersistentDataContainer bridge$getPersistentContainer() {
        return this.persistentDataContainer;
    }

    @Override
    public void bridge$setBukkitChunk(org.bukkit.Chunk chunk) {
        this.bukkitChunk = chunk;
    }

    public BlockState setType(BlockPos pos, BlockState state, boolean isMoving, boolean doPlace) {
        return this.bridge$setType(pos, state, isMoving, doPlace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockState bridge$setType(BlockPos pos, BlockState state, boolean isMoving, boolean doPlace) {
        this.arclight$doPlace = doPlace;
        try {
            BlockState blockState = this.func_177436_a(pos, state, isMoving);
            return blockState;
        }
        finally {
            this.arclight$doPlace = true;
        }
    }

    @Override
    public boolean bridge$isMustNotSave() {
        return this.mustNotSave;
    }

    @Override
    public void bridge$setMustNotSave(boolean mustNotSave) {
        this.mustNotSave = mustNotSave;
    }

    @Override
    public boolean bridge$isNeedsDecoration() {
        return this.needsDecoration;
    }

    @Override
    public void bridge$loadCallback() {
        this.loadCallback();
    }

    @Override
    public void bridge$unloadCallback() {
        this.unloadCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCallback() {
        Server server = Bukkit.getServer();
        if (server != null) {
            server.getPluginManager().callEvent(new ChunkLoadEvent(this.bukkitChunk, this.needsDecoration));
            if (this.needsDecoration) {
                this.needsDecoration = false;
                Random random = new Random();
                random.setSeed(((ServerWorld)this.field_76637_e).func_72905_C());
                long xRand = random.nextLong() / 2L * 2L + 1L;
                long zRand = random.nextLong() / 2L * 2L + 1L;
                random.setSeed((long)this.field_212816_F.field_77276_a * xRand + (long)this.field_212816_F.field_77275_b * zRand ^ ((ServerWorld)this.field_76637_e).func_72905_C());
                CraftWorld world = ((WorldBridge)this.field_76637_e).bridge$getWorld();
                if (world != null) {
                    ((WorldBridge)this.field_76637_e).bridge$setPopulating(true);
                    try {
                        for (BlockPopulator populator : world.getPopulators()) {
                            populator.populate(world, random, this.bukkitChunk);
                        }
                    }
                    finally {
                        ((WorldBridge)this.field_76637_e).bridge$setPopulating(false);
                    }
                }
                server.getPluginManager().callEvent(new ChunkPopulateEvent(this.bukkitChunk));
            }
        }
    }

    public void unloadCallback() {
        Server server = Bukkit.getServer();
        ChunkUnloadEvent unloadEvent = new ChunkUnloadEvent(this.bukkitChunk, this.func_201593_f());
        server.getPluginManager().callEvent(unloadEvent);
        this.mustNotSave = !unloadEvent.isSaveChunk();
    }

    @Inject(method={"<init>(Lnet/minecraft/world/World;Lnet/minecraft/world/chunk/ChunkPrimer;)V"}, at={@At(value="RETURN")})
    public void arclight$setNeedsDecoration(World worldIn, ChunkPrimer primer, CallbackInfo ci) {
        this.needsDecoration = true;
    }

    @Redirect(method={"setBlockState"}, at=@At(value="FIELD", ordinal=1, target="Lnet/minecraft/world/World;isRemote:Z"))
    public boolean arclight$redirectIsRemote(World world) {
        return world.field_72995_K && this.arclight$doPlace;
    }

    @Overwrite
    public boolean func_201593_f() {
        return !this.mustNotSave && (this.field_76643_l || this.field_76644_m && this.field_76637_e.func_82737_E() != this.field_76641_n);
    }
}

