/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.server;

import io.izzel.arclight.common.bridge.world.WorldBridge;
import io.izzel.arclight.common.bridge.world.server.ChunkHolderBridge;
import io.izzel.arclight.common.bridge.world.server.ChunkManagerBridge;
import io.izzel.arclight.common.bridge.world.server.ServerChunkProviderBridge;
import io.izzel.arclight.common.bridge.world.server.TicketManagerBridge;
import java.io.IOException;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;
import net.minecraft.world.server.TicketManager;
import net.minecraft.world.storage.IWorldInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ServerChunkProvider.class})
public abstract class ServerChunkProviderMixin
implements ServerChunkProviderBridge {
    @Shadow
    @Final
    private ServerWorldLightManager field_217242_h;
    @Shadow
    @Final
    public ChunkManager field_217237_a;
    @Shadow
    @Final
    public ServerWorld field_73251_h;
    @Shadow
    @Final
    private TicketManager field_217240_d;
    @Shadow
    public boolean field_217246_l;
    @Shadow
    public boolean field_217247_m;
    @Shadow
    @Final
    @Mutable
    public ChunkGenerator field_186029_c;

    @Shadow
    public abstract void func_217210_a(boolean var1);

    @Shadow
    protected abstract void func_222869_l();

    @Shadow
    @Nullable
    protected abstract ChunkHolder func_217213_a(long var1);

    @Shadow
    protected abstract boolean func_217235_l();

    @Shadow
    protected abstract boolean func_217224_a(@Nullable ChunkHolder var1, int var2);

    @Shadow
    protected abstract void func_241098_a_(long var1, Consumer<Chunk> var3);

    @Override
    @Invoker(value="func_217235_l")
    public abstract boolean bridge$tickDistanceManager();

    @Override
    @Accessor(value="lightManager")
    public abstract ServerWorldLightManager bridge$getLightManager();

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        ChunkHolder chunk = ((ChunkManagerBridge)this.field_217237_a).bridge$chunkHolderAt(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ));
        return chunk != null && ((ChunkHolderBridge)chunk).bridge$getFullChunk() != null;
    }

    @Override
    public boolean bridge$isChunkLoaded(int x, int z) {
        return this.isChunkLoaded(x, z);
    }

    @Override
    public void bridge$setChunkGenerator(ChunkGenerator chunkGenerator) {
        this.field_186029_c = chunkGenerator;
        ((ChunkManagerBridge)this.field_217237_a).bridge$setChunkGenerator(chunkGenerator);
    }

    @Override
    public void bridge$setViewDistance(int viewDistance) {
        ((ChunkManagerBridge)this.field_217237_a).bridge$setViewDistance(viewDistance);
    }

    @ModifyVariable(method={"func_217233_c"}, index=4, at=@At(value="HEAD"))
    private boolean arclight$skipIfUnloading(boolean flag, int chunkX, int chunkZ) {
        if (flag) {
            ChunkHolder chunkholder = this.func_217213_a(ChunkPos.func_77272_a((int)chunkX, (int)chunkZ));
            if (chunkholder != null) {
                ChunkHolder.LocationType chunkStatus = ChunkHolder.func_219286_c((int)((ChunkHolderBridge)chunkholder).bridge$getOldTicketLevel());
                ChunkHolder.LocationType currentStatus = ChunkHolder.func_219286_c((int)chunkholder.func_219299_i());
                return !chunkStatus.func_219065_a(ChunkHolder.LocationType.BORDER) || currentStatus.func_219065_a(ChunkHolder.LocationType.BORDER);
            }
            return true;
        }
        return false;
    }

    @Redirect(method={"tickChunks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Lnet/minecraft/world/GameRules$RuleKey;)Z"))
    private boolean arclight$noPlayer(GameRules gameRules, GameRules.RuleKey<GameRules.BooleanValue> key) {
        return gameRules.func_223586_b(key) && !this.field_73251_h.func_217369_A().isEmpty();
    }

    @Redirect(method={"tickChunks"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/storage/IWorldInfo;getGameTime()J"))
    private long arclight$ticksPer(IWorldInfo worldInfo) {
        long gameTime = worldInfo.func_82573_f();
        long ticksPer = ((WorldBridge)this.field_73251_h).bridge$ticksPerAnimalSpawns();
        return ticksPer != 0L && gameTime % ticksPer == 0L ? 0L : 1L;
    }

    public void close(boolean save) throws IOException {
        if (save) {
            this.func_217210_a(true);
        }
        this.field_217242_h.close();
        this.field_217237_a.close();
    }

    public void purgeUnload() {
        this.field_73251_h.func_217381_Z().func_76320_a("purge");
        ((TicketManagerBridge)this.field_217240_d).bridge$tick();
        this.bridge$tickDistanceManager();
        this.field_73251_h.func_217381_Z().func_219895_b("unload");
        ((ChunkManagerBridge)this.field_217237_a).bridge$tick(() -> true);
        this.field_73251_h.func_217381_Z().func_76319_b();
        this.func_222869_l();
    }

    @Override
    public void bridge$close(boolean save) throws IOException {
        this.close(save);
    }

    @Override
    public void bridge$purgeUnload() {
        this.purgeUnload();
    }

    @Redirect(method={"func_217224_a"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ChunkHolder;getChunkLevel()I"))
    public int arclight$useOldTicketLevel(ChunkHolder chunkHolder) {
        return ((ChunkHolderBridge)chunkHolder).bridge$getOldTicketLevel();
    }
}

