/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.storage;

import io.izzel.arclight.common.bridge.entity.player.ServerPlayerEntityBridge;
import io.izzel.arclight.common.bridge.world.storage.PlayerDataBridge;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.world.storage.PlayerData;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerData.class})
public class PlayerDataMixin
implements PlayerDataBridge {
    @Shadow
    @Final
    private File field_237333_c_;
    @Shadow
    @Final
    private static Logger field_237332_b_;

    @Inject(method={"loadPlayerData"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundNBT;contains(Ljava/lang/String;I)Z")})
    private void arclight$lastSeenTime(PlayerEntity player, CallbackInfoReturnable<CompoundNBT> cir) {
        if (player instanceof ServerPlayerEntity) {
            CraftPlayer craftPlayer = ((ServerPlayerEntityBridge)player).bridge$getBukkitEntity();
            long modified = new File(this.field_237333_c_, player.func_110124_au().toString() + ".dat").lastModified();
            if (modified < craftPlayer.getFirstPlayed()) {
                craftPlayer.setFirstPlayed(modified);
            }
        }
    }

    public File getPlayerDir() {
        return this.field_237333_c_;
    }

    public CompoundNBT getPlayerData(String uuid) {
        try {
            File file1 = new File(this.field_237333_c_, uuid + ".dat");
            if (file1.exists()) {
                return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file1));
            }
        }
        catch (Exception exception) {
            field_237332_b_.warn("Failed to load player data for " + uuid);
        }
        return null;
    }

    @Override
    public File bridge$getPlayerDir() {
        return this.getPlayerDir();
    }

    @Override
    public CompoundNBT bridge$getPlayerData(String uuid) {
        return this.getPlayerData(uuid);
    }
}

