/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.server;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.izzel.arclight.api.EnumHelper;
import io.izzel.arclight.api.Unsafe;
import io.izzel.arclight.common.bridge.bukkit.EntityTypeBridge;
import io.izzel.arclight.common.bridge.bukkit.MaterialBridge;
import io.izzel.arclight.common.mod.ArclightMod;
import io.izzel.arclight.common.mod.server.ArclightServer;
import io.izzel.arclight.common.mod.util.ResourceLocationUtil;
import io.izzel.arclight.common.mod.util.types.ArclightEnchantment;
import io.izzel.arclight.common.mod.util.types.ArclightPotionEffect;
import io.izzel.arclight.i18n.ArclightConfig;
import io.izzel.arclight.i18n.conf.EntityPropertySpec;
import io.izzel.arclight.i18n.conf.MaterialPropertySpec;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraftforge.fml.CrashReportExtender;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.bukkit.Art;
import org.bukkit.Material;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_16_R3.CraftCrashReport;
import org.bukkit.craftbukkit.v1_16_R3.CraftStatistic;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftNamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.potion.PotionEffectType;

public class BukkitRegistry {
    private static final List<Class<?>> MAT_CTOR = ImmutableList.of(Integer.TYPE);
    private static final List<Class<?>> ENTITY_CTOR = ImmutableList.of(String.class, Class.class, Integer.TYPE);
    private static final List<Class<?>> ENV_CTOR = ImmutableList.of(Integer.TYPE);
    private static final Map<String, Material> BY_NAME = (Map)Unsafe.getStatic(Material.class, "BY_NAME");
    private static final Map<Block, Material> BLOCK_MATERIAL = (Map)Unsafe.getStatic(CraftMagicNumbers.class, "BLOCK_MATERIAL");
    private static final Map<Item, Material> ITEM_MATERIAL = (Map)Unsafe.getStatic(CraftMagicNumbers.class, "ITEM_MATERIAL");
    private static final Map<Material, Item> MATERIAL_ITEM = (Map)Unsafe.getStatic(CraftMagicNumbers.class, "MATERIAL_ITEM");
    private static final Map<Material, Block> MATERIAL_BLOCK = (Map)Unsafe.getStatic(CraftMagicNumbers.class, "MATERIAL_BLOCK");
    private static final Map<String, EntityType> ENTITY_NAME_MAP = (Map)Unsafe.getStatic(EntityType.class, "NAME_MAP");
    private static final Map<Integer, World.Environment> ENVIRONMENT_MAP = (Map)Unsafe.getStatic(World.Environment.class, "lookup");
    static final BiMap<RegistryKey<DimensionType>, World.Environment> DIM_MAP = HashBiMap.create(ImmutableMap.builder().put(DimensionType.field_235999_c_, World.Environment.NORMAL).put(DimensionType.field_236000_d_, World.Environment.NETHER).put(DimensionType.field_236001_e_, World.Environment.THE_END).build());
    private static final Map<String, Art> ART_BY_NAME = (Map)Unsafe.getStatic(Art.class, "BY_NAME");
    private static final Map<Integer, Art> ART_BY_ID = (Map)Unsafe.getStatic(Art.class, "BY_ID");
    private static final BiMap<ResourceLocation, Statistic> STATS = HashBiMap.create((Map)Unsafe.getStatic(CraftStatistic.class, "statistics"));

    public static void registerAll() {
        CrashReportExtender.registerCrashCallable((String)"Arclight", () -> new CraftCrashReport().call().toString());
        BukkitRegistry.loadMaterials();
        BukkitRegistry.loadPotions();
        BukkitRegistry.loadEnchantments();
        BukkitRegistry.loadEntities();
        BukkitRegistry.loadVillagerProfessions();
        BukkitRegistry.loadBiomes();
        BukkitRegistry.loadArts();
        BukkitRegistry.loadStats();
    }

    private static void loadStats() {
        String standardName;
        Statistic statistic;
        int i = Statistic.values().length;
        ArrayList<Statistic> newTypes = new ArrayList<Statistic>();
        Field key = Arrays.stream(Statistic.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset(key);
        for (StatType statType : ForgeRegistries.STAT_TYPES) {
            if (statType == Stats.field_199092_j || (statistic = (Statistic)STATS.get(statType.getRegistryName())) != null) continue;
            standardName = ResourceLocationUtil.standardize(statType.getRegistryName());
            Statistic.Type type = statType.func_199080_a() == Registry.field_212629_r ? Statistic.Type.ENTITY : (statType.func_199080_a() == Registry.field_212618_g ? Statistic.Type.BLOCK : (statType.func_199080_a() == Registry.field_212630_s ? Statistic.Type.ITEM : Statistic.Type.UNTYPED));
            statistic = EnumHelper.makeEnum(Statistic.class, standardName, i, ImmutableList.of(Statistic.Type.class), ImmutableList.of(type));
            Unsafe.putObject(statistic, keyOffset, statType.getRegistryName());
            newTypes.add(statistic);
            STATS.put(statType.getRegistryName(), statistic);
            ArclightMod.LOGGER.debug("Registered {} as stats {}", (Object)statType.getRegistryName(), (Object)statistic);
            ++i;
        }
        for (ResourceLocation location : Registry.field_212623_l) {
            statistic = (Statistic)STATS.get(location);
            if (statistic != null) continue;
            standardName = ResourceLocationUtil.standardize(location);
            statistic = EnumHelper.makeEnum(Statistic.class, standardName, i, ImmutableList.of(), ImmutableList.of());
            Unsafe.putObject(statistic, keyOffset, location);
            newTypes.add(statistic);
            STATS.put(location, statistic);
            ArclightMod.LOGGER.debug("Registered {} as custom stats {}", (Object)location, (Object)statistic);
            ++i;
        }
        EnumHelper.addEnums(Statistic.class, newTypes);
        BukkitRegistry.putStatic(CraftStatistic.class, "statistics", STATS);
    }

    private static void loadArts() {
        int i = Art.values().length;
        ArrayList<Art> newTypes = new ArrayList<Art>();
        Field key = Arrays.stream(Art.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset(key);
        for (PaintingType paintingType : ForgeRegistries.PAINTING_TYPES) {
            String lookupName = paintingType.getRegistryName().func_110623_a().toLowerCase(Locale.ROOT);
            Art bukkit = Art.getByName(lookupName);
            if (bukkit != null) continue;
            String standardName = ResourceLocationUtil.standardize(paintingType.getRegistryName());
            bukkit = EnumHelper.makeEnum(Art.class, standardName, i, ImmutableList.of(Integer.TYPE, Integer.TYPE, Integer.TYPE), ImmutableList.of(Integer.valueOf(i), Integer.valueOf(paintingType.func_200834_b()), Integer.valueOf(paintingType.func_200832_c())));
            newTypes.add(bukkit);
            Unsafe.putObject(bukkit, keyOffset, CraftNamespacedKey.fromMinecraft(paintingType.getRegistryName()));
            ART_BY_ID.put(i, bukkit);
            ART_BY_NAME.put(lookupName, bukkit);
            ArclightMod.LOGGER.debug("Registered {} as art {}", (Object)paintingType.getRegistryName(), (Object)bukkit);
            ++i;
        }
        EnumHelper.addEnums(Art.class, newTypes);
    }

    private static void loadBiomes() {
        int i = Biome.values().length;
        ArrayList<Biome> newTypes = new ArrayList<Biome>();
        Field key = Arrays.stream(Biome.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset(key);
        for (net.minecraft.world.biome.Biome biome : ForgeRegistries.BIOMES) {
            Biome bukkit;
            String name = ResourceLocationUtil.standardize(biome.getRegistryName());
            try {
                bukkit = Biome.valueOf(name);
            }
            catch (Throwable t) {
                bukkit = null;
            }
            if (bukkit != null) continue;
            bukkit = EnumHelper.makeEnum(Biome.class, name, i++, ImmutableList.of(), ImmutableList.of());
            newTypes.add(bukkit);
            Unsafe.putObject(bukkit, keyOffset, CraftNamespacedKey.fromMinecraft(biome.getRegistryName()));
            ArclightMod.LOGGER.debug("Registered {} as biome {}", (Object)biome.getRegistryName(), (Object)bukkit);
        }
        EnumHelper.addEnums(Biome.class, newTypes);
        ArclightMod.LOGGER.info("registry.biome", (Object)newTypes.size());
    }

    private static void loadVillagerProfessions() {
        int i = Villager.Profession.values().length;
        ArrayList<Villager.Profession> newTypes = new ArrayList<Villager.Profession>();
        Field key = Arrays.stream(Villager.Profession.class.getDeclaredFields()).filter(it -> it.getName().equals("key")).findAny().orElse(null);
        long keyOffset = Unsafe.objectFieldOffset(key);
        for (VillagerProfession villagerProfession : ForgeRegistries.PROFESSIONS) {
            Villager.Profession profession;
            String name = ResourceLocationUtil.standardize(villagerProfession.getRegistryName());
            try {
                profession = Villager.Profession.valueOf(name);
            }
            catch (Throwable t) {
                profession = null;
            }
            if (profession != null) continue;
            profession = EnumHelper.makeEnum(Villager.Profession.class, name, i++, ImmutableList.of(), ImmutableList.of());
            newTypes.add(profession);
            Unsafe.putObject(profession, keyOffset, CraftNamespacedKey.fromMinecraft(villagerProfession.getRegistryName()));
            ArclightMod.LOGGER.debug("Registered {} as villager profession {}", (Object)villagerProfession.getRegistryName(), (Object)profession);
        }
        EnumHelper.addEnums(Villager.Profession.class, newTypes);
        ArclightMod.LOGGER.info("registry.villager-profession", (Object)newTypes.size());
    }

    public static void registerEnvironments() {
        int i = World.Environment.values().length;
        ArrayList<World.Environment> newTypes = new ArrayList<World.Environment>();
        MutableRegistry registry = ArclightServer.getMinecraftServer().func_244267_aX().func_243612_b(Registry.field_239698_ad_);
        for (Map.Entry entry : registry.func_239659_c_()) {
            RegistryKey key = (RegistryKey)entry.getKey();
            World.Environment environment = (World.Environment)((Object)DIM_MAP.get(key));
            if (environment != null) continue;
            String name = ResourceLocationUtil.standardize(key.func_240901_a_());
            environment = EnumHelper.makeEnum(World.Environment.class, name, i, ENV_CTOR, ImmutableList.of(Integer.valueOf(i - 1)));
            newTypes.add(environment);
            ENVIRONMENT_MAP.put(i - 1, environment);
            DIM_MAP.put((RegistryKey<DimensionType>)key, environment);
            ArclightMod.LOGGER.debug("Registered {} as environment {}", (Object)key.func_240901_a_(), (Object)environment);
            ++i;
        }
        EnumHelper.addEnums(World.Environment.class, newTypes);
        ArclightMod.LOGGER.info("registry.environment", (Object)newTypes.size());
    }

    private static void loadEntities() {
        int origin;
        int i = origin = EntityType.values().length;
        ArrayList<EntityType> newTypes = new ArrayList<EntityType>(ForgeRegistries.ENTITIES.getEntries().size() - origin + 1);
        for (net.minecraft.entity.EntityType type : ForgeRegistries.ENTITIES) {
            ResourceLocation location = type.getRegistryName();
            EntityType entityType = null;
            boolean found = false;
            if (location.func_110624_b().equals("minecraft")) {
                entityType = EntityType.fromName(location.func_110623_a());
                if (entityType != null) {
                    found = true;
                } else {
                    ArclightMod.LOGGER.warn("Not found {} in {}", (Object)location, EntityType.class);
                }
            }
            if (!found) {
                String name = ResourceLocationUtil.standardize(location);
                entityType = EnumHelper.makeEnum(EntityType.class, name, i++, ENTITY_CTOR, ImmutableList.of(location.func_110623_a(), Entity.class, Integer.valueOf(-1)));
                ((EntityTypeBridge)((Object)entityType)).bridge$setup(location, type, BukkitRegistry.entitySpec(location));
                newTypes.add(entityType);
                ArclightMod.LOGGER.debug("Registered {} as entity {}", (Object)location, (Object)entityType);
            }
            ENTITY_NAME_MAP.put(location.toString(), entityType);
        }
        EnumHelper.addEnums(EntityType.class, newTypes);
        ArclightMod.LOGGER.info("registry.entity-type", (Object)newTypes.size());
    }

    private static void loadEnchantments() {
        int origin = Enchantment.values().length;
        int size = ForgeRegistries.ENCHANTMENTS.getEntries().size();
        BukkitRegistry.putBool(Enchantment.class, "acceptingNew", true);
        for (net.minecraft.enchantment.Enchantment enc : ForgeRegistries.ENCHANTMENTS) {
            try {
                String name = ResourceLocationUtil.standardize(enc.getRegistryName());
                ArclightEnchantment enchantment = new ArclightEnchantment(enc, name);
                Enchantment.registerEnchantment(enchantment);
                ArclightMod.LOGGER.debug("Registered {} as enchantment {}", (Object)enc.getRegistryName(), (Object)enchantment);
            }
            catch (Exception e) {
                ArclightMod.LOGGER.error("Failed to register enchantment {}: {}", (Object)enc.getRegistryName(), (Object)e);
            }
        }
        Enchantment.stopAcceptingRegistrations();
        ArclightMod.LOGGER.info("registry.enchantment", (Object)(size - origin));
    }

    private static void loadPotions() {
        int origin = PotionEffectType.values().length;
        int size = ForgeRegistries.POTIONS.getEntries().size();
        int maxId = ForgeRegistries.POTIONS.getValues().stream().mapToInt(Effect::func_188409_a).max().orElse(0);
        PotionEffectType[] types = new PotionEffectType[maxId + 1];
        BukkitRegistry.putStatic(PotionEffectType.class, "byId", types);
        BukkitRegistry.putBool(PotionEffectType.class, "acceptingNew", true);
        for (Effect eff : ForgeRegistries.POTIONS) {
            try {
                String name = ResourceLocationUtil.standardize(eff.getRegistryName());
                ArclightPotionEffect effect = new ArclightPotionEffect(eff, name);
                PotionEffectType.registerPotionEffectType(effect);
                ArclightMod.LOGGER.debug("Registered {} as potion {}", (Object)eff.getRegistryName(), (Object)effect);
            }
            catch (Exception e) {
                ArclightMod.LOGGER.error("Failed to register potion type {}: {}", (Object)eff.getRegistryName(), (Object)e);
            }
        }
        PotionEffectType.stopAcceptingRegistrations();
        ArclightMod.LOGGER.info("registry.potion", (Object)(size - origin));
    }

    private static void loadMaterials() {
        Item value;
        Material material;
        String name;
        ResourceLocation location;
        int i;
        int blocks = 0;
        int items = 0;
        int origin = i = Material.values().length;
        ArrayList<Material> list = new ArrayList<Material>();
        for (Block block : ForgeRegistries.BLOCKS) {
            location = block.getRegistryName();
            name = ResourceLocationUtil.standardize(location);
            material = BY_NAME.get(name);
            if (material == null) {
                material = EnumHelper.makeEnum(Material.class, name, i, MAT_CTOR, ImmutableList.of(Integer.valueOf(i)));
                ((MaterialBridge)((Object)material)).bridge$setupBlock(location, block, BukkitRegistry.matSpec(location));
                BY_NAME.put(name, material);
                ++i;
                ++blocks;
                ArclightMod.LOGGER.debug("Registered {} as block {}", (Object)location, (Object)material);
                list.add(material);
            } else {
                ((MaterialBridge)((Object)material)).bridge$setupVanillaBlock(BukkitRegistry.matSpec(location));
            }
            BLOCK_MATERIAL.put(block, material);
            MATERIAL_BLOCK.put(material, block);
            value = (Item)ForgeRegistries.ITEMS.getValue(location);
            if (value == null || value == Items.field_190931_a) continue;
            ((MaterialBridge)((Object)material)).bridge$setItem();
            ITEM_MATERIAL.put(value, material);
            MATERIAL_ITEM.put(material, value);
        }
        for (Item item : ForgeRegistries.ITEMS) {
            location = item.getRegistryName();
            name = ResourceLocationUtil.standardize(location);
            material = BY_NAME.get(name);
            if (material == null) {
                material = EnumHelper.makeEnum(Material.class, name, i, MAT_CTOR, ImmutableList.of(Integer.valueOf(i)));
                ((MaterialBridge)((Object)material)).bridge$setupItem(location, item, BukkitRegistry.matSpec(location));
                BY_NAME.put(name, material);
                ++i;
                ++items;
                ArclightMod.LOGGER.debug("Registered {} as item {}", (Object)location, (Object)material);
                list.add(material);
            }
            ITEM_MATERIAL.put(item, material);
            MATERIAL_ITEM.put(material, item);
            value = (Block)ForgeRegistries.BLOCKS.getValue(location);
            if (value == null || value == Blocks.field_150350_a) continue;
            ((MaterialBridge)((Object)material)).bridge$setBlock();
            BLOCK_MATERIAL.put((Block)value, material);
            MATERIAL_BLOCK.put(material, (Block)value);
        }
        EnumHelper.addEnums(Material.class, list);
        ArclightMod.LOGGER.info("registry.material", (Object)(i - origin), (Object)blocks, (Object)items);
    }

    private static MaterialPropertySpec matSpec(ResourceLocation location) {
        return ArclightConfig.spec().getCompat().getMaterial(location.toString()).orElse(MaterialPropertySpec.EMPTY);
    }

    private static EntityPropertySpec entitySpec(ResourceLocation location) {
        return ArclightConfig.spec().getCompat().getEntity(location.toString()).orElse(EntityPropertySpec.EMPTY);
    }

    private static void putStatic(Class<?> cl, String name, Object o) {
        try {
            Unsafe.ensureClassInitialized(cl);
            Field field = cl.getDeclaredField(name);
            Object materialByNameBase = Unsafe.staticFieldBase(field);
            long materialByNameOffset = Unsafe.staticFieldOffset(field);
            Unsafe.putObject(materialByNameBase, materialByNameOffset, o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void putBool(Class<?> cl, String name, boolean b) {
        try {
            Unsafe.ensureClassInitialized(cl);
            Field field = cl.getDeclaredField(name);
            Object materialByNameBase = Unsafe.staticFieldBase(field);
            long materialByNameOffset = Unsafe.staticFieldOffset(field);
            Unsafe.putBoolean(materialByNameBase, materialByNameOffset, b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Set<IForgeRegistry<?>> registries() {
        return ImmutableSet.of(ForgeRegistries.BLOCKS, ForgeRegistries.ITEMS, ForgeRegistries.POTION_TYPES, ForgeRegistries.POTIONS, ForgeRegistries.ENTITIES, ForgeRegistries.TILE_ENTITIES, new IForgeRegistry[]{ForgeRegistries.BIOMES});
    }

    public static void unlockRegistries() {
        for (IForgeRegistry<?> registry : BukkitRegistry.registries()) {
            if (!(registry instanceof ForgeRegistry)) continue;
            ((ForgeRegistry)registry).unfreeze();
        }
    }

    public static void lockRegistries() {
        for (IForgeRegistry<?> registry : BukkitRegistry.registries()) {
            if (!(registry instanceof ForgeRegistry)) continue;
            ((ForgeRegistry)registry).freeze();
        }
    }
}

