/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mod.util;

import io.izzel.arclight.common.mod.ArclightConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.BlockPos;
import org.bukkit.TreeType;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftPortalEvent;
import org.bukkit.event.block.BlockBreakEvent;

public class ArclightCaptures {
    private static Entity entityChangeBlock;
    private static BlockBreakEvent blockBreakEvent;
    private static List<ItemEntity> blockDrops;
    private static BlockState blockBreakPlayerState;
    private static String quitMessage;
    private static Direction placeEventDirection;
    private static Hand placeEventHand;
    private static TreeType treeType;
    private static transient Container arclight$capturedContainer;
    private static transient Entity damageEventEntity;
    private static transient BlockPos damageEventBlock;
    private static transient PlayerEntity containerOwner;
    private static transient CraftPortalEvent craftPortalEvent;
    private static transient Entity endPortalEntity;
    private static transient boolean spawnPortal;
    private static transient DatapackCodec datapackCodec;

    public static void captureEntityChangeBlock(Entity entity) {
        entityChangeBlock = entity;
    }

    public static Entity getEntityChangeBlock() {
        try {
            Entity entity = entityChangeBlock;
            return entity;
        }
        finally {
            entityChangeBlock = null;
        }
    }

    public static void captureBlockBreakPlayer(BlockBreakEvent event) {
        blockBreakEvent = event;
        blockDrops = new ArrayList<ItemEntity>();
        blockBreakPlayerState = event.getBlock().getState();
    }

    public static BlockBreakEvent getBlockBreakPlayer() {
        return blockBreakEvent;
    }

    public static BlockState getBlockBreakPlayerState() {
        return blockBreakPlayerState;
    }

    public static List<ItemEntity> getBlockDrops() {
        return blockDrops;
    }

    public static BlockBreakEvent resetBlockBreakPlayer() {
        try {
            BlockBreakEvent blockBreakEvent = ArclightCaptures.blockBreakEvent;
            return blockBreakEvent;
        }
        finally {
            blockBreakEvent = null;
            blockDrops = null;
            blockBreakPlayerState = null;
        }
    }

    public static void captureQuitMessage(String quitMessage) {
        if (ArclightCaptures.quitMessage == null) {
            ArclightCaptures.quitMessage = quitMessage;
        } else {
            ArclightCaptures.recapture("quit message");
        }
    }

    public static String getQuitMessage() {
        try {
            String string = quitMessage;
            return string;
        }
        finally {
            quitMessage = null;
        }
    }

    public static void capturePlaceEventDirection(Direction direction) {
        placeEventDirection = direction;
    }

    public static Direction getPlaceEventDirection() {
        try {
            Direction direction = placeEventDirection;
            return direction;
        }
        finally {
            placeEventDirection = null;
        }
    }

    public static void capturePlaceEventHand(Hand hand) {
        placeEventHand = hand;
    }

    public static Hand getPlaceEventHand(Hand hand) {
        try {
            Hand hand2 = placeEventHand == null ? hand : placeEventHand;
            return hand2;
        }
        finally {
            placeEventHand = null;
        }
    }

    public static void captureTreeType(TreeType treeType) {
        ArclightCaptures.treeType = treeType;
    }

    public static TreeType getTreeType() {
        try {
            TreeType treeType = ArclightCaptures.treeType == null ? ArclightConstants.MOD : ArclightCaptures.treeType;
            return treeType;
        }
        finally {
            treeType = null;
        }
    }

    public static void captureWorkbenchContainer(Container container) {
        arclight$capturedContainer = container;
    }

    public static Container getWorkbenchContainer() {
        try {
            Container container = arclight$capturedContainer;
            return container;
        }
        finally {
            arclight$capturedContainer = null;
        }
    }

    public static void captureDamageEventEntity(Entity entity) {
        damageEventEntity = entity;
    }

    public static Entity getDamageEventEntity() {
        try {
            Entity entity = damageEventEntity;
            return entity;
        }
        finally {
            damageEventEntity = null;
        }
    }

    public static void captureDamageEventBlock(BlockPos blockState) {
        damageEventBlock = blockState;
    }

    public static BlockPos getDamageEventBlock() {
        try {
            BlockPos blockPos = damageEventBlock;
            return blockPos;
        }
        finally {
            damageEventBlock = null;
        }
    }

    public static void captureContainerOwner(PlayerEntity entity) {
        containerOwner = entity;
    }

    public static PlayerEntity getContainerOwner() {
        return containerOwner;
    }

    public static void resetContainerOwner() {
        containerOwner = null;
    }

    public static void captureCraftPortalEvent(CraftPortalEvent event) {
        craftPortalEvent = event;
    }

    public static CraftPortalEvent getCraftPortalEvent() {
        try {
            CraftPortalEvent craftPortalEvent = ArclightCaptures.craftPortalEvent;
            return craftPortalEvent;
        }
        finally {
            craftPortalEvent = null;
        }
    }

    public static void captureEndPortalEntity(Entity entity, boolean portal) {
        endPortalEntity = entity;
        spawnPortal = portal;
    }

    public static boolean getEndPortalSpawn() {
        return spawnPortal;
    }

    public static Entity getEndPortalEntity() {
        try {
            Entity entity = endPortalEntity;
            return entity;
        }
        finally {
            endPortalEntity = null;
            spawnPortal = false;
        }
    }

    public static void captureDatapackConfig(DatapackCodec codec) {
        datapackCodec = codec;
    }

    public static DatapackCodec getDatapackConfig() {
        try {
            DatapackCodec datapackCodec = ArclightCaptures.datapackCodec;
            return datapackCodec;
        }
        finally {
            datapackCodec = null;
        }
    }

    private static void recapture(String type) {
        throw new IllegalStateException("Recapturing " + type);
    }
}

