/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.bukkit.Art;

public class CraftArt {
    private static final BiMap<PaintingType, Art> artwork;

    static {
        ImmutableBiMap.Builder artworkBuilder = ImmutableBiMap.builder();
        for (ResourceLocation key : Registry.field_212620_i.func_148742_b()) {
            artworkBuilder.put((PaintingType)Registry.field_212620_i.func_82594_a(key), Art.getByName(key.func_110623_a()));
        }
        artwork = artworkBuilder.build();
    }

    public static Art NotchToBukkit(PaintingType art) {
        Art bukkit = (Art)artwork.get(art);
        Preconditions.checkArgument(bukkit != null);
        return bukkit;
    }

    public static PaintingType BukkitToNotch(Art art) {
        PaintingType nms = (PaintingType)artwork.inverse().get(art);
        Preconditions.checkArgument(nms != null);
        return nms;
    }
}

