/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.util.math.BlockPos;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Beehive;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftBee;
import org.bukkit.entity.Bee;

public class CraftBeehive
extends CraftBlockEntityState<BeehiveTileEntity>
implements Beehive {
    public CraftBeehive(Block block) {
        super(block, BeehiveTileEntity.class);
    }

    public CraftBeehive(Material material, BeehiveTileEntity te) {
        super(material, te);
    }

    @Override
    public Location getFlower() {
        BlockPos flower = ((BeehiveTileEntity)this.getSnapshot()).field_226959_b_;
        return flower == null ? null : new Location(this.getWorld(), flower.func_177958_n(), flower.func_177956_o(), flower.func_177952_p());
    }

    @Override
    public void setFlower(Location location) {
        Preconditions.checkArgument(location == null || this.getWorld().equals(location.getWorld()), "Flower must be in same world");
        ((BeehiveTileEntity)this.getSnapshot()).field_226959_b_ = location == null ? null : new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public boolean isFull() {
        return ((BeehiveTileEntity)this.getSnapshot()).func_226970_h_();
    }

    @Override
    public boolean isSedated() {
        return this.isPlaced() && ((BeehiveTileEntity)this.getTileEntity()).func_226972_k_();
    }

    @Override
    public int getEntityCount() {
        return ((BeehiveTileEntity)this.getSnapshot()).func_226971_j_();
    }

    @Override
    public int getMaxEntities() {
        return ((BeehiveTileEntity)this.getSnapshot()).maxBees;
    }

    @Override
    public void setMaxEntities(int max) {
        Preconditions.checkArgument(max > 0, "Max bees must be more than 0");
        ((BeehiveTileEntity)this.getSnapshot()).maxBees = max;
    }

    @Override
    public List<Bee> releaseEntities() {
        ArrayList<Bee> bees = new ArrayList<Bee>();
        if (this.isPlaced()) {
            BeehiveTileEntity beehive = (BeehiveTileEntity)this.getTileEntityFromWorld();
            for (Entity bee : beehive.releaseBees(this.getHandle(), BeehiveTileEntity.State.BEE_RELEASED, true)) {
                bees.add((Bee)((Object)bee.getBukkitEntity()));
            }
        }
        return bees;
    }

    @Override
    public void addEntity(Bee entity) {
        Preconditions.checkArgument(entity != null, "Entity must not be null");
        ((BeehiveTileEntity)this.getSnapshot()).func_226961_a_((Entity)((CraftBee)entity).getHandle(), false);
    }
}

