/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.entity;

import java.util.Random;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftProjectile;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class CraftFirework
extends CraftProjectile
implements Firework {
    private final Random random = new Random();
    private final CraftItemStack item;

    public CraftFirework(CraftServer server, FireworkRocketEntity entity) {
        super(server, (ProjectileEntity)entity);
        ItemStack item = (ItemStack)this.getHandle().func_184212_Q().func_187225_a(FireworkRocketEntity.field_184566_a);
        if (item.func_190926_b()) {
            item = new ItemStack((IItemProvider)Items.field_196152_dE);
            this.getHandle().func_184212_Q().func_187227_b(FireworkRocketEntity.field_184566_a, (Object)item);
        }
        this.item = CraftItemStack.asCraftMirror(item);
        if (this.item.getType() != Material.FIREWORK_ROCKET) {
            this.item.setType(Material.FIREWORK_ROCKET);
        }
    }

    public FireworkRocketEntity getHandle() {
        return (FireworkRocketEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFirework";
    }

    @Override
    public EntityType getType() {
        return EntityType.FIREWORK;
    }

    @Override
    public FireworkMeta getFireworkMeta() {
        return (FireworkMeta)this.item.getItemMeta();
    }

    @Override
    public void setFireworkMeta(FireworkMeta meta) {
        this.item.setItemMeta(meta);
        this.getHandle().field_92055_b = 10 * (1 + meta.getPower()) + this.random.nextInt(6) + this.random.nextInt(7);
        this.getHandle().func_184212_Q().markDirty(FireworkRocketEntity.field_184566_a);
    }

    @Override
    public void detonate() {
        this.getHandle().field_92055_b = 0;
    }

    @Override
    public boolean isShotAtAngle() {
        return this.getHandle().func_213889_i();
    }

    @Override
    public void setShotAtAngle(boolean shotAtAngle) {
        this.getHandle().func_184212_Q().func_187227_b(FireworkRocketEntity.field_213895_d, (Object)shotAtAngle);
    }
}

