/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CraftingTableBlock;
import net.minecraft.block.EnchantingTableBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CCloseWindowPacket;
import net.minecraft.network.play.server.SOpenWindowPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryLectern;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftNamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;

public class CraftHumanEntity
extends CraftLivingEntity
implements HumanEntity {
    private CraftInventoryPlayer inventory;
    private final CraftInventory enderChest;
    protected final PermissibleBase perm = new PermissibleBase(this);
    private boolean op;
    private GameMode mode;

    public CraftHumanEntity(CraftServer server, PlayerEntity entity) {
        super(server, (LivingEntity)entity);
        this.mode = server.getDefaultGameMode();
        this.inventory = new CraftInventoryPlayer(entity.field_71071_by);
        this.enderChest = new CraftInventory((IInventory)entity.func_71005_bN());
    }

    @Override
    public PlayerInventory getInventory() {
        return this.inventory;
    }

    @Override
    public EntityEquipment getEquipment() {
        return this.inventory;
    }

    @Override
    public Inventory getEnderChest() {
        return this.enderChest;
    }

    @Override
    public MainHand getMainHand() {
        return this.getHandle().func_184591_cq() == HandSide.LEFT ? MainHand.LEFT : MainHand.RIGHT;
    }

    @Override
    public ItemStack getItemInHand() {
        return this.getInventory().getItemInHand();
    }

    @Override
    public void setItemInHand(ItemStack item) {
        this.getInventory().setItemInHand(item);
    }

    @Override
    public ItemStack getItemOnCursor() {
        return CraftItemStack.asCraftMirror(this.getHandle().field_71071_by.func_70445_o());
    }

    @Override
    public void setItemOnCursor(ItemStack item) {
        net.minecraft.item.ItemStack stack = CraftItemStack.asNMSCopy(item);
        this.getHandle().field_71071_by.func_70437_b(stack);
        if (this instanceof CraftPlayer) {
            ((ServerPlayerEntity)this.getHandle()).func_71113_k();
        }
    }

    @Override
    public int getSleepTicks() {
        return this.getHandle().field_71076_b;
    }

    @Override
    public boolean sleep(Location location, boolean force) {
        Preconditions.checkArgument(location != null, "Location cannot be null");
        Preconditions.checkArgument(location.getWorld() != null, "Location needs to be in a world");
        Preconditions.checkArgument(location.getWorld().equals(this.getWorld()), "Cannot sleep across worlds");
        BlockPos blockposition = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        BlockState iblockdata = this.getHandle().field_70170_p.func_180495_p(blockposition);
        if (!(iblockdata.func_177230_c() instanceof BedBlock)) {
            return false;
        }
        if (this.getHandle().sleep(blockposition, force).left().isPresent()) {
            return false;
        }
        iblockdata = (BlockState)iblockdata.func_206870_a((Property)BedBlock.field_176471_b, (Comparable)Boolean.valueOf(true));
        this.getHandle().field_70170_p.func_180501_a(blockposition, iblockdata, 4);
        return true;
    }

    @Override
    public void wakeup(boolean setSpawnLocation) {
        Preconditions.checkState(this.isSleeping(), "Cannot wakeup if not sleeping");
        this.getHandle().func_225652_a_(true, setSpawnLocation);
    }

    @Override
    public Location getBedLocation() {
        Preconditions.checkState(this.isSleeping(), "Not sleeping");
        BlockPos bed = (BlockPos)this.getHandle().func_213374_dv().get();
        return new Location(this.getWorld(), bed.func_177958_n(), bed.func_177956_o(), bed.func_177952_p());
    }

    @Override
    public String getName() {
        return this.getHandle().func_195047_I_();
    }

    @Override
    public boolean isOp() {
        return this.op;
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return this.perm.isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.perm.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return this.perm.hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.perm.addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return this.perm.addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return this.perm.addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.perm.recalculatePermissions();
    }

    @Override
    public void setOp(boolean value) {
        this.op = value;
        this.perm.recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    @Override
    public GameMode getGameMode() {
        return this.mode;
    }

    @Override
    public void setGameMode(GameMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        this.mode = mode;
    }

    public PlayerEntity getHandle() {
        return (PlayerEntity)this.entity;
    }

    public void setHandle(PlayerEntity entity) {
        super.setHandle((LivingEntity)entity);
        this.inventory = new CraftInventoryPlayer(entity.field_71071_by);
    }

    @Override
    public String toString() {
        return "CraftHumanEntity{id=" + this.getEntityId() + "name=" + this.getName() + '}';
    }

    @Override
    public InventoryView getOpenInventory() {
        return this.getHandle().field_71070_bA.getBukkitView();
    }

    @Override
    public InventoryView openInventory(Inventory inventory) {
        TileEntity te;
        CraftInventory craft;
        if (!(this.getHandle() instanceof ServerPlayerEntity)) {
            return null;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)this.getHandle();
        Container formerContainer = this.getHandle().field_71070_bA;
        INamedContainerProvider iinventory = null;
        if (inventory instanceof CraftInventoryDoubleChest) {
            iinventory = ((CraftInventoryDoubleChest)inventory).tile;
        } else if (inventory instanceof CraftInventoryLectern) {
            iinventory = ((CraftInventoryLectern)inventory).tile;
        } else if (inventory instanceof CraftInventory && (craft = (CraftInventory)inventory).getInventory() instanceof INamedContainerProvider) {
            iinventory = (INamedContainerProvider)craft.getInventory();
        }
        if (iinventory instanceof INamedContainerProvider && iinventory instanceof TileEntity && !(te = (TileEntity)iinventory).func_145830_o()) {
            te.func_226984_a_(this.getHandle().field_70170_p, this.getHandle().func_233580_cy_());
        }
        ContainerType container = CraftContainer.getNotchInventoryType(inventory);
        if (iinventory instanceof INamedContainerProvider) {
            this.getHandle().func_213829_a(iinventory);
        } else {
            this.openCustomInventory(inventory, player, container);
        }
        if (this.getHandle().field_71070_bA == formerContainer) {
            return null;
        }
        this.getHandle().field_71070_bA.checkReachable = false;
        return this.getHandle().field_71070_bA.getBukkitView();
    }

    private void openCustomInventory(Inventory inventory, ServerPlayerEntity player, ContainerType<?> windowType) {
        if (player.field_71135_a == null) {
            return;
        }
        Preconditions.checkArgument(windowType != null, "Unknown windowType");
        CraftContainer container = new CraftContainer(inventory, this.getHandle(), player.nextContainerCounter());
        container = CraftEventFactory.callInventoryOpenEvent(player, container);
        if (container == null) {
            return;
        }
        String title = container.getBukkitView().getTitle();
        player.field_71135_a.func_147359_a((IPacket)new SOpenWindowPacket(container.field_75152_c, windowType, CraftChatMessage.fromString(title)[0]));
        this.getHandle().field_71070_bA = container;
        this.getHandle().field_71070_bA.func_75132_a((IContainerListener)player);
    }

    @Override
    public InventoryView openWorkbench(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.CRAFTING_TABLE) {
            return null;
        }
        this.getHandle().func_213829_a(((CraftingTableBlock)Blocks.field_150462_ai).func_220052_b(null, this.getHandle().field_70170_p, new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ())));
        if (force) {
            this.getHandle().field_71070_bA.checkReachable = false;
        }
        return this.getHandle().field_71070_bA.getBukkitView();
    }

    @Override
    public InventoryView openEnchanting(Location location, boolean force) {
        Block block;
        if (location == null) {
            location = this.getLocation();
        }
        if (!force && (block = location.getBlock()).getType() != Material.ENCHANTING_TABLE) {
            return null;
        }
        BlockPos pos = new BlockPos(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        this.getHandle().func_213829_a(((EnchantingTableBlock)Blocks.field_150381_bn).func_220052_b(null, this.getHandle().field_70170_p, pos));
        if (force) {
            this.getHandle().field_71070_bA.checkReachable = false;
        }
        return this.getHandle().field_71070_bA.getBukkitView();
    }

    @Override
    public void openInventory(InventoryView inventory) {
        if (!(this.getHandle() instanceof ServerPlayerEntity)) {
            return;
        }
        if (((ServerPlayerEntity)this.getHandle()).field_71135_a == null) {
            return;
        }
        if (this.getHandle().field_71070_bA != this.getHandle().field_71069_bz) {
            ((ServerPlayerEntity)this.getHandle()).field_71135_a.func_147356_a(new CCloseWindowPacket(this.getHandle().field_71070_bA.field_75152_c));
        }
        ServerPlayerEntity player = (ServerPlayerEntity)this.getHandle();
        Object container = inventory instanceof CraftInventoryView ? ((CraftInventoryView)inventory).getHandle() : new CraftContainer(inventory, this.getHandle(), player.nextContainerCounter());
        if ((container = CraftEventFactory.callInventoryOpenEvent(player, container)) == null) {
            return;
        }
        ContainerType windowType = CraftContainer.getNotchInventoryType(inventory.getTopInventory());
        String title = inventory.getTitle();
        player.field_71135_a.func_147359_a((IPacket)new SOpenWindowPacket(container.field_75152_c, windowType, CraftChatMessage.fromString(title)[0]));
        player.field_71070_bA = container;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
    }

    @Override
    public InventoryView openMerchant(Villager villager, boolean force) {
        Preconditions.checkNotNull(villager, "villager cannot be null");
        return this.openMerchant((Merchant)villager, force);
    }

    @Override
    public InventoryView openMerchant(Merchant merchant, boolean force) {
        ITextComponent name;
        Object mcMerchant;
        Preconditions.checkNotNull(merchant, "merchant cannot be null");
        if (!force && merchant.isTrading()) {
            return null;
        }
        if (merchant.isTrading()) {
            merchant.getTrader().closeInventory();
        }
        int level = 1;
        if (merchant instanceof CraftAbstractVillager) {
            mcMerchant = ((CraftAbstractVillager)merchant).getHandle();
            name = ((CraftAbstractVillager)merchant).getHandle().func_145748_c_();
            if (merchant instanceof CraftVillager) {
                level = ((CraftVillager)merchant).getHandle().func_213700_eh().func_221132_c();
            }
        } else if (merchant instanceof CraftMerchantCustom) {
            mcMerchant = ((CraftMerchantCustom)merchant).getMerchant();
            name = ((CraftMerchantCustom)merchant).getMerchant().getScoreboardDisplayName();
        } else {
            throw new IllegalArgumentException("Can't open merchant " + merchant.toString());
        }
        mcMerchant.func_70932_a_(this.getHandle());
        mcMerchant.func_213707_a(this.getHandle(), name, level);
        return this.getHandle().field_71070_bA.getBukkitView();
    }

    @Override
    public void closeInventory() {
        this.getHandle().func_71053_j();
    }

    @Override
    public boolean isBlocking() {
        return this.getHandle().func_184585_cz();
    }

    @Override
    public boolean isHandRaised() {
        return this.getHandle().func_184587_cr();
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        return false;
    }

    @Override
    public int getExpToLevel() {
        return this.getHandle().func_71050_bK();
    }

    @Override
    public float getAttackCooldown() {
        return this.getHandle().func_184825_o(0.5f);
    }

    @Override
    public boolean hasCooldown(Material material) {
        Preconditions.checkArgument(material != null, "material");
        return this.getHandle().func_184811_cZ().func_185141_a(CraftMagicNumbers.getItem(material));
    }

    @Override
    public int getCooldown(Material material) {
        Preconditions.checkArgument(material != null, "material");
        CooldownTracker.Cooldown cooldown = (CooldownTracker.Cooldown)this.getHandle().func_184811_cZ().field_185147_a.get(CraftMagicNumbers.getItem(material));
        return cooldown == null ? 0 : Math.max(0, cooldown.field_185138_b - this.getHandle().func_184811_cZ().field_185148_b);
    }

    @Override
    public void setCooldown(Material material, int ticks) {
        Preconditions.checkArgument(material != null, "material");
        Preconditions.checkArgument(ticks >= 0, "Cannot have negative cooldown");
        this.getHandle().func_184811_cZ().func_185145_a(CraftMagicNumbers.getItem(material), ticks);
    }

    @Override
    public boolean discoverRecipe(NamespacedKey recipe) {
        return this.discoverRecipes(Arrays.asList(recipe)) != 0;
    }

    @Override
    public int discoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().func_195065_a(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    @Override
    public boolean undiscoverRecipe(NamespacedKey recipe) {
        return this.undiscoverRecipes(Arrays.asList(recipe)) != 0;
    }

    @Override
    public int undiscoverRecipes(Collection<NamespacedKey> recipes) {
        return this.getHandle().func_195069_b(this.bukkitKeysToMinecraftRecipes(recipes));
    }

    @Override
    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        return false;
    }

    @Override
    public Set<NamespacedKey> getDiscoveredRecipes() {
        return ImmutableSet.of();
    }

    private Collection<IRecipe<?>> bukkitKeysToMinecraftRecipes(Collection<NamespacedKey> recipeKeys) {
        ArrayList recipes = new ArrayList();
        RecipeManager manager = this.getHandle().field_70170_p.func_73046_m().func_199529_aN();
        for (NamespacedKey recipeKey : recipeKeys) {
            Optional recipe = manager.func_215367_a(CraftNamespacedKey.toMinecraft(recipeKey));
            if (!recipe.isPresent()) continue;
            recipes.add((IRecipe)recipe.get());
        }
        return recipes;
    }

    @Override
    public org.bukkit.entity.Entity getShoulderEntityLeft() {
        if (!this.getHandle().func_192023_dk().isEmpty()) {
            Optional shoulder = EntityType.func_220330_a((CompoundNBT)this.getHandle().func_192023_dk(), (World)this.getHandle().field_70170_p);
            return !shoulder.isPresent() ? null : ((Entity)shoulder.get()).getBukkitEntity();
        }
        return null;
    }

    @Override
    public void setShoulderEntityLeft(org.bukkit.entity.Entity entity) {
        this.getHandle().func_192029_h(entity == null ? new CompoundNBT() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    @Override
    public org.bukkit.entity.Entity getShoulderEntityRight() {
        if (!this.getHandle().func_192025_dl().isEmpty()) {
            Optional shoulder = EntityType.func_220330_a((CompoundNBT)this.getHandle().func_192025_dl(), (World)this.getHandle().field_70170_p);
            return !shoulder.isPresent() ? null : ((Entity)shoulder.get()).getBukkitEntity();
        }
        return null;
    }

    @Override
    public void setShoulderEntityRight(org.bukkit.entity.Entity entity) {
        this.getHandle().func_192031_i(entity == null ? new CompoundNBT() : ((CraftEntity)entity).save());
        if (entity != null) {
            entity.remove();
        }
    }

    @Override
    public boolean dropItem(boolean dropAll) {
        return this.getHandle().func_225609_n_(dropAll);
    }

    @Override
    public float getExhaustion() {
        return this.getHandle().func_71024_bL().field_75126_c;
    }

    @Override
    public void setExhaustion(float value) {
        this.getHandle().func_71024_bL().field_75126_c = value;
    }

    @Override
    public float getSaturation() {
        return this.getHandle().func_71024_bL().field_75125_b;
    }

    @Override
    public void setSaturation(float value) {
        this.getHandle().func_71024_bL().field_75125_b = value;
    }

    @Override
    public int getFoodLevel() {
        return this.getHandle().func_71024_bL().field_75127_a;
    }

    @Override
    public void setFoodLevel(int value) {
        this.getHandle().func_71024_bL().field_75127_a = value;
    }

    @Override
    public int getSaturatedRegenRate() {
        return this.getHandle().func_71024_bL().saturatedRegenRate;
    }

    @Override
    public void setSaturatedRegenRate(int i) {
        this.getHandle().func_71024_bL().saturatedRegenRate = i;
    }

    @Override
    public int getUnsaturatedRegenRate() {
        return this.getHandle().func_71024_bL().unsaturatedRegenRate;
    }

    @Override
    public void setUnsaturatedRegenRate(int i) {
        this.getHandle().func_71024_bL().unsaturatedRegenRate = i;
    }

    @Override
    public int getStarvationRate() {
        return this.getHandle().func_71024_bL().starvationRate;
    }

    @Override
    public void setStarvationRate(int i) {
        this.getHandle().func_71024_bL().starvationRate = i;
    }
}

