/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.entity;

import com.google.common.base.Preconditions;
import net.minecraft.block.Blocks;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.Direction;
import org.apache.commons.lang.Validate;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHanging;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;

public class CraftItemFrame
extends CraftHanging
implements ItemFrame {
    public CraftItemFrame(CraftServer server, ItemFrameEntity entity) {
        super(server, (HangingEntity)entity);
    }

    @Override
    public boolean setFacingDirection(BlockFace face, boolean force) {
        ItemFrameEntity hanging = this.getHandle();
        Direction oldDir = hanging.func_174811_aO();
        Direction newDir = CraftBlock.blockFaceToNotch(face);
        this.getHandle().func_174859_a(newDir);
        if (!force && !hanging.func_70518_d()) {
            hanging.func_174859_a(oldDir);
            return false;
        }
        this.update();
        return true;
    }

    @Override
    protected void update() {
        super.update();
        for (EntityDataManager.DataEntry dataItem : this.getHandle().func_184212_Q().func_187231_c()) {
            this.getHandle().func_184212_Q().markDirty(dataItem.func_187205_a());
        }
        this.getHandle().func_130014_f_().func_175666_e(this.getHandle().field_174861_a, Blocks.field_150350_a);
    }

    @Override
    public void setItem(ItemStack item) {
        this.setItem(item, true);
    }

    @Override
    public void setItem(ItemStack item, boolean playSound) {
        this.getHandle().setItem(CraftItemStack.asNMSCopy(item), true, playSound);
    }

    @Override
    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().func_82335_i());
    }

    @Override
    public float getItemDropChance() {
        return this.getHandle().field_82337_e;
    }

    @Override
    public void setItemDropChance(float chance) {
        Preconditions.checkArgument(0.0 <= (double)chance && (double)chance <= 1.0, "Chance outside range [0, 1]");
        this.getHandle().field_82337_e = chance;
    }

    @Override
    public Rotation getRotation() {
        return this.toBukkitRotation(this.getHandle().func_82333_j());
    }

    Rotation toBukkitRotation(int value) {
        switch (value) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_45;
            }
            case 2: {
                return Rotation.CLOCKWISE;
            }
            case 3: {
                return Rotation.CLOCKWISE_135;
            }
            case 4: {
                return Rotation.FLIPPED;
            }
            case 5: {
                return Rotation.FLIPPED_45;
            }
            case 6: {
                return Rotation.COUNTER_CLOCKWISE;
            }
            case 7: {
                return Rotation.COUNTER_CLOCKWISE_45;
            }
        }
        throw new AssertionError((Object)("Unknown rotation " + value + " for " + this.getHandle()));
    }

    @Override
    public void setRotation(Rotation rotation) {
        Validate.notNull((Object)((Object)rotation), (String)"Rotation cannot be null");
        this.getHandle().func_82336_g(CraftItemFrame.toInteger(rotation));
    }

    static int toInteger(Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE_45: {
                return 1;
            }
            case CLOCKWISE: {
                return 2;
            }
            case CLOCKWISE_135: {
                return 3;
            }
            case FLIPPED: {
                return 4;
            }
            case FLIPPED_45: {
                return 5;
            }
            case COUNTER_CLOCKWISE: {
                return 6;
            }
            case COUNTER_CLOCKWISE_45: {
                return 7;
            }
        }
        throw new IllegalArgumentException((Object)((Object)rotation) + " is not applicable to an ItemFrame");
    }

    @Override
    public boolean isVisible() {
        return !this.getHandle().func_82150_aj();
    }

    @Override
    public void setVisible(boolean visible) {
        this.getHandle().func_82142_c(!visible);
    }

    @Override
    public boolean isFixed() {
        return this.getHandle().field_234259_an_;
    }

    @Override
    public void setFixed(boolean fixed) {
        this.getHandle().field_234259_an_ = fixed;
    }

    public ItemFrameEntity getHandle() {
        return (ItemFrameEntity)this.entity;
    }

    @Override
    public String toString() {
        return "CraftItemFrame{item=" + this.getItem() + ", rotation=" + (Object)((Object)this.getRotation()) + "}";
    }

    @Override
    public EntityType getType() {
        return EntityType.ITEM_FRAME;
    }
}

