/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.entity;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftProjectile;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.potion.CraftPotionUtil;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class CraftThrownPotion
extends CraftProjectile
implements ThrownPotion {
    public CraftThrownPotion(CraftServer server, PotionEntity entity) {
        super(server, (ProjectileEntity)entity);
    }

    @Override
    public Collection<PotionEffect> getEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EffectInstance effect : PotionUtils.func_185189_a((net.minecraft.item.ItemStack)this.getHandle().func_213882_k())) {
            builder.add(CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    @Override
    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().func_213882_k());
    }

    @Override
    public void setItem(ItemStack item) {
        Validate.notNull((Object)item, (String)"ItemStack cannot be null.");
        Validate.isTrue((item.getType() == Material.LINGERING_POTION || item.getType() == Material.SPLASH_POTION ? 1 : 0) != 0, (String)("ItemStack must be a lingering or splash potion. This item stack was " + item.getType() + "."));
        this.getHandle().func_213884_b(CraftItemStack.asNMSCopy(item));
    }

    public PotionEntity getHandle() {
        return (PotionEntity)this.entity;
    }

    @Override
    public EntityType getType() {
        return EntityType.SPLASH_POTION;
    }
}

