/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.generator;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import org.bukkit.craftbukkit.v1_16_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_16_R3.generator.CraftChunkData;
import org.bukkit.craftbukkit.v1_16_R3.generator.InternalChunkGenerator;
import org.bukkit.generator.ChunkGenerator;

public class CustomChunkGenerator
extends InternalChunkGenerator {
    private final ChunkGenerator delegate;
    private final org.bukkit.generator.ChunkGenerator generator;
    private final ServerWorld world;
    private final Random random = new Random();

    public CustomChunkGenerator(ServerWorld world, ChunkGenerator delegate, org.bukkit.generator.ChunkGenerator generator) {
        super(delegate.func_202090_b(), delegate.func_235957_b_());
        this.world = world;
        this.delegate = delegate;
        this.generator = generator;
    }

    public void func_242706_a(Registry<Biome> iregistry, IChunk ichunkaccess) {
    }

    public BiomeProvider func_202090_b() {
        return this.delegate.func_202090_b();
    }

    public void func_235953_a_(ISeedReader generatoraccessseed, StructureManager structuremanager, IChunk ichunkaccess) {
        this.delegate.func_235953_a_(generatoraccessseed, structuremanager, ichunkaccess);
    }

    public int func_230356_f_() {
        return this.delegate.func_230356_f_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_225551_a_(WorldGenRegion regionlimitedworldaccess, IChunk ichunkaccess) {
        ChunkGenerator.ChunkData data;
        int x = ichunkaccess.func_76632_l().field_77276_a;
        int z = ichunkaccess.func_76632_l().field_77275_b;
        this.random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        CustomBiomeGrid biomegrid = new CustomBiomeGrid(new BiomeContainer((IObjectIntIterable)this.world.func_241828_r().func_243612_b(Registry.field_239720_u_), ichunkaccess.func_76632_l(), this.func_202090_b()));
        if (this.generator.isParallelCapable()) {
            data = this.generator.generateChunkData(this.world.getWorld(), this.random, x, z, biomegrid);
        } else {
            CustomChunkGenerator customChunkGenerator = this;
            synchronized (customChunkGenerator) {
                data = this.generator.generateChunkData(this.world.getWorld(), this.random, x, z, biomegrid);
            }
        }
        Preconditions.checkArgument(data instanceof CraftChunkData, "Plugins must use createChunkData(World) rather than implementing ChunkData: %s", (Object)data);
        CraftChunkData craftData = (CraftChunkData)data;
        ChunkSection[] sections = craftData.getRawChunkData();
        ChunkSection[] csect = ichunkaccess.func_76587_i();
        int scnt = Math.min(csect.length, sections.length);
        int sec = 0;
        while (sec < scnt) {
            if (sections[sec] != null) {
                ChunkSection section;
                csect[sec] = section = sections[sec];
            }
            ++sec;
        }
        ((ChunkPrimer)ichunkaccess).func_225548_a_(biomegrid.biome);
        if (craftData.getTiles() != null) {
            for (BlockPos pos : craftData.getTiles()) {
                int tz;
                int ty;
                int tx = pos.func_177958_n();
                Block block = craftData.getTypeId(tx, ty = pos.func_177956_o(), tz = pos.func_177952_p()).func_177230_c();
                if (!block.func_235695_q_()) continue;
                TileEntity tile = ((ITileEntityProvider)block).func_196283_a_((IBlockReader)this.world);
                ichunkaccess.func_177426_a(new BlockPos((x << 4) + tx, ty, (z << 4) + tz), tile);
            }
        }
    }

    public void func_242707_a(DynamicRegistries iregistrycustom, StructureManager structuremanager, IChunk ichunkaccess, TemplateManager definedstructuremanager, long i) {
        if (this.generator.shouldGenerateStructures()) {
            this.delegate.func_242707_a(iregistrycustom, structuremanager, ichunkaccess, definedstructuremanager, i);
        }
    }

    public void func_230350_a_(long i, BiomeManager biomemanager, IChunk ichunkaccess, GenerationStage.Carving worldgenstage_features) {
        if (this.generator.shouldGenerateCaves()) {
            this.delegate.func_230350_a_(i, biomemanager, ichunkaccess, worldgenstage_features);
        }
    }

    public void func_230352_b_(IWorld generatoraccess, StructureManager structuremanager, IChunk ichunkaccess) {
    }

    public int func_222529_a(int i, int j, Heightmap.Type heightmap_type) {
        return this.delegate.func_222529_a(i, j, heightmap_type);
    }

    public void func_230351_a_(WorldGenRegion regionlimitedworldaccess, StructureManager structuremanager) {
        if (this.generator.shouldGenerateDecorations()) {
            this.delegate.func_230351_a_(regionlimitedworldaccess, structuremanager);
        }
    }

    public void func_230354_a_(WorldGenRegion regionlimitedworldaccess) {
        if (this.generator.shouldGenerateMobs()) {
            this.delegate.func_230354_a_(regionlimitedworldaccess);
        }
    }

    public int func_205470_d() {
        return this.delegate.func_205470_d();
    }

    public int func_230355_e_() {
        return this.delegate.func_230355_e_();
    }

    public IBlockReader func_230348_a_(int i, int j) {
        return this.delegate.func_230348_a_(i, j);
    }

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        throw new UnsupportedOperationException("Cannot serialize CustomChunkGenerator");
    }

    private class CustomBiomeGrid
    implements ChunkGenerator.BiomeGrid {
        private final BiomeContainer biome;

        public CustomBiomeGrid(BiomeContainer biome) {
            this.biome = biome;
        }

        @Override
        public org.bukkit.block.Biome getBiome(int x, int z) {
            return this.getBiome(x, 0, z);
        }

        @Override
        public void setBiome(int x, int z, org.bukkit.block.Biome bio) {
            int y = 0;
            while (y < CustomChunkGenerator.this.world.getWorld().getMaxHeight()) {
                this.setBiome(x, y, z, bio);
                y += 4;
            }
        }

        @Override
        public org.bukkit.block.Biome getBiome(int x, int y, int z) {
            return CraftBlock.biomeBaseToBiome((Registry<Biome>)((Registry)this.biome.field_242704_g), this.biome.func_225526_b_(x >> 2, y >> 2, z >> 2));
        }

        @Override
        public void setBiome(int x, int y, int z, org.bukkit.block.Biome bio) {
            Preconditions.checkArgument(bio != org.bukkit.block.Biome.CUSTOM, "Cannot set the biome to %s", (Object)bio);
            this.biome.setBiome(x >> 2, y >> 2, z >> 2, CraftBlock.biomeToBiomeBase((Registry<Biome>)((Registry)this.biome.field_242704_g), bio));
        }
    }
}

