/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.inventory;

import java.util.Arrays;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.crafting.IRecipe;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;

public class CraftInventoryCrafting
extends CraftInventory
implements CraftingInventory {
    private final IInventory resultInventory;

    public CraftInventoryCrafting(IInventory inventory, IInventory resultInventory) {
        super(inventory);
        this.resultInventory = resultInventory;
    }

    public IInventory getResultInventory() {
        return this.resultInventory;
    }

    public IInventory getMatrixInventory() {
        return this.inventory;
    }

    @Override
    public int getSize() {
        return this.getResultInventory().func_70302_i_() + this.getMatrixInventory().func_70302_i_();
    }

    @Override
    public void setContents(ItemStack[] items) {
        if (this.getSize() > items.length) {
            throw new IllegalArgumentException("Invalid inventory size; expected " + this.getSize() + " or less");
        }
        this.setContents(items[0], Arrays.copyOfRange(items, 1, items.length));
    }

    @Override
    public ItemStack[] getContents() {
        ItemStack[] items = new ItemStack[this.getSize()];
        List mcResultItems = this.getResultInventory().getContents();
        int i = 0;
        i = 0;
        while (i < mcResultItems.size()) {
            items[i] = CraftItemStack.asCraftMirror((net.minecraft.item.ItemStack)mcResultItems.get(i));
            ++i;
        }
        List mcItems = this.getMatrixInventory().getContents();
        int j = 0;
        while (j < mcItems.size()) {
            items[i + j] = CraftItemStack.asCraftMirror((net.minecraft.item.ItemStack)mcItems.get(j));
            ++j;
        }
        return items;
    }

    public void setContents(ItemStack result, ItemStack[] contents) {
        this.setResult(result);
        this.setMatrix(contents);
    }

    @Override
    public CraftItemStack getItem(int index) {
        if (index < this.getResultInventory().func_70302_i_()) {
            net.minecraft.item.ItemStack item = this.getResultInventory().func_70301_a(index);
            return item.func_190926_b() ? null : CraftItemStack.asCraftMirror(item);
        }
        net.minecraft.item.ItemStack item = this.getMatrixInventory().func_70301_a(index - this.getResultInventory().func_70302_i_());
        return item.func_190926_b() ? null : CraftItemStack.asCraftMirror(item);
    }

    @Override
    public void setItem(int index, ItemStack item) {
        if (index < this.getResultInventory().func_70302_i_()) {
            this.getResultInventory().func_70299_a(index, CraftItemStack.asNMSCopy(item));
        } else {
            this.getMatrixInventory().func_70299_a(index - this.getResultInventory().func_70302_i_(), CraftItemStack.asNMSCopy(item));
        }
    }

    @Override
    public ItemStack[] getMatrix() {
        List matrix = this.getMatrixInventory().getContents();
        return this.asCraftMirror(matrix);
    }

    @Override
    public ItemStack getResult() {
        net.minecraft.item.ItemStack item = this.getResultInventory().func_70301_a(0);
        if (!item.func_190926_b()) {
            return CraftItemStack.asCraftMirror(item);
        }
        return null;
    }

    @Override
    public void setMatrix(ItemStack[] contents) {
        if (this.getMatrixInventory().func_70302_i_() > contents.length) {
            throw new IllegalArgumentException("Invalid inventory size; expected " + this.getMatrixInventory().func_70302_i_() + " or less");
        }
        int i = 0;
        while (i < this.getMatrixInventory().func_70302_i_()) {
            if (i < contents.length) {
                this.getMatrixInventory().func_70299_a(i, CraftItemStack.asNMSCopy(contents[i]));
            } else {
                this.getMatrixInventory().func_70299_a(i, net.minecraft.item.ItemStack.field_190927_a);
            }
            ++i;
        }
    }

    @Override
    public void setResult(ItemStack item) {
        List contents = this.getResultInventory().getContents();
        contents.set(0, CraftItemStack.asNMSCopy(item));
    }

    @Override
    public Recipe getRecipe() {
        IRecipe recipe = this.getInventory().getCurrentRecipe();
        return recipe == null ? null : recipe.toBukkitRecipe();
    }
}

