/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.inventory;

import com.google.common.base.Preconditions;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.inventory.MerchantRecipe;

public class CraftMerchantRecipe
extends MerchantRecipe {
    private final MerchantOffer handle;

    public CraftMerchantRecipe(MerchantOffer merchantRecipe) {
        super(CraftItemStack.asBukkitCopy(merchantRecipe.field_222225_c), 0);
        this.handle = merchantRecipe;
        this.addIngredient(CraftItemStack.asBukkitCopy(merchantRecipe.field_222223_a));
        this.addIngredient(CraftItemStack.asBukkitCopy(merchantRecipe.field_222224_b));
    }

    public CraftMerchantRecipe(org.bukkit.inventory.ItemStack result, int uses, int maxUses, boolean experienceReward, int experience, float priceMultiplier) {
        super(result, uses, maxUses, experienceReward, experience, priceMultiplier);
        this.handle = new MerchantOffer(ItemStack.field_190927_a, ItemStack.field_190927_a, CraftItemStack.asNMSCopy(result), uses, maxUses, experience, priceMultiplier, this);
        this.setExperienceReward(experienceReward);
    }

    @Override
    public int getUses() {
        return this.handle.field_222226_d;
    }

    @Override
    public void setUses(int uses) {
        this.handle.field_222226_d = uses;
    }

    @Override
    public int getMaxUses() {
        return this.handle.field_222227_e;
    }

    @Override
    public void setMaxUses(int maxUses) {
        this.handle.field_222227_e = maxUses;
    }

    @Override
    public boolean hasExperienceReward() {
        return this.handle.field_222228_f;
    }

    @Override
    public void setExperienceReward(boolean flag) {
        this.handle.field_222228_f = flag;
    }

    @Override
    public int getVillagerExperience() {
        return this.handle.field_222232_j;
    }

    @Override
    public void setVillagerExperience(int villagerExperience) {
        this.handle.field_222232_j = villagerExperience;
    }

    @Override
    public float getPriceMultiplier() {
        return this.handle.field_222231_i;
    }

    @Override
    public void setPriceMultiplier(float priceMultiplier) {
        this.handle.field_222231_i = priceMultiplier;
    }

    public MerchantOffer toMinecraft() {
        List<org.bukkit.inventory.ItemStack> ingredients = this.getIngredients();
        Preconditions.checkState(!ingredients.isEmpty(), "No offered ingredients");
        this.handle.field_222223_a = CraftItemStack.asNMSCopy(ingredients.get(0));
        if (ingredients.size() > 1) {
            this.handle.field_222224_b = CraftItemStack.asNMSCopy(ingredients.get(1));
        }
        return this.handle;
    }

    public static CraftMerchantRecipe fromBukkit(MerchantRecipe recipe) {
        if (recipe instanceof CraftMerchantRecipe) {
            return (CraftMerchantRecipe)recipe;
        }
        CraftMerchantRecipe craft = new CraftMerchantRecipe(recipe.getResult(), recipe.getUses(), recipe.getMaxUses(), recipe.hasExperienceReward(), recipe.getVillagerExperience(), recipe.getPriceMultiplier());
        craft.setIngredients(recipe.getIngredients());
        return craft;
    }
}

