/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.inventory;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.SkullTileEntity;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftMetaItem;
import org.bukkit.inventory.meta.SkullMeta;

@DelegateDeserialization(value=CraftMetaItem.SerializableMeta.class)
public class CraftMetaSkull
extends CraftMetaItem
implements SkullMeta {
    static final CraftMetaItem.ItemMetaKey SKULL_PROFILE = new CraftMetaItem.ItemMetaKey("SkullProfile");
    static final CraftMetaItem.ItemMetaKey SKULL_OWNER = new CraftMetaItem.ItemMetaKey("SkullOwner", "skull-owner");
    static final int MAX_OWNER_LENGTH = 16;
    private GameProfile profile;
    private CompoundNBT serializedProfile;

    public CraftMetaSkull(CraftMetaItem meta) {
        super(meta);
        if (!(meta instanceof CraftMetaSkull)) {
            return;
        }
        CraftMetaSkull skullMeta = (CraftMetaSkull)meta;
        this.setProfile(skullMeta.profile);
    }

    CraftMetaSkull(CompoundNBT tag) {
        super(tag);
        if (tag.func_150297_b(CraftMetaSkull.SKULL_OWNER.NBT, 10)) {
            this.setProfile(NBTUtil.func_152459_a((CompoundNBT)tag.func_74775_l(CraftMetaSkull.SKULL_OWNER.NBT)));
        } else if (tag.func_150297_b(CraftMetaSkull.SKULL_OWNER.NBT, 8) && !tag.func_74779_i(CraftMetaSkull.SKULL_OWNER.NBT).isEmpty()) {
            this.setProfile(new GameProfile(null, tag.func_74779_i(CraftMetaSkull.SKULL_OWNER.NBT)));
        }
    }

    CraftMetaSkull(Map<String, Object> map) {
        super(map);
        if (this.profile == null) {
            this.setOwner(CraftMetaItem.SerializableMeta.getString(map, CraftMetaSkull.SKULL_OWNER.BUKKIT, true));
        }
    }

    @Override
    void deserializeInternal(CompoundNBT tag, Object context) {
        super.deserializeInternal(tag, context);
        if (tag.func_150297_b(CraftMetaSkull.SKULL_PROFILE.NBT, 10)) {
            CompoundNBT skullTag = tag.func_74775_l(CraftMetaSkull.SKULL_PROFILE.NBT);
            if (skullTag.func_150297_b("Id", 8)) {
                UUID uuid = UUID.fromString(skullTag.func_74779_i("Id"));
                skullTag.func_186854_a("Id", uuid);
            }
            this.setProfile(NBTUtil.func_152459_a((CompoundNBT)skullTag));
        }
    }

    @Override
    void serializeInternal(Map<String, INBT> internalTags) {
        if (this.profile != null) {
            internalTags.put(CraftMetaSkull.SKULL_PROFILE.NBT, (INBT)this.serializedProfile);
        }
    }

    private void setProfile(GameProfile profile) {
        this.profile = profile;
        this.serializedProfile = profile == null ? null : NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)profile);
    }

    @Override
    void applyToItem(CompoundNBT tag) {
        super.applyToItem(tag);
        if (this.profile != null) {
            this.setProfile((GameProfile)Futures.getUnchecked(SkullTileEntity.b((GameProfile)this.profile, Predicates.alwaysTrue(), (boolean)true)));
            tag.func_218657_a(CraftMetaSkull.SKULL_OWNER.NBT, (INBT)this.serializedProfile);
        }
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.isSkullEmpty();
    }

    boolean isSkullEmpty() {
        return this.profile == null;
    }

    @Override
    boolean applicableTo(Material type) {
        switch (type) {
            case SKELETON_SKULL: 
            case WITHER_SKELETON_SKULL: 
            case PLAYER_HEAD: 
            case ZOMBIE_HEAD: 
            case CREEPER_HEAD: 
            case DRAGON_HEAD: 
            case SKELETON_WALL_SKULL: 
            case WITHER_SKELETON_WALL_SKULL: 
            case ZOMBIE_WALL_HEAD: 
            case PLAYER_WALL_HEAD: 
            case CREEPER_WALL_HEAD: 
            case DRAGON_WALL_HEAD: {
                return true;
            }
        }
        return false;
    }

    @Override
    public CraftMetaSkull clone() {
        return (CraftMetaSkull)super.clone();
    }

    @Override
    public boolean hasOwner() {
        return this.profile != null && this.profile.getName() != null;
    }

    @Override
    public String getOwner() {
        return this.hasOwner() ? this.profile.getName() : null;
    }

    @Override
    public OfflinePlayer getOwningPlayer() {
        if (this.hasOwner()) {
            if (this.profile.getId() != null) {
                return Bukkit.getOfflinePlayer(this.profile.getId());
            }
            if (this.profile.getName() != null) {
                return Bukkit.getOfflinePlayer(this.profile.getName());
            }
        }
        return null;
    }

    @Override
    public boolean setOwner(String name) {
        if (name != null && name.length() > 16) {
            return false;
        }
        if (name == null) {
            this.setProfile(null);
        } else {
            this.setProfile(new GameProfile(null, name));
        }
        return true;
    }

    @Override
    public boolean setOwningPlayer(OfflinePlayer owner) {
        if (owner == null) {
            this.setProfile(null);
        } else if (owner instanceof CraftPlayer) {
            this.setProfile(((CraftPlayer)owner).getProfile());
        } else {
            this.setProfile(new GameProfile(owner.getUniqueId(), owner.getName()));
        }
        return true;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.hasOwner()) {
            hash = 61 * hash + this.profile.hashCode();
        }
        return original != hash ? CraftMetaSkull.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaSkull) {
            CraftMetaSkull that = (CraftMetaSkull)meta;
            return this.profile != null ? that.profile != null && this.serializedProfile.equals((Object)that.serializedProfile) : that.profile == null;
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaSkull || this.isSkullEmpty());
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.hasOwner()) {
            return builder.put(CraftMetaSkull.SKULL_OWNER.BUKKIT, this.profile.getName());
        }
        return builder;
    }
}

