/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.potion;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class CraftPotionUtil {
    private static final BiMap<PotionType, String> regular = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put((Object)PotionType.UNCRAFTABLE, "empty")).put((Object)PotionType.WATER, "water")).put((Object)PotionType.MUNDANE, "mundane")).put((Object)PotionType.THICK, "thick")).put((Object)PotionType.AWKWARD, "awkward")).put((Object)PotionType.NIGHT_VISION, "night_vision")).put((Object)PotionType.INVISIBILITY, "invisibility")).put((Object)PotionType.JUMP, "leaping")).put((Object)PotionType.FIRE_RESISTANCE, "fire_resistance")).put((Object)PotionType.SPEED, "swiftness")).put((Object)PotionType.SLOWNESS, "slowness")).put((Object)PotionType.WATER_BREATHING, "water_breathing")).put((Object)PotionType.INSTANT_HEAL, "healing")).put((Object)PotionType.INSTANT_DAMAGE, "harming")).put((Object)PotionType.POISON, "poison")).put((Object)PotionType.REGEN, "regeneration")).put((Object)PotionType.STRENGTH, "strength")).put((Object)PotionType.WEAKNESS, "weakness")).put((Object)PotionType.LUCK, "luck")).put((Object)PotionType.TURTLE_MASTER, "turtle_master")).put((Object)PotionType.SLOW_FALLING, "slow_falling")).build();
    private static final BiMap<PotionType, String> upgradeable = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put((Object)PotionType.JUMP, "strong_leaping")).put((Object)PotionType.SPEED, "strong_swiftness")).put((Object)PotionType.INSTANT_HEAL, "strong_healing")).put((Object)PotionType.INSTANT_DAMAGE, "strong_harming")).put((Object)PotionType.POISON, "strong_poison")).put((Object)PotionType.REGEN, "strong_regeneration")).put((Object)PotionType.STRENGTH, "strong_strength")).put((Object)PotionType.SLOWNESS, "strong_slowness")).put((Object)PotionType.TURTLE_MASTER, "strong_turtle_master")).build();
    private static final BiMap<PotionType, String> extendable = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put((Object)PotionType.NIGHT_VISION, "long_night_vision")).put((Object)PotionType.INVISIBILITY, "long_invisibility")).put((Object)PotionType.JUMP, "long_leaping")).put((Object)PotionType.FIRE_RESISTANCE, "long_fire_resistance")).put((Object)PotionType.SPEED, "long_swiftness")).put((Object)PotionType.SLOWNESS, "long_slowness")).put((Object)PotionType.WATER_BREATHING, "long_water_breathing")).put((Object)PotionType.POISON, "long_poison")).put((Object)PotionType.REGEN, "long_regeneration")).put((Object)PotionType.STRENGTH, "long_strength")).put((Object)PotionType.WEAKNESS, "long_weakness")).put((Object)PotionType.TURTLE_MASTER, "long_turtle_master")).put((Object)PotionType.SLOW_FALLING, "long_slow_falling")).build();

    public static String fromBukkit(PotionData data) {
        String type = data.isUpgraded() ? (String)upgradeable.get((Object)data.getType()) : (data.isExtended() ? (String)extendable.get((Object)data.getType()) : (String)regular.get((Object)data.getType()));
        Preconditions.checkNotNull(type, "Unknown potion type from data " + data);
        return "minecraft:" + type;
    }

    public static PotionData toBukkit(String type) {
        if (type == null) {
            return new PotionData(PotionType.UNCRAFTABLE, false, false);
        }
        if (type.startsWith("minecraft:")) {
            type = type.substring(10);
        }
        PotionType potionType = null;
        potionType = (PotionType)((Object)extendable.inverse().get(type));
        if (potionType != null) {
            return new PotionData(potionType, true, false);
        }
        potionType = (PotionType)((Object)upgradeable.inverse().get(type));
        if (potionType != null) {
            return new PotionData(potionType, false, true);
        }
        potionType = (PotionType)((Object)regular.inverse().get(type));
        if (potionType != null) {
            return new PotionData(potionType, false, false);
        }
        return new PotionData(PotionType.UNCRAFTABLE, false, false);
    }

    public static EffectInstance fromBukkit(PotionEffect effect) {
        Effect type = Effect.func_188412_a((int)effect.getType().getId());
        return new EffectInstance(type, effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles());
    }

    public static PotionEffect toBukkit(EffectInstance effect) {
        PotionEffectType type = PotionEffectType.getById(Effect.func_188409_a((Effect)effect.func_188419_a()));
        int amp = effect.func_76458_c();
        int duration = effect.func_76459_b();
        boolean ambient = effect.func_82720_e();
        boolean particles = effect.func_188418_e();
        return new PotionEffect(type, duration, amp, ambient, particles);
    }

    public static boolean equals(Effect mobEffect, PotionEffectType type) {
        PotionEffectType typeV = PotionEffectType.getById(Effect.func_188409_a((Effect)mobEffect));
        return typeV.equals(type);
    }
}

