/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_16_R3.scoreboard;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;

final class CraftCriteria {
    static final Map<String, CraftCriteria> DEFAULTS;
    static final CraftCriteria DUMMY;
    final ScoreCriteria criteria;
    final String bukkitName;

    static {
        ImmutableMap.Builder<String, CraftCriteria> defaults = ImmutableMap.builder();
        for (Map.Entry entry : ScoreCriteria.field_96643_a.entrySet()) {
            String name = entry.getKey().toString();
            ScoreCriteria criteria = (ScoreCriteria)entry.getValue();
            defaults.put(name, new CraftCriteria(criteria));
        }
        DEFAULTS = defaults.build();
        DUMMY = DEFAULTS.get("dummy");
    }

    private CraftCriteria(String bukkitName) {
        this.bukkitName = bukkitName;
        this.criteria = CraftCriteria.DUMMY.criteria;
    }

    private CraftCriteria(ScoreCriteria criteria) {
        this.criteria = criteria;
        this.bukkitName = criteria.func_96636_a();
    }

    static CraftCriteria getFromNMS(ScoreObjective objective) {
        return DEFAULTS.get(objective.func_96680_c().func_96636_a());
    }

    static CraftCriteria getFromBukkit(String name) {
        CraftCriteria criteria = DEFAULTS.get(name);
        if (criteria != null) {
            return criteria;
        }
        return new CraftCriteria(name);
    }

    public boolean equals(Object that) {
        if (!(that instanceof CraftCriteria)) {
            return false;
        }
        return ((CraftCriteria)that).bukkitName.equals(this.bukkitName);
    }

    public int hashCode() {
        return this.bukkitName.hashCode() ^ CraftCriteria.class.hashCode();
    }
}

